/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activity.service.ISfaActivityExecutionService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.ActivityDisplayStepExecuteDataResp;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.visitstep.mapper.SfaVisitStepActivityExecutionMapper;
import com.biz.crm.visitstep.model.SfaVisitStepActivityCostExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityDisplayExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityCostExecutionEsDataRepositories;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityDisplayExecutionEsDataRepositories;
import com.biz.crm.visitstep.req.GetCompleteActivityPageReq;
import com.biz.crm.visitstep.req.GetCompleteActivityReq;
import com.biz.crm.visitstep.req.GetCompleteActivityTablePageReq;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.resp.SfaVisitStepStoreCostActivityTableRespVo;
import com.biz.crm.visitstep.resp.SfaVisitStepStoreDisplayActivityTableRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SfaVisitStepActivityExecutionServiceEsImpl {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepActivityExecutionServiceEsImpl.class);
    @Resource
    private SfaVisitStepActivityDisplayExecutionEsDataRepositories sfaVisitStepActivityDisplayExecutionEsDataRepositories;
    @Resource
    private SfaVisitStepActivityCostExecutionEsDataRepositories sfaVisitStepActivityCostExecutionEsDataRepositories;
    @Resource
    private SfaVisitStepActivityExecutionMapper sfaVisitStepActivityExecutionMapper;
    @Resource
    private ISfaActivityExecutionService sfaActivityExecutionService;
    @Resource
    private ISfaVisitStepFromService sfaVisitStepFromService;

    public PageResult<SfaVisitStepActivityExecutionRespVo> getCompleteActivityPage(GetCompleteActivityPageReq req) {
        Page page = PageUtil.buildPage((Integer)req.getPageNum(), (Integer)req.getPageSize());
        GetCompleteActivityTablePageReq reqVo = (GetCompleteActivityTablePageReq)((Object)CrmBeanUtil.copy((Object)((Object)req), GetCompleteActivityTablePageReq.class));
        reqVo.setActivityStartTimeOne(req.getStartActivityStartTime());
        reqVo.setActivityStartTimeTwo(req.getEndActivityStartTime());
        reqVo.setActivityEndTimeOne(req.getEndActivityStartTime());
        reqVo.setActivityEndTimeTwo(req.getEndActivityEndTime());
        if (SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal().equals(req.getActivityType())) {
            reqVo.setActivityType(SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal());
            List<SfaVisitStepActivityExecutionRespVo> respVos = this.sfaVisitStepActivityExecutionMapper.findTableList((Page<SfaVisitStepActivityExecutionRespVo>)page, reqVo);
            return PageResult.builder().data(respVos).count(Long.valueOf(page.getTotal())).build();
        }
        reqVo.setActivityType(SfaVisitEnum.visitStep.VISIT_STEP_COST.getVal());
        List<SfaVisitStepActivityExecutionRespVo> respVos = this.sfaVisitStepActivityExecutionMapper.findTableList((Page<SfaVisitStepActivityExecutionRespVo>)page, reqVo);
        return PageResult.builder().data(respVos).count(Long.valueOf(page.getTotal())).build();
    }

    public List<SfaVisitStepActivityCostExecutionEsData> getCompleteCostActivityList(GetCompleteActivityReq req) {
        Iterable list = this.sfaVisitStepActivityCostExecutionEsDataRepositories.search((QueryBuilder)req.buildQuery());
        return Lists.newArrayList((Iterable)list);
    }

    public Set<String> getCompleteCostActivityIdsBeforeDate(String stepCode, String clientCode, LocalDate date) {
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setEndActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + "23:59:59");
        return this.getCompleteCostActivityList(req).stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toSet());
    }

    public Set<String> getCompleteCostActivityIdsAfterDate(String stepCode, String clientCode, LocalDate date) {
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setStartActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + "00:00:00");
        return this.getCompleteCostActivityList(req).stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toSet());
    }

    public List<SfaVisitStepActivityDisplayExecutionEsData> getCompleteDisplayActivityList(GetCompleteActivityReq req) {
        Iterable list = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search((QueryBuilder)req.buildQuery());
        return Lists.newArrayList((Iterable)list);
    }

    public Set<String> getCompleteDisplayActivityIdsBeforeDate(String stepCode, String clientCode, LocalDate date) {
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setEndActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + "23:59:59");
        return this.getCompleteDisplayActivityList(req).stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toSet());
    }

    public SfaVisitStepActivityDisplayExecutionEsData getLastActivityTimeRecord(String stepCode, String clientCode, LocalDateTime activityTime, String currentId) {
        if (StringUtils.isBlank((CharSequence)stepCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6b65\u9aa4\u7f16\u7801");
        }
        if (StringUtils.isBlank((CharSequence)clientCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5ba2\u6237\u7f16\u7801");
        }
        if (null == activityTime) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6267\u884c\u65f6\u95f4");
        }
        List entities = this.sfaVisitStepActivityExecutionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaVisitStepActivityExecutionEntity.class).le(SfaVisitStepActivityExecutionEntity::getActivityTime, (Object)activityTime)).eq(SfaVisitStepActivityExecutionEntity::getClientCode, (Object)clientCode)).eq(SfaVisitStepActivityExecutionEntity::getStepCode, (Object)stepCode)).orderByDesc(SfaVisitStepActivityExecutionEntity::getActivityTime));
        List list = CrmBeanUtil.copyList((List)entities, SfaVisitStepActivityDisplayExecutionEsData.class);
        if (list.size() > 0) {
            SfaVisitStepActivityDisplayExecutionEsData data;
            SfaVisitStepActivityDisplayExecutionEsData dataCurrent = (SfaVisitStepActivityDisplayExecutionEsData)list.get(0);
            SfaVisitStepActivityDisplayExecutionEsData sfaVisitStepActivityDisplayExecutionEsData = data = list.size() > 1 ? (SfaVisitStepActivityDisplayExecutionEsData)list.get(1) : null;
            if (dataCurrent.getId().equals(currentId)) {
                return data;
            }
            return dataCurrent;
        }
        return null;
    }

    public Set<String> getCompleteDisplayActivityIdsAfterDate(String stepCode, String clientCode, LocalDate date) {
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setStartActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + "00:00:00");
        return this.getCompleteDisplayActivityList(req).stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toSet());
    }

    @EsDataPermission(userName="userName.keyword", position="posCode.keyword", org="orgCode.keyword", customer="clientCode.keyword")
    public PageResult<SfaVisitStepStoreCostActivityTableRespVo> findVisitStepCostActivityExecutionEsList(GetCompleteActivityTablePageReq req) {
        Page page = PageUtil.buildPage((Integer)req.getPageNum(), (Integer)req.getPageSize());
        req.setActivityType("cost");
        List<SfaVisitStepActivityExecutionRespVo> list = this.sfaVisitStepActivityExecutionMapper.findTableList((Page<SfaVisitStepActivityExecutionRespVo>)page, req);
        return PageResult.builder().data(CrmBeanUtil.copyList(list, SfaVisitStepStoreCostActivityTableRespVo.class)).count(Long.valueOf(page.getTotal())).build();
    }

    public SfaVisitStepActivityCostExecutionEsData findVisitStepCostActivityExecutionDetailEs(String id) {
        SfaVisitStepActivityExecutionEntity entity = (SfaVisitStepActivityExecutionEntity)this.sfaVisitStepActivityExecutionMapper.selectById((Serializable)((Object)id));
        SfaVisitStepActivityDisplayExecutionEsData result = (SfaVisitStepActivityDisplayExecutionEsData)CrmBeanUtil.copy((Object)entity, SfaVisitStepActivityDisplayExecutionEsData.class);
        if (ObjectUtils.isEmpty((Object)result)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6267\u884c\u6570\u636e\uff01");
        }
        this.buildData(result);
        SfaVisitStepActivityDisplayExecutionEsData detail = this.findVisitStepDisplayActivityExecutionDetailEs(id);
        return (SfaVisitStepActivityCostExecutionEsData)CrmBeanUtil.copy((Object)detail, SfaVisitStepActivityCostExecutionEsData.class);
    }

    @EsDataPermission(userName="userName.keyword", position="posCode.keyword", org="orgCode.keyword", customer="clientCode.keyword")
    public PageResult<SfaVisitStepStoreDisplayActivityTableRespVo> findVisitStepDisplayActivityExecutionEsList(GetCompleteActivityTablePageReq req) {
        Page page = PageUtil.buildPage((Integer)req.getPageNum(), (Integer)req.getPageSize());
        req.setActivityType("display");
        List<SfaVisitStepActivityExecutionRespVo> list = this.sfaVisitStepActivityExecutionMapper.findTableList((Page<SfaVisitStepActivityExecutionRespVo>)page, req);
        return PageResult.builder().data(CrmBeanUtil.copyList(list, SfaVisitStepStoreDisplayActivityTableRespVo.class)).count(Long.valueOf(page.getTotal())).build();
    }

    public SfaVisitStepActivityDisplayExecutionEsData findVisitStepDisplayActivityExecutionDetailEs(String id) {
        SfaVisitStepActivityExecutionEntity entity = (SfaVisitStepActivityExecutionEntity)this.sfaVisitStepActivityExecutionMapper.selectById((Serializable)((Object)id));
        SfaVisitStepActivityDisplayExecutionEsData result = (SfaVisitStepActivityDisplayExecutionEsData)CrmBeanUtil.copy((Object)entity, SfaVisitStepActivityDisplayExecutionEsData.class);
        if (ObjectUtils.isEmpty((Object)result)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6267\u884c\u6570\u636e\uff01");
        }
        this.buildData(result);
        return result;
    }

    protected void buildRequire(List<String> requireList, SfaVisitStepActivityDisplayExecutionEsData result) {
        ArrayList require = Lists.newArrayList();
        requireList.forEach(v -> {
            ActivityStepExecuteData.ActivityRequireReqVo vo;
            if (SfaActivityEnum.activityRequire.ACTIVITY_PIC.getVal().equals(v)) {
                vo = new ActivityStepExecuteData.ActivityRequireReqVo();
                List<SfaAttachmentEntity> pics0 = SfaAttachmentUtil.getList(AttachmentBizTypeEnum.ACTIVITY_REQUIRE0.getVal(), result.getId());
                vo.setActivityRequire(SfaActivityEnum.activityRequire.ACTIVITY_PIC.getVal());
                vo.setActivityRequireName(SfaActivityEnum.activityRequire.ACTIVITY_PIC.getDesc());
                vo.setPictureList(CrmBeanUtil.copyList(pics0, CrmAttachment.class));
                require.add(vo);
            }
            if (SfaActivityEnum.activityRequire.DOOR_PIC.getVal().equals(v)) {
                vo = new ActivityStepExecuteData.ActivityRequireReqVo();
                List<SfaAttachmentEntity> pics1 = SfaAttachmentUtil.getList(AttachmentBizTypeEnum.ACTIVITY_REQUIRE1.getVal(), result.getId());
                vo.setActivityRequire(SfaActivityEnum.activityRequire.DOOR_PIC.getVal());
                vo.setActivityRequireName(SfaActivityEnum.activityRequire.DOOR_PIC.getDesc());
                vo.setPictureList(CrmBeanUtil.copyList(pics1, CrmAttachment.class));
                require.add(vo);
            }
            if (SfaActivityEnum.activityRequire.DISPLAY_PIC.getVal().equals(v)) {
                vo = new ActivityStepExecuteData.ActivityRequireReqVo();
                List<SfaAttachmentEntity> pics2 = SfaAttachmentUtil.getList(AttachmentBizTypeEnum.ACTIVITY_REQUIRE2.getVal(), result.getId());
                vo.setActivityRequire(SfaActivityEnum.activityRequire.DISPLAY_PIC.getVal());
                vo.setActivityRequireName(SfaActivityEnum.activityRequire.DISPLAY_PIC.getDesc());
                vo.setPictureList(CrmBeanUtil.copyList(pics2, CrmAttachment.class));
                require.add(vo);
            }
        });
        result.setActivityRequireReqVoList(require);
    }

    protected void buildData(SfaVisitStepActivityDisplayExecutionEsData result) {
        ActivityDisplayStepExecuteDataResp.DisplayContent displayContent = new ActivityDisplayStepExecuteDataResp.DisplayContent();
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.sfaActivityExecutionService.queryDetailById(result.getActivityExecutionId());
        displayContent.setActivityProductList(sfaActivityExecutionRespVo.getActivityProductList());
        List visitPictureList = sfaActivityExecutionRespVo.getVisitPictureList();
        List pictureList = CrmAttachment.convertVisitPic((List)visitPictureList);
        displayContent.setPictureList(pictureList);
        result.setDisplayContent(displayContent);
        result.setActivityDesc(sfaActivityExecutionRespVo.getActivityDesc());
        if (SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(sfaActivityExecutionRespVo.getActivityType())) {
            result.setSalesVolume(sfaActivityExecutionRespVo.getSalesVolume());
            result.setApplyAmount(sfaActivityExecutionRespVo.getApplyAmount());
        }
        String[] activityRequire2 = sfaActivityExecutionRespVo.getActivityRequire().split(",");
        ArrayList requireList = Lists.newArrayList();
        Collections.addAll(requireList, activityRequire2);
        this.buildRequire(requireList, result);
    }

    protected void buildForm(SfaVisitStepActivityDisplayExecutionEsData result, String formId) {
        SfaVisitStepFromRespVo fromRespVo = this.sfaVisitStepFromService.queryById(formId);
        result.setSfaVisitStepFrom(fromRespVo);
    }
}

