/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.base;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class SfaClientHelper {
    private static MdmTerminalFeign mdmTerminalFeign = (MdmTerminalFeign)SpringApplicationContextUtil.getApplicationContext().getBean(MdmTerminalFeign.class);
    private static MdmCustomerMsgFeign mdmCustomerMsgFeign = (MdmCustomerMsgFeign)SpringApplicationContextUtil.getApplicationContext().getBean(MdmCustomerMsgFeign.class);

    public static PageResult<SfaClientData> loadTerminalClientDataByOrgCodes(List<String> orgCodes, int pageNum, int pageSize) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return SfaClientHelper.emptyPage();
        }
        MdmTerminalVo vo = new MdmTerminalVo();
        vo.setOrgCodeList(orgCodes);
        vo.setPageNum(Integer.valueOf(pageNum));
        vo.setPageSize(Integer.valueOf(pageSize));
        return SfaClientHelper.loadTerminalClientDataByParams(vo);
    }

    public static PageResult<SfaClientData> loadTerminalClientDataByChannelCodes(List<String> channelCodes, int pageNum, int pageSize) {
        if (CollectionUtils.isEmpty(channelCodes)) {
            return SfaClientHelper.emptyPage();
        }
        MdmTerminalVo vo = new MdmTerminalVo();
        vo.setChannelList(channelCodes);
        vo.setPageNum(Integer.valueOf(pageNum));
        vo.setPageSize(Integer.valueOf(pageSize));
        return SfaClientHelper.loadTerminalClientDataByParams(vo);
    }

    private static PageResult<SfaClientData> emptyPage() {
        PageResult sfaClientDataPageResult = PageResult.builder().build();
        sfaClientDataPageResult.setData((List)Lists.newArrayList());
        sfaClientDataPageResult.setCount(Long.valueOf(0L));
        return sfaClientDataPageResult;
    }

    private static PageResult<SfaClientData> loadTerminalClientDataByParams(MdmTerminalVo vo) {
        PageResult sfaClientDataPageResult = PageResult.builder().build();
        PageResult pageResult = (PageResult)ApiResultUtil.objResult((Result)mdmTerminalFeign.page(vo), (boolean)true);
        List mdmTerminalVos = pageResult.getData();
        List sfaClientDataList = mdmTerminalVos.stream().map(v -> SfaClientHelper.buildTerminalClientData(v)).collect(Collectors.toList());
        sfaClientDataPageResult.setData(sfaClientDataList);
        sfaClientDataPageResult.setCount(pageResult.getCount());
        return sfaClientDataPageResult;
    }

    public static SfaClientData loadClientData(String clientType2, String clientCode) {
        if (StringUtils.isEmpty((String)clientType2)) {
            throw new BusinessException("\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (SfaVisitEnum.ClientType.DEALER.getVal().equals(clientType2)) {
            return SfaClientHelper.loadDealerClientDataRequired(clientCode);
        }
        return SfaClientHelper.loadTerminalClientDataRequired(clientCode);
    }

    public static SfaClientData loadClientDataNotRequired(String clientType2, String clientCode) {
        if (StringUtils.isEmpty((String)clientType2)) {
            throw new BusinessException("\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (SfaVisitEnum.ClientType.DEALER.getVal().equals(clientType2)) {
            return SfaClientHelper.loadDealerClientDataNotRequired(clientCode);
        }
        return SfaClientHelper.loadTerminalClientDataNotRequired(clientCode);
    }

    public static List<SfaClientData> loadClientDataList(List<String> customerCodes, List<String> terminalCodes) {
        List<SfaClientData> list = SfaClientHelper.loadDealerClientDataList(customerCodes);
        list.addAll(SfaClientHelper.loadTerminalClientDataList(terminalCodes));
        return list;
    }

    public static Map<String, SfaClientData> loadClientDataMap(List<String> customerCodes, List<String> terminalCodes) {
        List<SfaClientData> list = SfaClientHelper.loadDealerClientDataList(customerCodes);
        list.addAll(SfaClientHelper.loadTerminalClientDataList(terminalCodes));
        Map<String, SfaClientData> map = list.stream().collect(Collectors.toMap(v -> v.getClientType() + v.getClientCode(), v -> v, (o, o2) -> o2));
        return map;
    }

    private static List<SfaClientData> loadDealerClientDataList(final List<String> customerCodes) {
        if (CollectionUtils.isEmpty(customerCodes)) {
            return Lists.newArrayList();
        }
        Result customerResult = mdmCustomerMsgFeign.customerContactPage(new MdmCustomerContactPageReqVo(){
            {
                this.setCustomerCodeList(customerCodes);
                this.setPageSize(-1);
            }
        });
        List list = ((PageResult)ApiResultUtil.objResult((Result)customerResult, (boolean)true)).getData();
        return list.stream().map(v -> {
            SfaClientData sfaClientData = new SfaClientData();
            sfaClientData.setClientCode(v.getCustomerCode());
            sfaClientData.setClientType(SfaVisitEnum.ClientType.DEALER.getVal());
            sfaClientData.setClientTypeName(SfaVisitEnum.ClientType.DEALER.getDesc());
            sfaClientData.setClientAddress(v.getRegisteredAddress());
            sfaClientData.setClientPhone(v.getContactPhone());
            sfaClientData.setClientContacts(v.getContactName());
            if (StringUtils.isNotEmpty((String)v.getLongitude()) && StringUtils.isNotEmpty((String)v.getLatitude())) {
                sfaClientData.setLongitude(new BigDecimal(v.getLongitude().trim()));
                sfaClientData.setLatitude(new BigDecimal(v.getLatitude().trim()));
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)v.getCustomerType())) {
                // empty if block
            }
            sfaClientData.setClientName(v.getCustomerName());
            sfaClientData.setClientSubclass(v.getCustomerType());
            sfaClientData.setClientSubclassName(v.getCustomerTypeName());
            return sfaClientData;
        }).collect(Collectors.toList());
    }

    private static List<SfaClientData> loadTerminalClientDataList(final List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return Lists.newArrayList();
        }
        Result terminalResult = mdmTerminalFeign.terminalContactPage(new MdmTerminalContactPageReqVo(){
            {
                this.setTerminalCodeList(terminalCodes);
                this.setPageSize(-1);
            }
        });
        List list = ((PageResult)ApiResultUtil.objResult((Result)terminalResult, (boolean)true)).getData();
        return list.stream().map(v -> {
            SfaClientData sfaClientData = new SfaClientData();
            sfaClientData.setClientCode(v.getTerminalCode());
            sfaClientData.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
            sfaClientData.setClientTypeName(SfaVisitEnum.ClientType.TERMINAL.getDesc());
            sfaClientData.setClientAddress(v.getTerminalAddress());
            sfaClientData.setClientPhone(v.getContactPhone());
            sfaClientData.setClientContacts(v.getContactName());
            sfaClientData.setClientPhoto(v.getShopImagePath());
            if (StringUtils.isNotEmpty((String)v.getLongitude()) && StringUtils.isNotEmpty((String)v.getLatitude())) {
                sfaClientData.setLongitude(new BigDecimal(v.getLongitude().trim()));
                sfaClientData.setLatitude(new BigDecimal(v.getLatitude().trim()));
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)v.getTerminalType())) {
                // empty if block
            }
            sfaClientData.setClientName(v.getTerminalName());
            sfaClientData.setClientSubclass(v.getTerminalType());
            sfaClientData.setClientSubclassName(v.getTerminalTypeName());
            return sfaClientData;
        }).collect(Collectors.toList());
    }

    private static SfaClientData loadDealerClientDataRequired(String clientCode) {
        if (StringUtils.isEmpty((String)clientCode)) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
        }
        MdmCustomerMsgRespVo client = (MdmCustomerMsgRespVo)ApiResultUtil.objResult((Result)mdmCustomerMsgFeign.query(null, clientCode), (boolean)true);
        if (null == client) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u5ba2\u6237[" + clientCode + "]");
        }
        return SfaClientHelper.buildDealerClientData(client);
    }

    private static SfaClientData loadDealerClientDataNotRequired(String clientCode) {
        if (StringUtils.isEmpty((String)clientCode)) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
        }
        MdmCustomerMsgRespVo client = (MdmCustomerMsgRespVo)ApiResultUtil.objResult((Result)mdmCustomerMsgFeign.query(null, clientCode), (boolean)true);
        if (null == client) {
            return null;
        }
        return SfaClientHelper.buildDealerClientData(client);
    }

    private static SfaClientData buildDealerClientData(MdmCustomerMsgRespVo client) {
        SfaClientData sfaClientData = (SfaClientData)CrmBeanUtil.copy((Object)client, SfaClientData.class);
        sfaClientData.setClientCode(client.getCustomerCode());
        sfaClientData.setClientType(SfaVisitEnum.ClientType.DEALER.getVal());
        sfaClientData.setClientTypeName(SfaVisitEnum.ClientType.DEALER.getDesc());
        sfaClientData.setClientAddress(client.getRegisteredAddress());
        List mdmCustomerContactVos = client.getMdmCustomerContactVos();
        if (!CollectionUtils.isEmpty((Collection)mdmCustomerContactVos)) {
            sfaClientData.setClientPhone(((MdmCustomerContactRespVo)mdmCustomerContactVos.get(0)).getContactPhone());
            sfaClientData.setClientContacts(((MdmCustomerContactRespVo)mdmCustomerContactVos.get(0)).getContactName());
        }
        if (StringUtils.isNotEmpty((String)client.getLongitude()) && StringUtils.isNotEmpty((String)client.getLatitude())) {
            sfaClientData.setLongitude(new BigDecimal(client.getLongitude().trim()));
            sfaClientData.setLatitude(new BigDecimal(client.getLatitude().trim()));
        }
        sfaClientData.setClientName(client.getCustomerName());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)client.getCustomerType())) {
            // empty if block
        }
        sfaClientData.setClientSubclass(client.getCustomerType());
        sfaClientData.setClientSubclassName(client.getCustomerTypeName());
        return sfaClientData;
    }

    private static SfaClientData loadTerminalClientDataRequired(String clientCode) {
        if (StringUtils.isEmpty((String)clientCode)) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
        }
        MdmTerminalVo client = (MdmTerminalVo)ApiResultUtil.objResult((Result)mdmTerminalFeign.query(null, clientCode), (boolean)true);
        if (null == client) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u5ba2\u6237[" + clientCode + "]");
        }
        return SfaClientHelper.buildTerminalClientData(client);
    }

    private static SfaClientData loadTerminalClientDataNotRequired(String clientCode) {
        if (StringUtils.isEmpty((String)clientCode)) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
        }
        MdmTerminalVo client = (MdmTerminalVo)ApiResultUtil.objResult((Result)mdmTerminalFeign.query(null, clientCode), (boolean)true);
        if (null == client) {
            return null;
        }
        return SfaClientHelper.buildTerminalClientData(client);
    }

    private static SfaClientData buildTerminalClientData(MdmTerminalVo client) {
        SfaClientData sfaClientData = (SfaClientData)CrmBeanUtil.copy((Object)client, SfaClientData.class);
        sfaClientData.setClientCode(client.getTerminalCode());
        sfaClientData.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
        sfaClientData.setClientTypeName(SfaVisitEnum.ClientType.TERMINAL.getDesc());
        sfaClientData.setClientAddress(client.getTerminalAddress());
        List mdmTerminalContactVos = client.getContacts();
        if (!CollectionUtils.isEmpty((Collection)mdmTerminalContactVos)) {
            sfaClientData.setClientPhone(((MdmTerminalContactVo)mdmTerminalContactVos.get(0)).getContactPhone());
            sfaClientData.setClientContacts(((MdmTerminalContactVo)mdmTerminalContactVos.get(0)).getContactName());
        }
        sfaClientData.setClientPhoto(client.getShopImagePath());
        if (StringUtils.isNotEmpty((String)client.getLongitude()) && StringUtils.isNotEmpty((String)client.getLatitude())) {
            sfaClientData.setLongitude(new BigDecimal(client.getLongitude().trim()));
            sfaClientData.setLatitude(new BigDecimal(client.getLatitude().trim()));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)client.getTerminalType())) {
            // empty if block
        }
        sfaClientData.setClientName(client.getTerminalName());
        sfaClientData.setClientSubclass(client.getTerminalType());
        sfaClientData.setClientSubclassName(client.getTerminalTypeName());
        return sfaClientData;
    }
}

