/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.req;

import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitstep.req.VisitStepPageReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

@ApiModel(value="\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u62a5\u8868")
public class GetOrderPageTableReq
extends VisitStepPageReq {
    @ApiModelProperty(value="\u8ba2\u5355\u7f16\u53f7")
    private String orderCode;
    @ApiModelProperty(value="\u5ba2\u6237\u7f16\u7801")
    private String clientCode;
    @ApiModelProperty(value="\u5ba2\u6237\u540d\u79f0")
    private String clientName;
    @ApiModelProperty(value="\u4eba\u5458\u540d\u79f0")
    private String realName;
    @ApiModelProperty(value="\u8ba2\u5355\u72b6\u6001")
    private String approvalStatus;
    @ApiModelProperty(value="\u8ba2\u5355\u6765\u6e90")
    private String orderSourceName;
    @ApiModelProperty(value="\u4e0b\u5355\u65f6\u95f4\u2014\u2014\u6309\u6708\u7b5b\u9009")
    private String yearMonth;
    @ApiModelProperty(value="\u5f00\u59cb\u65f6\u95f4")
    private String startDate;
    @ApiModelProperty(value="\u7ed3\u675f\u65f6\u95f4")
    private String endDate;

    public NativeSearchQuery buildQuery() {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        if (StringUtils.isNotEmpty((String)this.getClientCode())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientCode.keyword", (String)this.getClientCode()));
        }
        if (StringUtils.isNotEmpty((String)this.getOrderCode())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderCode.keyword", (String)this.getOrderCode()));
        }
        if (StringUtils.isNotEmpty((String)this.getRealName())) {
            builder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"realName", (Object)this.getRealName()));
        }
        if (StringUtils.isNotEmpty((String)this.getApprovalStatus())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"approvalStatus", (String)this.getApprovalStatus()));
        }
        if (StringUtils.isNotEmpty((String)this.getOrderSourceName())) {
            builder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"orderSourceName", (Object)this.getOrderSourceName()));
        }
        if (StringUtils.isNotEmpty((String)this.getClientName())) {
            builder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"clientName", (Object)this.getClientName()));
        }
        if (StringUtils.isNotEmpty((String)this.getYearMonth())) {
            Date firstDayOfMonth = DateUtil.getFirstDayOfMonth((Date)DateUtil.str2Date((String)this.getYearMonth(), (SimpleDateFormat)DateUtil.yyyy_MM));
            Date lastDayOfMonth = DateUtil.getLastDayOfMonth((Date)DateUtil.str2Date((String)this.getYearMonth(), (SimpleDateFormat)DateUtil.yyyy_MM));
            String firstFormat = DateUtil.format((Date)firstDayOfMonth, (String)"yyyy-MM-dd HH:mm:ss");
            String lastFormat = DateUtil.format((Date)lastDayOfMonth, (String)"yyyy-MM-dd HH:mm:ss");
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"orderTime").gte((Object)firstFormat));
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"orderTime").lte((Object)lastFormat));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.getStartDate())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"orderTime").gte((Object)this.getStartDate()));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.getEndDate())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"orderTime").lte((Object)this.getEndDate()));
        }
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)(this.getPageNum() - 1), (int)this.getPageSize()));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"orderTime").order(SortOrder.DESC));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public String getClientCode() {
        return this.clientCode;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getRealName() {
        return this.realName;
    }

    public String getApprovalStatus() {
        return this.approvalStatus;
    }

    public String getOrderSourceName() {
        return this.orderSourceName;
    }

    public String getYearMonth() {
        return this.yearMonth;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public void setApprovalStatus(String approvalStatus) {
        this.approvalStatus = approvalStatus;
    }

    public void setOrderSourceName(String orderSourceName) {
        this.orderSourceName = orderSourceName;
    }

    public void setYearMonth(String yearMonth) {
        this.yearMonth = yearMonth;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetOrderPageTableReq)) {
            return false;
        }
        GetOrderPageTableReq other = (GetOrderPageTableReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$orderCode = this.getOrderCode();
        String other$orderCode = other.getOrderCode();
        if (this$orderCode == null ? other$orderCode != null : !this$orderCode.equals(other$orderCode)) {
            return false;
        }
        String this$clientCode = this.getClientCode();
        String other$clientCode = other.getClientCode();
        if (this$clientCode == null ? other$clientCode != null : !this$clientCode.equals(other$clientCode)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$realName = this.getRealName();
        String other$realName = other.getRealName();
        if (this$realName == null ? other$realName != null : !this$realName.equals(other$realName)) {
            return false;
        }
        String this$approvalStatus = this.getApprovalStatus();
        String other$approvalStatus = other.getApprovalStatus();
        if (this$approvalStatus == null ? other$approvalStatus != null : !this$approvalStatus.equals(other$approvalStatus)) {
            return false;
        }
        String this$orderSourceName = this.getOrderSourceName();
        String other$orderSourceName = other.getOrderSourceName();
        if (this$orderSourceName == null ? other$orderSourceName != null : !this$orderSourceName.equals(other$orderSourceName)) {
            return false;
        }
        String this$yearMonth = this.getYearMonth();
        String other$yearMonth = other.getYearMonth();
        if (this$yearMonth == null ? other$yearMonth != null : !this$yearMonth.equals(other$yearMonth)) {
            return false;
        }
        String this$startDate = this.getStartDate();
        String other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) {
            return false;
        }
        String this$endDate = this.getEndDate();
        String other$endDate = other.getEndDate();
        return !(this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetOrderPageTableReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $orderCode = this.getOrderCode();
        result = result * 59 + ($orderCode == null ? 43 : $orderCode.hashCode());
        String $clientCode = this.getClientCode();
        result = result * 59 + ($clientCode == null ? 43 : $clientCode.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $realName = this.getRealName();
        result = result * 59 + ($realName == null ? 43 : $realName.hashCode());
        String $approvalStatus = this.getApprovalStatus();
        result = result * 59 + ($approvalStatus == null ? 43 : $approvalStatus.hashCode());
        String $orderSourceName = this.getOrderSourceName();
        result = result * 59 + ($orderSourceName == null ? 43 : $orderSourceName.hashCode());
        String $yearMonth = this.getYearMonth();
        result = result * 59 + ($yearMonth == null ? 43 : $yearMonth.hashCode());
        String $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
        String $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "GetOrderPageTableReq(orderCode=" + this.getOrderCode() + ", clientCode=" + this.getClientCode() + ", clientName=" + this.getClientName() + ", realName=" + this.getRealName() + ", approvalStatus=" + this.getApprovalStatus() + ", orderSourceName=" + this.getOrderSourceName() + ", yearMonth=" + this.getYearMonth() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ")";
    }
}

