/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cache.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.StringUtils;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SfaWorkSignRuleInfoUtil {
    public static final String redisKey = "SFA_WORK_SIGN_RULE_INFO:v1:";
    @Autowired
    private RedisService redisService;
    @Resource
    private ISfaWorkSignRuleInfoService iSfaWorkSignRuleInfoService;

    public String getKey(String userName, String ruleDate) {
        if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)ruleDate)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        return redisKey + userName + ruleDate;
    }

    public void deleteKey(String userName, String ruleDate) {
        this.redisService.del(new String[]{this.getKey(userName, ruleDate)});
    }

    public void setObj(SfaWorkSignRuleInfoEntity vo, String key) {
        this.redisService.setDays(key, (Object)vo, 30L);
    }

    public SfaWorkSignRuleInfoEntity getObj(String userName, String ruleDate) {
        SfaWorkSignRuleInfoEntity entity = this.iSfaWorkSignRuleInfoService.findByUserNameAndRuleDate(userName, ruleDate);
        return entity;
    }

    public SfaWorkSignRuleInfoEntity compensate(String userName, String ruleDate) {
        if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)ruleDate)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        String key = this.getKey(userName, ruleDate);
        SfaWorkSignRuleInfoEntity entity = this.iSfaWorkSignRuleInfoService.findByUserNameAndRuleDate(userName, ruleDate);
        if (entity == null) {
            entity = new SfaWorkSignRuleInfoEntity();
        }
        this.setObj(entity, key);
        return entity;
    }
}

