/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.assistant.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.assistant.mapper.SfaWorkTaskReceveMapper;
import com.biz.crm.assistant.mapper.SfaWorkTaskReleaseMapper;
import com.biz.crm.assistant.model.SfaWorkTaskReceveEntity;
import com.biz.crm.assistant.model.SfaWorkTaskReleaseEntity;
import com.biz.crm.assistant.service.ISfaWorkTaskObjectService;
import com.biz.crm.assistant.service.ISfaWorkTaskReceveService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaTaskReleaseEnum;
import com.biz.crm.enums.SfaTaskStatusEnum;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReceveReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReportReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReceveRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReportRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
@ConditionalOnMissingBean(name={"SfaWorkTaskReceveServiceExpandImpl"})
public class SfaWorkTaskReceveServiceImpl
extends ServiceImpl<SfaWorkTaskReceveMapper, SfaWorkTaskReceveEntity>
implements ISfaWorkTaskReceveService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkTaskReceveServiceImpl.class);
    @Resource
    private SfaWorkTaskReceveMapper sfaWorkTaskReceveMapper;
    @Resource
    private SfaWorkTaskReleaseMapper sfaWorkTaskReleaseMapper;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private ISfaWorkTaskObjectService sfaWorkTaskObjectService;

    @Override
    public PageResult<SfaWorkTaskReceveRespVo> findList(SfaWorkTaskReceveReqVo reqVo) throws Exception {
        UserRedis user = UserUtils.getUser();
        String username = user.getUsername();
        reqVo.setReceverCode(username);
        reqVo.setCreateOrgCode(user.getOrgcode());
        reqVo.setCreatePosCode(user.getPoscode());
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkTaskReceveRespVo> list = this.sfaWorkTaskReceveMapper.findList((Page<SfaWorkTaskReceveRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaWorkTaskReceveRespVo> findDayList(SfaWorkTaskReceveReqVo reqVo) throws Exception {
        AssertUtils.isNotEmpty((String)reqVo.getQueryDate(), (String)"\u8bf7\u8f93\u5165\u65e5\u671f");
        AssertUtils.isNotEmpty((String)reqVo.getReceverCode(), (String)"\u8981\u67e5\u8be2\u7684\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        UserRedis user = UserUtils.getUser();
        String username = user.getUsername();
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkTaskReceveRespVo> list = this.sfaWorkTaskReceveMapper.findOffTheStocks((Page<SfaWorkTaskReceveRespVo>)page, reqVo);
        Iterator<SfaWorkTaskReceveRespVo> iterator = list.iterator();
        boolean sum = false;
        while (iterator.hasNext()) {
            SfaWorkTaskReceveRespVo next = iterator.next();
            if (!SfaTaskStatusEnum.WAIT_EXECUTE.getCode().equals(next.getExecuteStatus())) continue;
            if (!username.equals(next.getReceverCode())) {
                next.setCheckStatus("0");
                continue;
            }
            next.setCheckStatus("1");
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public Map findDayPlan(SfaWorkTaskReceveReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getQueryDate(), (String)"\u8bf7\u8f93\u5165\u65e5\u671f");
        AssertUtils.isNotEmpty((String)reqVo.getReceverCode(), (String)"\u8981\u67e5\u8be2\u7684\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> date = this.sfaWorkTaskReceveMapper.findStatusByQueryDate(reqVo.getCreatePosCode(), reqVo.getCreateOrgCode(), reqVo.getQueryDate(), reqVo.getReceverCode());
        int sum = 0;
        int size = 0;
        if (!CollectionUtil.listEmpty(date)) {
            size = date.size();
        }
        for (String s : date) {
            if (!SfaTaskStatusEnum.EXECUTE_LODING.getCode().equals(s)) continue;
            ++sum;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put("molecule", sum);
        map.put("denominator", size);
        return map;
    }

    @Override
    public void save(SfaWorkTaskReceveReqVo reqVo) {
        SfaWorkTaskReceveEntity entity = (SfaWorkTaskReceveEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkTaskReceveEntity.class));
        this.save((Object)entity);
    }

    @Override
    public void update(SfaWorkTaskReceveReqVo reqVo) {
        this.checkSfaWorkRrceverReqVo(reqVo);
        SfaWorkTaskReceveEntity entity = (SfaWorkTaskReceveEntity)((Object)this.getById((Serializable)((Object)reqVo.getReceveId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u5f53\u524d\u8bb0\u5f55\u65e0\u76f8\u5173\u6570\u636e");
        }
        entity.setAddress(reqVo.getAddress());
        entity.setSummary(reqVo.getSummary());
        entity.setExecuteStatus(reqVo.getExecuteStatus());
        this.updateById((Object)entity);
        List<SfaWorkTaskReceveRespVo> byTaskId = this.sfaWorkTaskReceveMapper.findListByTaskId(entity.getTaskId());
        if (byTaskId != null && byTaskId.size() > 0) {
            String[] status = this.getStatus(byTaskId, entity.getId(), reqVo.getExecuteStatus());
            SfaWorkTaskReleaseEntity releaseEntity = new SfaWorkTaskReleaseEntity();
            releaseEntity.setId(entity.getTaskId());
            releaseEntity.setProgress(status[0]);
            releaseEntity.setTaskStatus(status[1]);
            this.sfaWorkTaskReleaseMapper.updateById((Object)releaseEntity);
        }
        List pictures = reqVo.getPictures();
        SfaAttachmentUtil.insert(CrmAttachment.convertTaskPic((List)pictures), AttachmentBizTypeEnum.TASK_EXECUTE, entity.getId());
    }

    @Override
    public PageResult<SfaWorkTaskReportRespVo> findSfaWorkTaskReportList(SfaWorkTaskReportReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        String orgCode = UserUtils.getUser().getOrgcode();
        if (StringUtils.isEmpty((String)orgCode)) {
            return PageResult.builder().data((List)Lists.newArrayList()).count(Long.valueOf(page.getTotal())).build();
        }
        List<SfaWorkTaskReportRespVo> sfaWorkTaskReportRespVoList = this.sfaWorkTaskReleaseMapper.findSfaWorkTaskReportList((Page<SfaWorkTaskReportRespVo>)page, reqVo);
        sfaWorkTaskReportRespVoList.forEach(data -> {
            List<SfaAttachmentEntity> sendTaskPicList;
            List<SfaAttachmentEntity> executePicUrlList = SfaAttachmentUtil.getList(AttachmentBizTypeEnum.TASK_EXECUTE.getVal(), data.getId());
            if (CollectionUtil.listNotEmptyNotSizeZero(executePicUrlList)) {
                data.setExecuteTaskPicList(executePicUrlList.stream().map(SfaAttachmentEntity::getUrl).collect(Collectors.toList()));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(sendTaskPicList = SfaAttachmentUtil.getList(AttachmentBizTypeEnum.TASK_ADD.getVal(), data.getTaskId()))) {
                data.setSendTaskPicList(sendTaskPicList.stream().map(SfaAttachmentEntity::getUrl).collect(Collectors.toList()));
            }
        });
        return PageResult.builder().data(sfaWorkTaskReportRespVoList).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaWorkTaskReportRespVo findSfaWorkTaskReportById(final String id) {
        if (!StringUtils.isNotEmpty((String)id)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaWorkTaskReportRespVoList = this.findSfaWorkTaskReportList(new SfaWorkTaskReportReqVo(){
            {
                this.setId(id);
            }
        }).getData();
        SfaWorkTaskReportRespVo sfaWorkTaskReportRespVo = null;
        if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaWorkTaskReportRespVoList)) {
            sfaWorkTaskReportRespVo = (SfaWorkTaskReportRespVo)sfaWorkTaskReportRespVoList.get(0);
        }
        return sfaWorkTaskReportRespVo;
    }

    private void checkSfaWorkRrceverReqVo(SfaWorkTaskReceveReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getReceveId(), (String)"\u5165\u53c2receveId\u4e0d\u80fd\u4e3a\u7a7a");
        if (SfaTaskStatusEnum.EXECUTE_LODING.getCode().equals(reqVo.getExecuteStatus())) {
            AssertUtils.isNotEmpty((String)reqVo.getSummary(), (String)"\u8bf7\u8f93\u5165\u6267\u884c\u603b\u7ed3");
        }
        AssertUtils.isNotEmpty((String)reqVo.getExecuteStatus(), (String)"\u8bf7\u8f93\u5165\u6267\u884c\u7ed3\u679c");
    }

    private String[] getStatus(List<SfaWorkTaskReceveRespVo> receveRespVos, String id, String exStatus) {
        boolean b;
        int toPerformNum = 0;
        int offTheStocksNum = 0;
        int submittedNum = 0;
        int haveExpiredNum = 0;
        String[] list = new String[]{"", ""};
        int size = receveRespVos.size();
        for (SfaWorkTaskReceveRespVo next : receveRespVos) {
            if (id.equals(next.getReceveId())) {
                next.setExecuteStatus(exStatus);
            }
            switch (next.getExecuteStatus()) {
                case "0": {
                    ++toPerformNum;
                    break;
                }
                case "1": {
                    ++offTheStocksNum;
                    break;
                }
                case "2": {
                    ++submittedNum;
                    break;
                }
                case "3": {
                    ++haveExpiredNum;
                    break;
                }
            }
        }
        boolean bl = b = offTheStocksNum == size || offTheStocksNum + submittedNum == size;
        if (offTheStocksNum > 0 && b) {
            list[0] = size + "/" + size;
            list[1] = SfaTaskReleaseEnum.EXECUTE_LODING.getCode();
            return list;
        }
        if (offTheStocksNum > 0) {
            list[0] = offTheStocksNum + "/" + size;
            list[1] = SfaTaskReleaseEnum.PARTLY_COMPLETED.getCode();
            return list;
        }
        if (offTheStocksNum == 0 && toPerformNum > 0) {
            list[0] = submittedNum + "/" + size;
            list[1] = SfaTaskReleaseEnum.WAIT_EXECUTE.getCode();
            return list;
        }
        if (submittedNum == size) {
            list[0] = size + "/" + size;
            list[1] = SfaTaskReleaseEnum.ALREADY_FINISH.getCode();
            return list;
        }
        if (haveExpiredNum == size) {
            list[0] = "0/" + size;
            list[1] = SfaTaskReleaseEnum.PAST_DUE.getCode();
            return list;
        }
        if (offTheStocksNum == 0 && toPerformNum == 0) {
            list[0] = offTheStocksNum + "/" + size;
            list[1] = SfaTaskReleaseEnum.UNFINISHED.getCode();
            return list;
        }
        return list;
    }
}

