/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.achievement.controller;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.service.SfaCustomerService;
import com.biz.crm.moblie.service.SfaTerminalService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import java.util.List;
import javax.annotation.Resource;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
@RocketMQMessageListener(topic="${rocketmq.topic}${rocketmq.environment-variable}", selectorExpression="INSERT_CLIENT_TAG", consumerGroup="INSERT_CLIENT${rocketmq.environment-variable}")
public class AchievementRocketMQConsumer
extends AbstractRocketMQConsumer {
    private static final Logger log = LoggerFactory.getLogger(AchievementRocketMQConsumer.class);
    @Resource
    protected SfaCustomerService sfaCustomerService;
    @Resource
    protected SfaTerminalService sfaTerminalService;
    @Resource
    protected MdmTerminalFeign mdmTerminalFeign;
    @Resource
    protected MdmCustomerMsgFeign mdmCustomerMsgFeign;

    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        String msg = message.getMsgBody();
        if (StringUtils.isEmpty((Object)msg)) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        List list = JsonPropertyUtil.toArray((String)msg, String.class);
        if (StringUtils.isEmpty((Object)list)) {
            return "\u8bb0\u5f55\u4e3a\u7a7a!";
        }
        this.queryTerminalOrCustomer(list);
        return "\u64cd\u4f5c\u6210\u529f";
    }

    protected void queryTerminalOrCustomer(List<String> list) {
        if (CollectionUtil.listEmpty(list)) {
            log.info("\u8ba1\u7b97\u5931\u8d25\uff0c\u7ec8\u7aef\u6216\u7ecf\u9500\u5546\u7f16\u7801\u4e3a\u7a7a");
            return;
        }
        MdmTerminalVo mdmTerminalVo = (MdmTerminalVo)ApiResultUtil.objResult((Result)this.mdmTerminalFeign.query(null, list.get(0)));
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = (MdmCustomerMsgRespVo)ApiResultUtil.objResult((Result)this.mdmCustomerMsgFeign.query(null, list.get(0)));
        if (ObjectUtils.isEmpty((Object)mdmCustomerMsgRespVo) && ObjectUtils.isEmpty((Object)mdmTerminalVo)) {
            log.info("\u672a\u83b7\u53d6\u5230\u5ba2\u6237\u6216\u7ecf\u9500\u5546\u4fe1\u606f");
        } else if (ObjectUtils.isEmpty((Object)mdmCustomerMsgRespVo)) {
            this.sfaTerminalService.countAchievementAndIntegral(mdmTerminalVo, list.get(1));
        } else if (ObjectUtils.isEmpty((Object)mdmTerminalVo)) {
            this.sfaCustomerService.countAchievementAndIntegral(mdmCustomerMsgRespVo, list.get(1));
        }
    }
}

