/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.controller;

import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.sfa.customer.req.SfaCustomerBusinessDetailReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UserUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfaBusinessDetailSaveMQSend {
    private static final Logger log = LoggerFactory.getLogger(SfaBusinessDetailSaveMQSend.class);
    private static RocketMQProducer rocketMQProducer = (RocketMQProducer)SpringApplicationContextUtil.getApplicationContext().getBean(RocketMQProducer.class);

    public static void saveBusinessDetail(List<? extends VisitStepListener.VisitStepListenerCommittedData> entities) {
        List reqVos = CrmBeanUtil.copyList(entities, SfaCustomerBusinessDetailReqVo.class);
        Map stringStringMap = DictUtil.dictMap((String)"sfa_step_code");
        reqVos.forEach(o -> {
            o.setBusinessCode(o.getId());
            o.setBusinessType((String)stringStringMap.get(o.getStepCode()));
        });
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("CUSTOMER_BUSINESS_DETAIL_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonStringNotEmptyVal((Object)reqVos));
        rocketMQMessageBody.setToken(UserUtils.getToken());
        rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }
}

