/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationUtils {
    private static final Logger log = LoggerFactory.getLogger(LocationUtils.class);
    private static double EARTH_RADIUS = 6378.137;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(BigDecimal originLon, BigDecimal originLat, BigDecimal destinationLon, BigDecimal destinationLat) {
        double radLat1 = LocationUtils.rad(Double.parseDouble(originLat.toString()));
        double radLat2 = LocationUtils.rad(Double.parseDouble(destinationLat.toString()));
        double a = radLat1 - radLat2;
        double b = LocationUtils.rad(Double.parseDouble(originLon.toString())) - LocationUtils.rad(Double.parseDouble(destinationLon.toString()));
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= EARTH_RADIUS;
        s = (double)Math.round(s * 100.0) / 100.0;
        return Math.abs(s *= 1000.0);
    }
}

