/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitGroupReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitclientRelReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitGroupRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitclientRelRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.service.impl.VisitPlanInfoHelper;
import com.biz.crm.visitnote.mapper.SfaVisitGroupMapper;
import com.biz.crm.visitnote.mapper.SfaVisitPlanMapper;
import com.biz.crm.visitnote.mapper.SfaVisitclientRelMapper;
import com.biz.crm.visitnote.model.SfaVisitGroupEntity;
import com.biz.crm.visitnote.model.SfaVisitclientRelEntity;
import com.biz.crm.visitnote.service.ISfaVisitGroupService;
import com.biz.crm.visitnote.service.ISfaVisitclientRelService;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitGroupServiceExpandImpl"})
@Transactional
public class SfaVisitGroupServiceImpl
extends ServiceImpl<SfaVisitGroupMapper, SfaVisitGroupEntity>
implements ISfaVisitGroupService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitGroupServiceImpl.class);
    @Resource
    private SfaVisitGroupMapper sfaVisitGroupMapper;
    @Resource
    private SfaVisitclientRelMapper sfaVisitclientRelMapper;
    @Resource
    private ISfaVisitclientRelService iSfaVisitclientRelService;
    @Resource
    private SfaVisitPlanMapper sfaVisitPlanMapper;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Resource
    private VisitPlanInfoHelper visitPlanInfoHelper;

    @Override
    public PageResult<SfaVisitGroupRespVo> findList(SfaVisitGroupReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitGroupRespVo> list = this.sfaVisitGroupMapper.findList((Page<SfaVisitGroupRespVo>)page, reqVo);
        final List groupCodes = list.stream().map(SfaVisitGroupRespVo::getGroupCode).collect(Collectors.toList());
        SfaVisitclientRelReqVo sfaVisitclientRelReqVo = new SfaVisitclientRelReqVo(){
            {
                this.setGroupCodes(groupCodes);
                this.setPageSize(-1);
            }
        };
        List sfaVisitclientRelRespVos = this.iSfaVisitclientRelService.findList(sfaVisitclientRelReqVo).getData();
        Map<String, List<SfaVisitclientRelRespVo>> map = sfaVisitclientRelRespVos.stream().collect(Collectors.groupingBy(SfaVisitclientRelRespVo::getGroupCode));
        list.forEach(data -> {
            data.setEnableStatusName(CrmEnableStatusEnum.getDesc((String)data.getEnableStatus()));
            List clientRelRespVoList = (List)map.get(data.getGroupCode());
            data.setClientRelNum(Integer.valueOf(clientRelRespVoList.size()));
            StringBuffer clientNames = new StringBuffer();
            for (SfaVisitclientRelRespVo clientRel : clientRelRespVoList) {
                if (clientNames.length() > 0) {
                    clientNames.append(",");
                }
                clientNames.append(clientRel.getClientName());
            }
            data.setClientNames(clientNames.toString());
        });
        this.visitPlanInfoHelper.loadUserDataForVisitGroup(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitGroupRespVo queryDetailById(final String id) {
        AssertUtils.isNotEmpty((String)id, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        SfaVisitGroupReqVo reqVo = new SfaVisitGroupReqVo(){
            {
                this.setId(id);
            }
        };
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            return new SfaVisitGroupRespVo();
        }
        SfaVisitGroupRespVo respVo = (SfaVisitGroupRespVo)list.get(0);
        SfaVisitclientRelReqVo sfaVisitclientRelReqVo = new SfaVisitclientRelReqVo();
        sfaVisitclientRelReqVo.setGroupCode(respVo.getGroupCode());
        sfaVisitclientRelReqVo.setPageSize(Integer.valueOf(-1));
        List visitclientRelRespVos = this.iSfaVisitclientRelService.findList(sfaVisitclientRelReqVo).getData();
        respVo.setSfaVisitclientRelRespVos(visitclientRelRespVos);
        return respVo;
    }

    @Override
    public SfaVisitGroupRespVo query(SfaVisitGroupReqVo reqVo) {
        if (null == reqVo || StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            return new SfaVisitGroupRespVo();
        }
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            return new SfaVisitGroupRespVo();
        }
        SfaVisitGroupRespVo respVo = (SfaVisitGroupRespVo)list.get(0);
        SfaVisitclientRelReqVo sfaVisitclientRelReqVo = new SfaVisitclientRelReqVo();
        sfaVisitclientRelReqVo.setGroupCode(respVo.getGroupCode());
        sfaVisitclientRelReqVo.setPageSize(Integer.valueOf(-1));
        List<SfaVisitclientRelRespVo> visitclientRelRespVos = this.sfaVisitclientRelMapper.findSfaVisitclientRelList(sfaVisitclientRelReqVo);
        respVo.setSfaVisitclientRelRespVos(visitclientRelRespVos);
        return respVo;
    }

    @Override
    @Transactional
    public void save(SfaVisitGroupReqVo reqVo) {
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis.getUsertype().equals(UserTypeEnum.CUSTOMER_EMPLOYEE.getCode())) {
            userRedis.setPoscode(userRedis.getUsername());
            userRedis.setPosname(userRedis.getRealname());
        }
        if (StringUtils.isEmpty((String)reqVo.getUserName())) {
            reqVo.setUserName(userRedis.getUsername());
            reqVo.setFullName(userRedis.getRealname());
            reqVo.setOrgCode(userRedis.getOrgcode());
            reqVo.setOrgName(userRedis.getOrgname());
            reqVo.setPosCode(userRedis.getPoscode());
            reqVo.setPosName(userRedis.getPosname());
        }
        this.saveCheck(reqVo);
        SfaVisitGroupEntity entity = (SfaVisitGroupEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitGroupEntity.class));
        String code = CodeUtil.getCodeDefault();
        entity.setGroupCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
        this.saveDate(reqVo, entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (org.springframework.util.StringUtils.isEmpty((Object)menuCodeObj)) {
            throw new BusinessException("\u7f3a\u5931\u83dc\u5355\u7f16\u7801,\u65e0\u6cd5\u8bb0\u5f55\u65e5\u5fd7");
        }
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), entity.getId(), reqVo.getUserName(), (Object)reqVo);
    }

    public void saveCheck(SfaVisitGroupReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getUserName(), (String)"\u8bf7\u9009\u62e9\u4eba\u5458\u59d3\u540d");
        AssertUtils.isNotEmpty((String)reqVo.getFullName(), (String)"\u8bf7\u9009\u62e9\u4eba\u5458\u59d3\u540d");
        AssertUtils.isNotEmpty((String)reqVo.getGroupName(), (String)"\u8bf7\u586b\u5199\u7ebf\u8def\u7ec4\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getOrgCode(), (String)"\u9009\u62e9\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOrgName(), (String)"\u9009\u62e9\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPosCode(), (String)"\u9009\u62e9\u804c\u4f4d\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPosName(), (String)"\u9009\u62e9\u804c\u4f4d\u540d\u79f0\u4e3a\u7a7a");
        SfaVisitGroupEntity visitGroupEntity = (SfaVisitGroupEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitGroupEntity::getUserName, (Object)reqVo.getUserName())).eq(SfaVisitGroupEntity::getGroupName, (Object)reqVo.getGroupName())).one());
        if (visitGroupEntity != null) {
            throw new BusinessException(reqVo.getFullName() + "\u5b58\u5728\u76f8\u540c\u7684\u7ebf\u8def\u7ec4\u540d\u79f0[" + visitGroupEntity.getGroupCode() + "]");
        }
        List sfaVisitclientRelReqVos = reqVo.getSfaVisitclientRelReqVos();
        if (CollectionUtil.listEmpty((List)sfaVisitclientRelReqVos)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f");
        }
        ArrayList customerCodes = Lists.newArrayList();
        ArrayList terminalCodes = Lists.newArrayList();
        for (SfaVisitclientRelReqVo sfaVisitclientRelReqVo : sfaVisitclientRelReqVos) {
            AssertUtils.isNotEmpty((String)sfaVisitclientRelReqVo.getClientType(), (String)"\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)sfaVisitclientRelReqVo.getClientName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)sfaVisitclientRelReqVo.getClientCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
            if (SfaVisitEnum.ClientType.TERMINAL.getVal().equals(sfaVisitclientRelReqVo.getClientType())) {
                terminalCodes.add(sfaVisitclientRelReqVo.getClientCode());
                continue;
            }
            customerCodes.add(sfaVisitclientRelReqVo.getClientCode());
        }
        Map<String, SfaClientData> clientDataMap = SfaClientHelper.loadClientDataMap(customerCodes, terminalCodes);
        sfaVisitclientRelReqVos.stream().forEach(v -> {
            SfaClientData clientData = (SfaClientData)clientDataMap.get(v.getClientType() + v.getClientCode());
            if (null == clientData) {
                throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u5ba2\u6237\u6570\u636e[" + v.getClientCode() + "]");
            }
            v.setClientSubclass(clientData.getClientSubclass());
            v.setClientSubclassName(clientData.getClientSubclassName());
        });
    }

    public void saveDate(SfaVisitGroupReqVo reqVo, SfaVisitGroupEntity entity) {
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaVisitclientRelReqVos())) {
            List sfaVisitclientRelEntities = reqVo.getSfaVisitclientRelReqVos().stream().map(o -> {
                if (!SfaVisitEnum.ClientType.GETMAP.containsKey(o.getClientType())) {
                    throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u5ba2\u6237\u7c7b\u578b[" + o.getClientType() + "]");
                }
                SfaVisitclientRelEntity sfaVisitclientRelEntity = new SfaVisitclientRelEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)sfaVisitclientRelEntity));
                sfaVisitclientRelEntity.setId(null);
                sfaVisitclientRelEntity.setGroupCode(entity.getGroupCode());
                return sfaVisitclientRelEntity;
            }).collect(Collectors.toList());
            this.iSfaVisitclientRelService.saveBatch(sfaVisitclientRelEntities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitGroupReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitGroupEntity entity = (SfaVisitGroupEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u7ebf\u8def\u7ec4\u6570\u636e\u4e0d\u5b58\u5728");
        }
        AssertUtils.isNotEmpty((String)reqVo.getGroupName(), (String)"\u8bf7\u586b\u5199\u7ebf\u8def\u7ec4\u540d\u79f0");
        entity.setGroupName(reqVo.getGroupName());
        SfaVisitGroupRespVo oldVisitGroupVo = this.queryDetailById(reqVo.getId());
        this.updateById((Object)entity);
        if (CollectionUtil.listEmpty((List)reqVo.getSfaVisitclientRelReqVos())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f");
        }
        reqVo.setGroupCode(entity.getGroupCode());
        this.deleteBatchDate(reqVo);
        this.saveDate(reqVo, entity);
        SfaVisitGroupRespVo newVisitGroupVo = this.queryDetailById(reqVo.getId());
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), entity.getId(), entity.getUserName(), (Object)oldVisitGroupVo, (Object)newVisitGroupVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(final List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitGroupReqVo reqVo = new SfaVisitGroupReqVo(){
            {
                this.setIds(ids);
            }
        };
        reqVo.setPageSize(Integer.valueOf(-1));
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        final List idList = list.stream().map(UuidVo::getId).collect(Collectors.toList());
        SfaVisitPlanReqVo sfaVisitPlanReqVo = new SfaVisitPlanReqVo(){
            {
                this.setVisitDate(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
                this.setVisitGroupIdList(idList);
            }
        };
        Integer count = this.sfaVisitPlanMapper.findSfaVisitPlanGroupCount(sfaVisitPlanReqVo);
        if (count > 0) {
            throw new BusinessException("\u5220\u9664\u7ebf\u8def\u7ec4\u5df2\u5b58\u5728\u5468\u671f\u6027\u62dc\u8bbf\u8ba1\u5212");
        }
        this.sfaVisitGroupMapper.deleteProductsByParams(reqVo);
        List groupCodes = list.stream().map(SfaVisitGroupRespVo::getGroupCode).collect(Collectors.toList());
        reqVo.setGroupCodes(groupCodes);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(SfaVisitGroupReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getGroupCode()) && CollectionUtil.listEmpty((List)reqVo.getGroupCodes())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitclientRelReqVo sfaVisitclientRelReqVo = new SfaVisitclientRelReqVo();
        sfaVisitclientRelReqVo.setGroupCode(reqVo.getGroupCode());
        sfaVisitclientRelReqVo.setGroupCodes(reqVo.getGroupCodes());
        this.sfaVisitclientRelMapper.deleteProductsByParams(sfaVisitclientRelReqVo);
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaVisitGroupEntities = this.sfaVisitGroupMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitGroupEntities)) {
            sfaVisitGroupEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitGroupEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaVisitGroupEntities = this.sfaVisitGroupMapper.selectBatchIds(ids);
        final List idList = sfaVisitGroupEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        SfaVisitPlanReqVo sfaVisitPlanReqVo = new SfaVisitPlanReqVo(){
            {
                this.setVisitDate(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
                this.setVisitGroupIdList(idList);
            }
        };
        Integer count = this.sfaVisitPlanMapper.findSfaVisitPlanGroupCount(sfaVisitPlanReqVo);
        if (count > 0) {
            throw new BusinessException("\u7981\u7528\u7ebf\u8def\u7ec4\u5df2\u5b58\u5728\u5468\u671f\u6027\u62dc\u8bbf\u8ba1\u5212");
        }
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitGroupEntities)) {
            sfaVisitGroupEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitGroupEntities);
    }
}

