/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.biz.crm.common.PageResult;
import com.biz.crm.moblie.controller.visit.req.step.OrderStepExecuteData;
import com.biz.crm.moblie.controller.workbench.req.OrderAsDataReq;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderTableRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.visitstep.mapper.SfaVisitStepOrderMapper;
import com.biz.crm.visitstep.repositories.SfaVisitStepOrderEsDataRepositories;
import com.biz.crm.visitstep.req.GetOrderPageReq;
import com.biz.crm.visitstep.req.GetOrderPageTableReq;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class SfaVisitStepOrderServiceEsImpl {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepOrderServiceEsImpl.class);
    @Resource
    private SfaVisitStepOrderEsDataRepositories sfaVisitStepOrderEsDataRepositories;
    @Resource
    private SfaVisitStepOrderMapper sfaVisitStepOrderMapper;

    public PageResult<SfaVisitStepOrderRespVo> getWorkbenchOrderPage(GetOrderPageReq req) {
        if (StringUtils.isBlank((CharSequence)req.getPosCode()) && StringUtils.isBlank((CharSequence)req.getPosName())) {
            req.setPosCode(UserUtils.getUser().getPoscode());
        }
        Page list = this.sfaVisitStepOrderEsDataRepositories.search((SearchQuery)req.buildQuery());
        List resultData = list.stream().map(v -> {
            SfaVisitStepOrderRespVo respVo = (SfaVisitStepOrderRespVo)CrmBeanUtil.copy((Object)v, SfaVisitStepOrderRespVo.class);
            List<OrderAsDataReq.OrderItemAsReqVo> sfaVisitStepOrderItems = v.getSfaVisitStepOrderItems();
            BigDecimal priceTotal = BigDecimal.ZERO;
            BigDecimal quantityTotal = BigDecimal.ZERO;
            if (null != sfaVisitStepOrderItems) {
                for (OrderStepExecuteData.OrderItemReqVo orderItemReqVo : sfaVisitStepOrderItems) {
                    quantityTotal = quantityTotal.add(null == orderItemReqVo.getQuantity() ? BigDecimal.ZERO : orderItemReqVo.getQuantity());
                    priceTotal = priceTotal.add(null == orderItemReqVo.getPrice() ? BigDecimal.ZERO : orderItemReqVo.getPrice());
                }
                OrderStepExecuteData.OrderItemReqVo temp = sfaVisitStepOrderItems.get(0);
                respVo.setProductName(temp.getProductName());
                respVo.setProductCode(temp.getProductCode());
                respVo.setSeriesCode(temp.getSeriesCode());
                respVo.setSeriesName(temp.getSeriesName());
                respVo.setPicUrl(temp.getPicUrl());
            }
            respVo.setTotalPrice(priceTotal);
            respVo.setQuantity(quantityTotal);
            return respVo;
        }).collect(Collectors.toList());
        return PageResult.builder().data(resultData).count(Long.valueOf(list.getTotalElements())).build();
    }

    @EsDataPermission(userName="userName.keyword", position="posCode.keyword", org="orgCode.keyword", customer="clientCode.keyword")
    public PageResult<SfaVisitStepOrderTableRespVo> getOrderTable(GetOrderPageTableReq req) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = PageUtil.buildPage((Integer)req.getPageNum(), (Integer)req.getPageSize());
        SfaVisitStepOrderReqVo reqVo = (SfaVisitStepOrderReqVo)CrmBeanUtil.copy((Object)((Object)req), SfaVisitStepOrderReqVo.class);
        reqVo.setStartOrderTime(req.getStartDate());
        reqVo.setEndOrderTime(req.getEndDate());
        List<SfaVisitStepOrderRespVo> list = this.sfaVisitStepOrderMapper.findOrderReportList((com.baomidou.mybatisplus.extension.plugins.pagination.Page<SfaVisitStepOrderRespVo>)page, reqVo);
        return PageResult.builder().data(CrmBeanUtil.copyList(list, SfaVisitStepOrderTableRespVo.class)).count(Long.valueOf(page.getTotal())).build();
    }
}

