/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksignrule.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.worksignrule.SfaWorkSignRuleVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignExecuteReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignRuleExcuteByIdRqeVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignRuleReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPersonnelRespVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignRuleRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.worksignrule.service.ISfaWorkSignPersonnelService;
import com.biz.crm.worksignrule.service.ISfaWorkSignRuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaworksignrule"})
@Api(tags={"\u540e\u53f0-\u8003\u52e4\u7ba1\u7406-\u8003\u52e4\u89c4\u5219"})
public class SfaWorkSignRuleController {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignRuleController.class);
    @Autowired
    private ISfaWorkSignRuleService sfaWorkSignRuleService;
    @Autowired
    private ISfaWorkSignPersonnelService personnelService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaWorkSignRuleRespVo>> list(@RequestBody SfaWorkSignRuleVo sfaWorkSignRuleVo) {
        PageResult<SfaWorkSignRuleRespVo> result = this.sfaWorkSignRuleService.findList(sfaWorkSignRuleVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<SfaWorkSignRuleRespVo> query(@RequestBody SfaWorkSignRuleExcuteByIdRqeVo idRqeVo) {
        AssertUtils.isNotEmpty((String)idRqeVo.getId(), (String)"\u8bf7\u9009\u62e9\u89c4\u5219");
        SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo = new SfaWorkSignRuleReqVo();
        sfaWorkSignRuleReqVo.setId(idRqeVo.getId());
        SfaWorkSignRuleRespVo respVo = this.sfaWorkSignRuleService.findDetailsById(idRqeVo.getId());
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u5df2\u8bbe\u7f6e\u8003\u52e4\u89c4\u5219\u7684\u7ec4\u7ec7\u5217\u8868")
    @PostMapping(value={"/getAlreadySetOrgList"})
    @CrmLog
    public Result<List<SfaWorkSignPersonnelRespVo>> getAlreadySetOrgList(@RequestBody(required=false) String ruleCode) {
        List<SfaWorkSignPersonnelRespVo> list = this.personnelService.findListJoinRule(null, ruleCode, null, CrmEnableStatusEnum.ENABLE.getCode());
        return Result.ok(list);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo) {
        this.sfaWorkSignRuleService.save(sfaWorkSignRuleReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo) {
        this.sfaWorkSignRuleService.update(sfaWorkSignRuleReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo = new SfaWorkSignRuleReqVo();
        sfaWorkSignRuleReqVo.setIds(ids);
        this.sfaWorkSignRuleService.deleteBatch(sfaWorkSignRuleReqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo = new SfaWorkSignRuleReqVo();
        sfaWorkSignRuleReqVo.setIds(ids);
        this.sfaWorkSignRuleService.enableBatch(sfaWorkSignRuleReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo = new SfaWorkSignRuleReqVo();
        sfaWorkSignRuleReqVo.setIds(ids);
        this.sfaWorkSignRuleService.disableBatch(sfaWorkSignRuleReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u6267\u884c\u8003\u52e4\u89c4\u5219\uff0c\u751f\u6210\u6307\u5b9a\u65e5\u671f\u7684\u8003\u52e4\u6570\u636e")
    @PostMapping(value={"/executeWorkSignRule"})
    @CrmLog
    public Result executeWorkSignRule(@RequestBody SfaWorkSignExecuteReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getExecuteDate())) {
            reqVo.setExecuteDate(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
        }
        this.doExecuteWorkSignRule(reqVo);
        return Result.ok((String)"\u5237\u65b0\u4efb\u52a1\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u6838\u5bf9\u6570\u636e\uff01");
    }

    @Async
    protected void doExecuteWorkSignRule(SfaWorkSignExecuteReqVo reqVo) {
        this.sfaWorkSignRuleService.executeWorkSignRule(reqVo);
    }
}

