/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.visitoffline.stepcomponent.photoutil;

import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineBase;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@ApiModel(value="\u79bb\u7ebf\u6b65\u9aa4\u62dc\u8bbf")
public class SfaVisitStepOffLineUtil
implements SfaVisitStepOffLineBase,
Serializable {
    private static final String SFA_VISIT_STEP_OFF_LINE_PHOTO = "SFA_VISIT_STEP_OFF_LINE_PHOTO";
    private static final String SFA_VISIT_OFF_LINE = "sfa_visit_off_line";
    public static final long REDIS_EXPIRE_TIME = 43200L;
    private List<String> photoKeyData;
    private String stepCode;
    private String visitPlanInfoId;
    private String type;
    private String typeName;
    private String actCode;
    private String sfaVisitOffLineKey;
    private String userName;
    private String posCode;

    public SfaVisitStepOffLineUtil(String stepCode, String visitPlanInfoId) {
        this.stepCode = stepCode;
        this.visitPlanInfoId = visitPlanInfoId;
    }

    public SfaVisitStepOffLineUtil(String offLinePhotoKey) {
        String[] keys = offLinePhotoKey.split(":");
        List<String> keyList = Arrays.asList(keys);
        this.photoKeyData = keyList;
        this.visitPlanInfoId = keyList.get(1);
        this.stepCode = keyList.get(2);
        this.type = keyList.get(3);
        this.typeName = keyList.get(4);
        if (keyList.size() >= 6) {
            this.actCode = keyList.get(5);
        }
    }

    public SfaVisitStepOffLineUtil() {
        UserRedis userRedis = UserUtils.getUser();
        this.userName = userRedis.getUsername();
        this.posCode = userRedis.getPoscode();
    }

    public String getPhotoOffLineKey(String type, String typeName) {
        StringJoiner visitStepPhotoKey = new StringJoiner(":");
        visitStepPhotoKey.add(SFA_VISIT_STEP_OFF_LINE_PHOTO).add(this.visitPlanInfoId).add(this.stepCode).add(type).add(typeName);
        return visitStepPhotoKey.toString();
    }

    public String getPhotoOffLineKey(String type, String typeName, String actCode) {
        StringJoiner visitStepPhotoKey = new StringJoiner(":");
        visitStepPhotoKey.add(SFA_VISIT_STEP_OFF_LINE_PHOTO).add(this.visitPlanInfoId).add(this.stepCode).add(type).add(typeName).add(actCode);
        return visitStepPhotoKey.toString();
    }

    public String getRedisHashKey(String visitType2) {
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        StringJoiner redisHashKey = new StringJoiner(":");
        this.sfaVisitOffLineKey = redisHashKey.add(SFA_VISIT_OFF_LINE).add(visitType2).add(this.userName).add(this.posCode).add(now).toString();
        return this.sfaVisitOffLineKey;
    }

    public Map<String, SfaVisitPlanInfoEntity> buildOffLineMap(String clientCode, String visitType2, SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity) {
        String key = this.getFiled(clientCode, visitType2);
        HashMap<String, SfaVisitPlanInfoEntity> map = new HashMap<String, SfaVisitPlanInfoEntity>();
        map.put(key, sfaVisitPlanInfoEntity);
        return map;
    }

    public String getFiled(String clientCode, String visitType2) {
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        StringJoiner key = new StringJoiner(":");
        key.add(SFA_VISIT_OFF_LINE).add(visitType2).add(this.userName).add(this.posCode).add(now).add(clientCode);
        return key.toString();
    }

    @Override
    public List<String> getPhotoKeyData() {
        return this.photoKeyData;
    }

    @Override
    public String getStepCode() {
        return this.stepCode;
    }

    @Override
    public String getVisitPlanInfoId() {
        return this.visitPlanInfoId;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getActCode() {
        return this.actCode;
    }

    @Override
    public void setStepCode(String stepCode) {
        this.stepCode = stepCode;
    }

    @Override
    public void setVisitPlanInfoId(String visitPlanInfoId) {
        this.visitPlanInfoId = visitPlanInfoId;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public void setActCode(String actCode) {
        this.actCode = actCode;
    }

    @Override
    public void setPhotoKeyData(List<String> photoKeyData) {
        this.photoKeyData = photoKeyData;
    }
}

