/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpmact.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActTableReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActTableRespVo;
import com.biz.crm.tpmact.service.ISfaTpmActDetailExecuteService;
import com.biz.crm.tpmact.service.ISfaTpmActService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaTpmActController"})
@Api(tags={"tpm\u6d3b\u52a8"})
public class SfaTpmActController {
    private static final Logger log = LoggerFactory.getLogger(SfaTpmActController.class);
    @Autowired
    private ISfaTpmActService sfaTpmActService;
    @Autowired
    private ISfaTpmActDetailExecuteService sfaTpmActDetailExecuteService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<SfaTpmActRespVo>> list(@RequestBody SfaTpmActReqVo sfaTpmActReqVo) {
        PageResult<SfaTpmActRespVo> result = this.sfaTpmActService.findList(sfaTpmActReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<SfaTpmActRespVo> query(@RequestBody SfaTpmActReqVo sfaTpmActReqVo) {
        SfaTpmActRespVo respVo = this.sfaTpmActService.query(sfaTpmActReqVo);
        return Result.ok((Object)respVo);
    }

    @PostMapping(value={"saveTpmAct"})
    @CrmLog
    @ApiOperation(value="\u4fdd\u5b58tpm\u6d3b\u52a8")
    public Result saveTpmAct(@RequestParam String id) {
        this.sfaTpmActService.saveTpmAct(id);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="tpm\u6d3b\u52a8-\u6267\u884c\u6570\u636e\u660e\u7ec6\u62a5\u8868")
    @PostMapping(value={"findTpmActExecuteDataTable"})
    public Result<PageResult<SfaTpmActTableRespVo>> findTpmActExecuteDataTable(@RequestBody SfaTpmActTableReqVo reqVo) {
        return Result.ok(this.sfaTpmActService.findTpmActExecuteDataTable(reqVo));
    }

    @CrmLog
    @ApiOperation(value="tpm\u6d3b\u52a8-\u6267\u884c\u6570\u636e\u660e\u7ec6\u62a5\u8868\u8be6\u60c5")
    @GetMapping(value={"loadTpmActCollectDetailTableById"})
    public Result<SfaTpmActTableRespVo> loadTpmActCollectDetailTableById(@RequestParam String id) {
        return Result.ok((Object)this.sfaTpmActService.loadTpmActCollectDetailTableById(id));
    }

    @GetMapping(value={"resolvingHistoryData"})
    @ApiOperation(value="\u89e3\u6790\u5386\u53f2\u7684\u6d3b\u52a8\u6570\u636e")
    public Result resolvingHistoryData() {
        this.sfaTpmActDetailExecuteService.resolvingHistoryData();
        return Result.ok();
    }
}

