/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstepbase;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.asexecution.model.SfaAsTreatyEntity;
import com.biz.crm.asexecution.service.ISfaAsTreatyService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepListener;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.nebular.activiti.vo.AttachmentVo;
import com.biz.crm.nebular.sfa.SfaTpmActDisplayVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.DisplayTreatyVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.tpmact.mapper.SfaTpmActDetailMapper;
import com.biz.crm.tpmact.model.SfaTpmActBaseEntity;
import com.biz.crm.tpmact.model.SfaTpmActDetailEntity;
import com.biz.crm.tpmact.service.ISfaTpmActDetailService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEntity;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"visitBaseComponentExpandImpl"})
public class VisitBaseComponent {
    @Resource
    private RedisService redisService;
    @Resource
    protected ISfaVisitStepFromService sfaVisitStepFromService;
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Resource
    private ISfaTpmActDetailService sfaTpmActDetailService;
    @Resource
    private ISfaVisitStepOrderService sfaVisitStepOrderService;
    @Resource
    private ISfaAsTreatyService sfaAsTreatyService;
    @Resource
    private SfaTpmActDetailMapper sfaTpmActDetailMapper;

    public SfaVisitPlanInfoEntity loadAndCheckSfaVisitPlanInfoEntity(String redisHashKey, String visitBigType) {
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)this.redisService.hmget(SfaVisitPlanInfoEntity.getInstance().redisHashCurrent(nowDate, visitBigType).toString(), (Object)redisHashKey);
        if (null == sfaVisitPlanInfoEntity) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u62dc\u8bbf\u8ba1\u5212\uff0c\u6216\u8be5\u8ba1\u5212\u4e0d\u5728\u4eca\u65e5\u8ba1\u5212\u5185\uff01");
        }
        UserRedis userRedis = UserUtils.getUser();
        if (!StringUtils.equals((CharSequence)sfaVisitPlanInfoEntity.getVisitPosCode(), (CharSequence)userRedis.getPoscode())) {
            throw new BusinessException("\u4f60\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\u6216\u5207\u6362\u804c\u4f4d\u518d\u5c1d\u8bd5\uff01");
        }
        return sfaVisitPlanInfoEntity;
    }

    public SfaVisitStepFromRespVo getFormData(String formId, String stepCode) {
        SfaVisitStepFromRespVo fromRespVo = this.sfaVisitStepFromService.queryById(formId);
        if (null == fromRespVo) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8868\u5355[" + formId + "]\u914d\u7f6e\u6570\u636e");
        }
        if (!stepCode.equals(fromRespVo.getStepCode())) {
            throw new BusinessException("\u8868\u5355ID\u4f20\u8f93\u9519\u8bef,\u8be5\u6b65\u9aa4\u5c5e\u4e8eTPM");
        }
        return fromRespVo;
    }

    public void updateStepStatus(String redisHashKey, String stepCode, String visitBigType) {
        this.sfaVisitPlanInfoService.updateStepStatus(redisHashKey, stepCode, visitBigType);
    }

    public void checkTpmActTreatyAmount(String actDetailCode, BigDecimal totalPrice) {
        SfaTpmActDetailRespVo respVo = this.sfaTpmActDetailMapper.findActDetailByActDetailCode(actDetailCode);
        if (respVo.getIsControlActFee().equals(YesNoEnum.yesNoEnum.Y.getValue())) {
            SfaTpmActDetailEntity actDetailEntity;
            BigDecimal surplusAmount;
            List treatyEntityList = ((LambdaQueryChainWrapper)this.sfaAsTreatyService.lambdaQuery().eq(SfaAsTreatyEntity::getActivityCode, (Object)actDetailCode)).list();
            BigDecimal usedAmount = BigDecimal.ZERO;
            if (CollectionUtil.listNotEmptyNotSizeZero((List)treatyEntityList)) {
                usedAmount = treatyEntityList.stream().map(SfaAsTreatyEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (totalPrice.compareTo(surplusAmount = (actDetailEntity = (SfaTpmActDetailEntity)((Object)((LambdaQueryChainWrapper)this.sfaTpmActDetailService.lambdaQuery().eq(SfaTpmActDetailEntity::getActDetailCode, (Object)actDetailCode)).select(new SFunction[]{SfaTpmActDetailEntity::getActDetailCode, SfaTpmActDetailEntity::getApplyAmount}).one())).getApplyAmount().subtract(usedAmount)) == 1) {
                throw new BusinessException("\u5f53\u524d\u7ec8\u7aef\u6d3b\u52a8\u91d1\u989d\u8d85\u989d,\u5269\u4f59\u53ef\u7528\u7ec8\u7aef\u6d3b\u52a8\u91d1\u989d:" + surplusAmount);
            }
        }
    }

    public void checkTpmActDistributionOrderAmount(String actDetailCode, BigDecimal totalPrice, String terminalCode) {
        SfaTpmActDisplayVo displayVo = this.getTpmActTreatyRedis(actDetailCode, terminalCode);
        if (displayVo.getIsControlActFee().equals(YesNoEnum.yesNoEnum.Y.getValue()) && totalPrice.compareTo(displayVo.getSurplusAmount()) == 1) {
            throw new BusinessException("\u5f53\u524d\u7ec8\u7aef\u6d3b\u52a8\u91d1\u989d\u8d85\u989d,\u5269\u4f59\u53ef\u7528\u7ec8\u7aef\u6d3b\u52a8\u91d1\u989d:" + displayVo.getSurplusAmount());
        }
    }

    public SfaTpmActDisplayVo getTpmActTreatyRedis(String actDetailCode, String terminalCode) {
        SfaTpmActDisplayVo displayVo = (SfaTpmActDisplayVo)this.redisService.hmget(SfaTpmActDisplayVo.buildRedisHashKey((String)actDetailCode, (String)terminalCode), (Object)(actDetailCode + ":" + terminalCode));
        if (null == displayVo) {
            displayVo = this.buildSfaTpmActDisplayVo(actDetailCode, terminalCode);
            this.redisService.hmset(SfaTpmActDisplayVo.buildRedisHashKey((String)actDetailCode, (String)terminalCode), displayVo.buildRedisMap(actDetailCode, terminalCode), SfaTpmActDisplayVo.REDIS_EXPIRE_TIME.longValue());
        }
        return displayVo;
    }

    public void saveOrderSetTpmActAmount(String actDetailCode, String terminalCode) {
        SfaTpmActDisplayVo displayVo = this.buildSfaTpmActDisplayVo(actDetailCode, terminalCode);
        this.redisService.hmset(SfaTpmActDisplayVo.buildRedisHashKey((String)actDetailCode, (String)terminalCode), displayVo.buildRedisMap(actDetailCode, terminalCode), SfaTpmActDisplayVo.REDIS_EXPIRE_TIME.longValue());
    }

    protected SfaTpmActDisplayVo buildSfaTpmActDisplayVo(String actDetailCode, String terminalCode) {
        SfaTpmActDisplayVo displayVo = new SfaTpmActDisplayVo();
        SfaTpmActDetailRespVo respVo = this.sfaTpmActDetailMapper.findActDetailByActDetailCode(actDetailCode);
        if (respVo.getIsControlActFee().equals(YesNoEnum.yesNoEnum.Y.getValue())) {
            BigDecimal totalPrice = BigDecimal.ZERO;
            BigDecimal surplusAmount = BigDecimal.ZERO;
            if (YesNoEnum.yesNoEnum.Y.getValue().equals(respVo.getIsSignDisplayAgreement())) {
                SfaAsTreatyEntity treatyEntity = (SfaAsTreatyEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaAsTreatyService.lambdaQuery().eq(SfaAsTreatyEntity::getTerminalCode, (Object)terminalCode)).eq(SfaAsTreatyEntity::getActivityCode, (Object)actDetailCode)).one();
                if (null == treatyEntity) {
                    throw new BusinessException("\u8be5\u7ec8\u7aef\u672a\u8fdb\u884c\u534f\u8bae\u7b7e\u7f72,\u4e0d\u53ef\u8fdb\u884c\u8ba2\u5355\u91c7\u96c6/\u6d3b\u52a8\u6570\u636e\u91c7\u96c6");
                }
                BigDecimal orderPrice = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitStepOrderService.lambdaQuery().eq(SfaVisitStepOrderEntity::getActDetailCode, (Object)actDetailCode)).eq(SfaTpmActBaseEntity::getClientCode, (Object)terminalCode)).select(new SFunction[]{SfaVisitStepOrderEntity::getTotalPrice}).list().stream().map(SfaVisitStepOrderEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                totalPrice = treatyEntity.getTotalPrice();
                surplusAmount = totalPrice.subtract(orderPrice);
            } else {
                SfaTpmActDetailEntity actDetailEntity = (SfaTpmActDetailEntity)((Object)((LambdaQueryChainWrapper)this.sfaTpmActDetailService.lambdaQuery().eq(SfaTpmActDetailEntity::getActDetailCode, (Object)actDetailCode)).select(new SFunction[]{SfaTpmActDetailEntity::getActDetailCode, SfaTpmActDetailEntity::getApplyAmount}).one());
                totalPrice = actDetailEntity.getApplyAmount();
                BigDecimal orderPrice = ((LambdaQueryChainWrapper)this.sfaVisitStepOrderService.lambdaQuery().eq(SfaVisitStepOrderEntity::getActDetailCode, (Object)actDetailCode)).select(new SFunction[]{SfaVisitStepOrderEntity::getTotalPrice}).list().stream().map(SfaVisitStepOrderEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                surplusAmount = totalPrice.subtract(orderPrice);
            }
            displayVo.setTotalPrice(totalPrice);
            displayVo.setSurplusAmount(surplusAmount);
        }
        displayVo.setIsControlActFee(respVo.getIsControlActFee());
        displayVo.setIsSignDisplayAgreement(respVo.getIsSignDisplayAgreement());
        return displayVo;
    }

    public void tpmDoListener(SfaTpmActBaseEntity committedData) {
        if (null == committedData) {
            return;
        }
        SfaClientData clientData = SfaClientHelper.loadClientDataNotRequired(committedData.getClientType(), committedData.getClientCode());
        if (null != clientData) {
            committedData.setClientSubclass(clientData.getClientSubclass());
            committedData.setClientSubclassName(clientData.getClientSubclassName());
        }
        String stepCode = SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_TPM.getVal();
        committedData.setStepCode(stepCode);
        ArrayList committedDataList = Lists.newArrayList((Object[])new VisitStepListener.VisitStepListenerCommittedData[]{committedData});
        List<AbstractVisitStepListener> listeners = AbstractVisitStepListener.getListeners(stepCode);
        for (AbstractVisitStepListener listener : listeners) {
            if (null == listener) continue;
            VisitStepListener.VisitStepListenerCommittedEvent committedEvent = new VisitStepListener.VisitStepListenerCommittedEvent();
            committedEvent.setEntities(committedDataList);
            listener.committed(committedEvent);
        }
    }

    public void textCheck(DisplayTreatyVo vo) {
        AssertUtils.isNotEmpty((String)vo.getStorePhone(), (String)"\u5e97\u4e3b\u624b\u673a\u53f7\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getVerificationCode(), (String)"\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
    }

    public void checkActTpmCollectPicList(List<SfaTpmActCollectVo.CollectForm> collectFormList) {
        collectFormList.forEach(pic -> this.checkPics(pic.getAttachmentList(), 2, 5, pic.getExampleName()));
    }

    private void checkPics(List<AttachmentVo> sfaVisitPics, int min, int max, String bizTag) {
        int n = min = min < 0 ? 0 : min;
        if (max < min) {
            max = min;
        }
        String string = bizTag = null == bizTag ? "" : bizTag;
        if (null == sfaVisitPics) {
            sfaVisitPics = Lists.newArrayList();
        }
        if (sfaVisitPics.size() < min) {
            throw new BusinessException(bizTag + "\u56fe\u7247\u6570\u91cf\u4e0d\u80fd\u5c11\u4e8e[" + min + "]\u5f20");
        }
        if (sfaVisitPics.size() > max) {
            throw new BusinessException(bizTag + "\u56fe\u7247\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7[" + max + "]\u5f20");
        }
        for (AttachmentVo sfaVisitPictureReqVo : sfaVisitPics) {
            if (StringUtils.isBlank((CharSequence)sfaVisitPictureReqVo.getUrlPathPrefix())) {
                throw new BusinessException(bizTag + "\u7167\u7247\u57df\u540d\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((CharSequence)sfaVisitPictureReqVo.getUrlPathPrefix())) continue;
            throw new BusinessException(bizTag + "\u7167\u7247\u76f8\u5bf9\u8def\u5f84\u4e3a\u7a7a");
        }
    }
}

