/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.freesignconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.freesignconfig.mapper.SfaFreesignConfigMapper;
import com.biz.crm.freesignconfig.mapper.SfaFreesignPersonnelMapper;
import com.biz.crm.freesignconfig.mapper.SfaFreesignSignMapper;
import com.biz.crm.freesignconfig.mapper.SfaFreesignSignTypeMapper;
import com.biz.crm.freesignconfig.model.SfaFreesignConfigEntity;
import com.biz.crm.freesignconfig.model.SfaFreesignPersonnelEntity;
import com.biz.crm.freesignconfig.model.SfaFreesignSignEntity;
import com.biz.crm.freesignconfig.model.SfaFreesignSignTypeEntity;
import com.biz.crm.freesignconfig.service.ISfaFreesignConfigService;
import com.biz.crm.freesignconfig.service.ISfaFreesignPersonnelService;
import com.biz.crm.freesignconfig.service.ISfaFreesignSignService;
import com.biz.crm.freesignconfig.service.ISfaFreesignSignTypeService;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignConfigReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignPersonnelReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignSignReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignSignTypeReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignConfigRespVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignPersonnelRespVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignSignRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaFreesignConfigServiceExpandImpl"})
public class SfaFreesignConfigServiceImpl
extends ServiceImpl<SfaFreesignConfigMapper, SfaFreesignConfigEntity>
implements ISfaFreesignConfigService {
    private static final Logger log = LoggerFactory.getLogger(SfaFreesignConfigServiceImpl.class);
    @Resource
    private SfaFreesignConfigMapper sfaFreesignConfigMapper;
    @Resource
    private SfaFreesignPersonnelMapper personnelMapper;
    @Resource
    private SfaFreesignSignTypeMapper freesignSignTypeMapper;
    @Resource
    private SfaFreesignSignMapper sfaFreesignSignMapper;
    @Autowired
    private ISfaFreesignPersonnelService iSfaFreesignPersonnelService;
    @Autowired
    private ISfaFreesignSignTypeService iSfaFreesignSignTypeServics;
    @Autowired
    private ISfaFreesignSignService iSfaFreesignSignService;

    @Override
    @CrmLog
    public PageResult<SfaFreesignConfigRespVo> findList(SfaFreesignConfigReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaFreesignConfigRespVo> list = this.sfaFreesignConfigMapper.findList((Page<SfaFreesignConfigRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public SfaFreesignConfigRespVo query(SfaFreesignConfigReqVo reqVo) {
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new SfaFreesignConfigRespVo();
        }
        SfaFreesignConfigRespVo sfaFreesignConfigRespVo = (SfaFreesignConfigRespVo)list.get(0);
        SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo = new SfaFreesignPersonnelReqVo();
        sfaFreesignPersonnelReqVo.setFreesignCode(sfaFreesignConfigRespVo.getFreesignCode());
        sfaFreesignPersonnelReqVo.setPageSize(Integer.valueOf(-1));
        List sfaWorkSignPersonnelRespVos = this.iSfaFreesignPersonnelService.findList(sfaFreesignPersonnelReqVo).getData();
        if (CollectionUtil.listEmpty((List)sfaWorkSignPersonnelRespVos)) {
            ArrayList<SfaFreesignPersonnelRespVo> personnelRespContainVos = new ArrayList<SfaFreesignPersonnelRespVo>();
            ArrayList<SfaFreesignPersonnelRespVo> personnelRespNonInclusionVos = new ArrayList<SfaFreesignPersonnelRespVo>();
            for (SfaFreesignPersonnelRespVo personnelRespVo : sfaWorkSignPersonnelRespVos) {
                if ("1".equals(personnelRespVo.getRangeType())) {
                    personnelRespContainVos.add(personnelRespVo);
                    continue;
                }
                personnelRespNonInclusionVos.add(personnelRespVo);
            }
            sfaFreesignConfigRespVo.setPersonnelRespContainVos(personnelRespContainVos);
            sfaFreesignConfigRespVo.setPersonnelRespNonInclusionVos(personnelRespNonInclusionVos);
        }
        return sfaFreesignConfigRespVo;
    }

    public void saveCheck(SfaFreesignConfigReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getFreesignName(), (String)"\u8bf7\u8f93\u5165\u7b7e\u5230\u7ec4\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getSignTypeCode(), (String)"\u8bf7\u9009\u62e9\u6253\u5361\u7c7b\u578b");
        AssertUtils.isNotEmpty((String)reqVo.getSignTypeName(), (String)"\u8bf7\u9009\u62e9\u6253\u5361\u7c7b\u578b");
        SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo = new SfaFreesignSignTypeReqVo();
        sfaFreesignSignTypeReqVo.setSignTypeCode(reqVo.getSignTypeCode());
        List freesignSignTypeRespVoList = this.iSfaFreesignSignTypeServics.findList(sfaFreesignSignTypeReqVo).getData();
        if (CollectionUtil.listEmpty((List)freesignSignTypeRespVoList)) {
            throw new BusinessException("\u9009\u62e9\u6253\u5361\u7c7b\u578b\u6709\u8bef,\u7cfb\u7edf\u4e0d\u5b58\u5728\u8be5\u3010" + reqVo.getSignTypeName() + "\u3011\u6253\u5361\u7c7b\u578b");
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getPersonnelReqContainVos())) {
            for (SfaFreesignPersonnelReqVo personnelReqContainVo : reqVo.getPersonnelReqContainVos()) {
                personnelReqContainVo.setRangeType("1");
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getPersonnelReqNonInclusionVos())) {
            for (SfaFreesignPersonnelReqVo personnelReqNonInclusionVo : reqVo.getPersonnelReqNonInclusionVos()) {
                personnelReqNonInclusionVo.setRangeType("1");
            }
        }
        this.checkDataExist(reqVo);
    }

    public void checkDataExist(SfaFreesignConfigReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaFreesignConfigEntity::getFreesignName, (Object)reqVo.getFreesignName());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        SfaFreesignConfigEntity entity = (SfaFreesignConfigEntity)((Object)this.sfaFreesignConfigMapper.selectOne((Wrapper)wrapper));
        AssertUtils.isNotNull((Object)((Object)entity), (String)"\u7b7e\u5230\u7ec4\u6570\u636e\u540d\u79f0\u91cd\u590d,\u8bf7\u68c0\u67e5");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(SfaFreesignConfigReqVo reqVo) {
        this.saveCheck(reqVo);
        SfaFreesignConfigEntity entity = (SfaFreesignConfigEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaFreesignConfigEntity.class));
        String code = CodeUtil.createCode();
        entity.setFreesignCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)entity);
        this.saveData(reqVo, entity);
    }

    public void saveData(SfaFreesignConfigReqVo reqVo, SfaFreesignConfigEntity entity) {
        List<String> signTypeCodeList;
        LambdaQueryWrapper wrapper;
        List freesignSignTypeList;
        String[] signTypeCodes = reqVo.getSignTypeCode().split(",");
        if (signTypeCodes.length > 0 && CollectionUtil.listNotEmptyNotSizeZero((List)(freesignSignTypeList = this.freesignSignTypeMapper.selectList((Wrapper)(wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SfaFreesignSignTypeEntity::getSignTypeCode, signTypeCodeList = Arrays.asList(signTypeCodes))))))) {
            List freesignSignList = freesignSignTypeList.stream().map(o -> {
                SfaFreesignSignEntity freesignSign = new SfaFreesignSignEntity();
                freesignSign.setFreesignCode(entity.getFreesignCode());
                freesignSign.setSignTypeId(o.getId());
                freesignSign.setSignTypeCode(o.getSignTypeCode());
                freesignSign.setSignTypeName(o.getSignTypeName());
                return freesignSign;
            }).collect(Collectors.toList());
            this.iSfaFreesignSignService.saveBatch(freesignSignList);
        }
        ArrayList personnelEntityList = new ArrayList();
        if (CollectionUtil.listEmpty((List)reqVo.getPersonnelReqContainVos())) {
            List personnelContainList = reqVo.getPersonnelReqContainVos().stream().map(o -> {
                SfaFreesignPersonnelEntity personnelEntity = new SfaFreesignPersonnelEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)personnelEntity));
                personnelEntity.setFreesignCode(entity.getFreesignCode());
                personnelEntity.setRangeType("1");
                return personnelEntity;
            }).collect(Collectors.toList());
            personnelEntityList.addAll(personnelContainList);
        }
        if (CollectionUtil.listEmpty((List)reqVo.getPersonnelReqNonInclusionVos())) {
            List personnelNonInclusionList = reqVo.getPersonnelReqNonInclusionVos().stream().map(o -> {
                SfaFreesignPersonnelEntity personnelEntity = new SfaFreesignPersonnelEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)personnelEntity));
                personnelEntity.setFreesignCode(entity.getFreesignCode());
                personnelEntity.setRangeType("2");
                return personnelEntity;
            }).collect(Collectors.toList());
            personnelEntityList.addAll(personnelNonInclusionList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(personnelEntityList)) {
            this.iSfaFreesignPersonnelService.saveBatch(personnelEntityList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaFreesignConfigReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaFreesignConfigEntity entity = (SfaFreesignConfigEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u8003\u52e4\u89c4\u5219\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.saveCheck(reqVo);
        this.updateById((Object)entity);
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo, entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(SfaFreesignConfigReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u8003\u52e4\u89c4\u5219\u6570\u636e\u4e0d\u5b58\u5728");
        }
        reqVo.setPageSize(Integer.valueOf(-1));
        this.sfaFreesignConfigMapper.deleteProductsByParams(reqVo);
        List codes = list.stream().map(SfaFreesignConfigRespVo::getFreesignCode).collect(Collectors.toList());
        reqVo.setFreesignCodes(codes);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(SfaFreesignConfigReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getFreesignCode()) && CollectionUtil.listEmpty((List)reqVo.getFreesignCodes())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaFreesignSignReqVo sfaFreesignSignReqVo = new SfaFreesignSignReqVo();
        sfaFreesignSignReqVo.setFreesignCode(reqVo.getFreesignCode());
        sfaFreesignSignReqVo.setFreesignCodes(reqVo.getFreesignCodes());
        this.sfaFreesignSignMapper.deleteProductsByParams(sfaFreesignSignReqVo);
        SfaFreesignPersonnelReqVo signPersonnelReqVo = new SfaFreesignPersonnelReqVo();
        signPersonnelReqVo.setFreesignCode(reqVo.getFreesignCode());
        signPersonnelReqVo.setFreesignCodes(reqVo.getFreesignCodes());
        this.personnelMapper.deleteProductsByParams(signPersonnelReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(SfaFreesignConfigReqVo reqVo) {
        List sfaFreesignConfigEntities;
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaFreesignConfigEntities = this.sfaFreesignConfigMapper.selectBatchIds(reqVo.getIds())))) {
            sfaFreesignConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaFreesignConfigEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(SfaFreesignConfigReqVo reqVo) {
        List sfaFreesignConfigEntities;
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaFreesignConfigEntities = this.sfaFreesignConfigMapper.selectBatchIds(reqVo.getIds())))) {
            sfaFreesignConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaFreesignConfigEntities);
    }

    @Override
    @CrmLog
    public Result<SfaFreesignConfigRespVo> findFreesignConfigList() {
        Result result = new Result();
        UserRedis userRedis = UserUtils.getUser();
        if (null == userRedis || StringUtil.isEmpty((String)userRedis.getUsername())) {
            result.error401("\u8bf7\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        ArrayList<SfaFreesignConfigRespVo> sfaFreesignConfigRespVos = new ArrayList<SfaFreesignConfigRespVo>();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode());
        wrapper.orderByDesc(SfaFreesignConfigEntity::getFreesignCode);
        List freesignConfigList = this.sfaFreesignConfigMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)freesignConfigList)) {
            for (SfaFreesignConfigEntity sfaFreesignConfig : freesignConfigList) {
                SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo = new SfaFreesignPersonnelReqVo();
                sfaFreesignPersonnelReqVo.setFreesignCode(sfaFreesignConfig.getFreesignCode());
                sfaFreesignPersonnelReqVo.setPageSize(Integer.valueOf(-1));
                List list = this.iSfaFreesignPersonnelService.findList(sfaFreesignPersonnelReqVo).getData();
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(sfaFreesignConfigRespVos)) {
            this.initSfaFreesignConfigVo(sfaFreesignConfigRespVos);
        }
        Result.ok(sfaFreesignConfigRespVos);
        return result;
    }

    private void initSfaFreesignConfigVo(List<SfaFreesignConfigRespVo> list) {
        List freesignSignRespVoList;
        ArrayList<String> freesignCodes = new ArrayList<String>();
        for (SfaFreesignConfigRespVo freesignConfigRespVo : list) {
            freesignCodes.add(freesignConfigRespVo.getFreesignCode());
        }
        SfaFreesignSignReqVo reqVo = new SfaFreesignSignReqVo();
        reqVo.setFreesignCodes(freesignCodes);
        reqVo.setPageSize(Integer.valueOf(-1));
        List sfaFreesignSignRespVos = this.iSfaFreesignSignService.findList(reqVo).getData();
        HashMap map = new HashMap();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaFreesignSignRespVos)) {
            for (SfaFreesignSignRespVo freesignSignRespVo : sfaFreesignSignRespVos) {
                freesignSignRespVoList = new ArrayList();
                if (map.containsKey(freesignSignRespVo.getFreesignCode())) {
                    freesignSignRespVoList = (List)map.get(freesignSignRespVo.getFreesignCode());
                }
                map.remove(freesignSignRespVo.getFreesignCode());
                map.put(freesignSignRespVo.getFreesignCode(), freesignSignRespVoList);
            }
        }
        if (map.size() > 0) {
            for (SfaFreesignConfigRespVo freesignConfigRespVo : list) {
                if (!map.containsKey(freesignConfigRespVo.getFreesignCode())) continue;
                freesignSignRespVoList = (List)map.get(freesignConfigRespVo.getFreesignCode());
                freesignConfigRespVo.setSfaFreesignSignRespVos(freesignSignRespVoList);
            }
        }
    }
}

