/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.stepformcomponent;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoStepFormRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoRedisDataRepositories;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoExecuteService;
import com.biz.crm.visitinfo.stepformcomponent.VisitPlanInfoStepFormValidator;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"SfaVisitPlanInfoStepFormComponentExpandImpl"})
public class SfaVisitPlanInfoStepFormComponent {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitPlanInfoStepFormComponent.class);
    private static final Integer CORE_POOL_SIZE = 30;
    private static final Integer MAXIMUM_POOL_SIZE = 50;
    private static final Integer KEEP_ALIVE_TIME = 50;
    private static final Integer SIZE = 2000;
    private static final LinkedBlockingQueue<Runnable> QUEUE = new LinkedBlockingQueue(SIZE);
    private ThreadPoolExecutor THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, KEEP_ALIVE_TIME.intValue(), TimeUnit.SECONDS, QUEUE);
    @Resource
    private SfaVisitPlanInfoRedisDataRepositories sfaVisitPlanInfoRedisDataRepositories;
    @Resource
    private ISfaVisitPlanInfoExecuteService sfaVisitPlanInfoExecuteService;

    public void resolvingStepForm(List<SfaVisitPlanInfoStepFormRespVo> list) {
        this.THREAD_POOL_EXECUTOR.execute(() -> list.forEach(l -> {
            List stepSuccessStatus = l.getStepSuccessStatusList();
            stepSuccessStatus.forEach(step -> {
                VisitPlanInfoStepFormValidator validator = new VisitPlanInfoStepFormValidator((String)step);
                validator.resolvingVisitPlanInfoStepForm((SfaVisitPlanInfoStepFormRespVo)l);
            });
        }));
    }

    public List<SfaVisitPlanInfoStepFormRespVo> getVisitPlanInfoRedisDataByEs(List<SfaVisitPlanInfoStepFormRespVo> list) {
        List<SfaVisitPlanInfoStepFormRespVo> dataList = list.stream().map(data -> {
            SfaVisitPlanInfoRedisData redisData;
            SfaVisitPlanInfoStepFormRespVo respVo = new SfaVisitPlanInfoStepFormRespVo();
            Optional optional = this.sfaVisitPlanInfoRedisDataRepositories.findById(data.getVisitPlanInfoId());
            if (optional.isPresent() && CollectionUtil.listNotEmptyNotSizeZero((redisData = (SfaVisitPlanInfoRedisData)optional.get()).getStep())) {
                respVo = (SfaVisitPlanInfoStepFormRespVo)CrmBeanUtil.copy((Object)data, SfaVisitPlanInfoStepFormRespVo.class);
                List stepList = redisData.getStep().stream().map(x -> {
                    StringJoiner step = new StringJoiner(":");
                    step.add(x.getStepCode()).add(x.getIsSuccess()).add(x.getStepName()).add(x.getFormId()).add(x.getSort().toString());
                    return step.toString();
                }).collect(Collectors.toList());
                log.warn("\u4ecees\u53d6\u51fa\u7684\u62dc\u8bbf\u6b65\u9aa4\u5217\u8868:{}", (Object)JSONObject.toJSONString(stepList));
                respVo.setStepSuccessStatusList(stepList);
            }
            return respVo;
        }).filter(x -> x != null && CollectionUtil.listNotEmptyNotSizeZero((List)x.getStepSuccessStatusList())).collect(Collectors.toList());
        return dataList;
    }
}

