/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activity.mapper.SfaActivityExecutionMapper;
import com.biz.crm.activity.model.SfaActivityExecutionEntity;
import com.biz.crm.activity.service.ISfaActivityExecutionService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.ActivityDisplayStepExecuteDataResp;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionTypeRespVo;
import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoServiceEsImpl;
import com.biz.crm.visitstep.mapper.SfaVisitStepActivityExecutionMapper;
import com.biz.crm.visitstep.model.SfaVisitStepActivityCostExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityDisplayExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionRedisData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionTypeEntity;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityCostExecutionEsDataRepositories;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityDisplayExecutionEsDataRepositories;
import com.biz.crm.visitstep.req.GetActForWorkbenchReq;
import com.biz.crm.visitstep.req.LoadActivityExecutionListReq;
import com.biz.crm.visitstep.req.LoadVisitActivityListReq;
import com.biz.crm.visitstep.resp.SfaActivityExecutionEntityResp;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionTypeService;
import com.biz.crm.visitstep.service.impl.SfaVisitStepActivityExecutionServiceEsImpl;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"sfaVisitStepActivityExecutionServiceExpandImpl"})
@Transactional
public class SfaVisitStepActivityExecutionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepActivityExecutionMapper, SfaVisitStepActivityExecutionEntity>
implements ISfaVisitStepActivityExecutionService,
VisitDataDurabilityService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepActivityExecutionServiceImpl.class);
    @Resource
    private SfaVisitStepActivityExecutionMapper sfaVisitStepActivityExecutionMapper;
    @Resource
    private ISfaActivityExecutionService sfaActivityExecutionService;
    @Resource
    private ISfaVisitStepActivityExecutionTypeService sfaVisitStepActivityExecutionTypeService;
    @Resource
    private ISfaVisitPictureService sfaVisitPictureService;
    @Resource
    private SfaActivityExecutionMapper sfaActivityExecutionMapper;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private RedisService redisService;
    @Resource
    private SfaVisitStepActivityExecutionServiceEsImpl sfaVisitStepActivityExecutionServiceEsImpl;
    @Resource
    private SfaVisitPlanInfoServiceEsImpl sfaVisitPlanInfoServiceEsImpl;
    @Resource
    private ElasticsearchTemplate elasticsearchTemplate;
    @Resource
    private SfaVisitStepActivityDisplayExecutionEsDataRepositories sfaVisitStepActivityDisplayExecutionEsDataRepositories;
    @Resource
    private SfaVisitStepActivityCostExecutionEsDataRepositories sfaVisitStepActivityCostExecutionEsDataRepositories;
    private static boolean putMappingCost = false;
    private static boolean putMappingDisplay = false;

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void cleanExecutionData(SfaActivityExecutionEntity sfaActivityExecutionEntity) {
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaVisitStepActivityExecutionEntity.class).eq(SfaVisitStepActivityExecutionEntity::getActivityExecutionId, (Object)sfaActivityExecutionEntity.getId())).eq(SfaVisitStepActivityExecutionEntity::getExecuteStatus, (Object)SfaActivityEnum.StepActivityExecuteStatus.WAITING.getVal());
        if (SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(sfaActivityExecutionEntity.getActivityType())) {
            this.sfaVisitStepActivityCostExecutionEsDataRepositories.deleteByActivityExecutionIdAndExecuteStatusAndActivityEndTimeGreaterThanEqual(sfaActivityExecutionEntity.getId(), SfaActivityEnum.StepActivityExecuteStatus.WAITING.getVal(), now);
            this.sfaVisitStepActivityCostExecutionEsDataRepositories.refresh();
            wrapper.ge(SfaVisitStepActivityExecutionEntity::getActivityEndTime, (Object)now);
            this.remove((Wrapper)wrapper);
        } else {
            this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.deleteByActivityExecutionIdAndExecuteStatusAndActivityDate(sfaActivityExecutionEntity.getId(), SfaActivityEnum.StepActivityExecuteStatus.WAITING.getVal(), now);
            this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.refresh();
            wrapper.ge(SfaVisitStepActivityExecutionEntity::getActivityDate, (Object)now);
            this.remove((Wrapper)wrapper);
        }
    }

    @Override
    public PageResult<SfaVisitStepActivityExecutionRespVo> findList(SfaVisitStepActivityExecutionReqVo reqVo) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepActivityExecutionRespVo> list = this.sfaVisitStepActivityExecutionMapper.findList((com.baomidou.mybatisplus.extension.plugins.pagination.Page<SfaVisitStepActivityExecutionRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmDictMethod
    public PageResult<SfaVisitStepActivityExecutionRespVo> findWorkActivityList(SfaVisitStepActivityExecutionReqVo reqVo) {
        String username = UserUtils.getUser().getUsername();
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        reqVo.setUserName(username);
        reqVo.setIsVisit(Integer.valueOf(SfaCommonEnum.whether.NO.getValue()));
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepActivityExecutionRespVo> list = this.sfaVisitStepActivityExecutionMapper.findList((com.baomidou.mybatisplus.extension.plugins.pagination.Page<SfaVisitStepActivityExecutionRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmDictMethod
    public PageResult<SfaActivityExecutionRespVo> findCostActivityExecution(SfaVisitStepActivityExecutionReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u7f51\u70b9\u7c7b\u578b\u4e3a\u7a7a");
        String userName = UserUtils.getUser().getUsername();
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        if (SfaCommonEnum.whether.YES.getValue().equals(reqVo.getDoNot())) {
            List stepActivityExecutionEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepActivityExecutionEntity::getClientCode, (Object)reqVo.getClientCode())).eq(SfaVisitStepActivityExecutionEntity::getUserName, (Object)userName)).eq(SfaVisitStepActivityExecutionEntity::getActivityType, (Object)SfaActivityEnum.activityType.COST_ACTIVITY.getVal())).le(SfaVisitStepActivityExecutionEntity::getActivityStartTime, (Object)now)).ge(SfaVisitStepActivityExecutionEntity::getActivityEndTime, (Object)now)).isNull(SfaVisitStepActivityExecutionEntity::getStepCode)).list();
            List activityExecutionIds = null;
            if (CollectionUtil.listNotEmptyNotSizeZero((List)stepActivityExecutionEntities)) {
                activityExecutionIds = stepActivityExecutionEntities.stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toList());
                reqVo.setIds(activityExecutionIds);
            }
        }
        String channelCode = null;
        String orgCode = null;
        if (SfaVisitEnum.ClientType.DEALER.getVal().equals(reqVo.getClientType())) {
            MdmCustomerMsgRespVo mdmCustomerMsgRespVo = this.getMdmCustomerMsgRespVo(reqVo.getClientCode());
            channelCode = mdmCustomerMsgRespVo.getChannel();
            orgCode = mdmCustomerMsgRespVo.getOrgCode();
        } else {
            MdmTerminalVo mdmTerminalVo = this.getMdmTerminalVo(reqVo.getClientCode());
            channelCode = mdmTerminalVo.getChannel();
            orgCode = mdmTerminalVo.getOrgCode();
        }
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.add(reqVo.getClientCode());
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)channelCode)) {
            codeList.add(channelCode);
        }
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)orgCode)) {
            codeList.add(orgCode);
        }
        reqVo.setCodeList(codeList);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaActivityExecutionRespVo> list = this.sfaActivityExecutionMapper.findCostList((com.baomidou.mybatisplus.extension.plugins.pagination.Page<SfaActivityExecutionRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaActivityExecutionEntityResp> getActForWorkbench(GetActForWorkbenchReq reqVo) {
        if (StringUtils.isBlank((CharSequence)reqVo.getStepCode())) {
            throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        Page<SfaVisitStepActivityExecutionRedisData> redisData = this.doLoadActivityExecutionPageList(reqVo);
        List<SfaActivityExecutionEntityResp> result = this.buildDataList(redisData.getContent());
        if (CollectionUtil.listEmpty(result)) {
            return PageResult.builder().data(result).count(Long.valueOf(redisData.getTotalElements())).build();
        }
        return PageResult.builder().data(result).count(Long.valueOf(result.size())).build();
    }

    protected Page<? extends SfaVisitStepActivityExecutionRedisData> doLoadActivityExecutionPageList(GetActForWorkbenchReq reqVo) {
        LoadActivityExecutionListReq listReq = (LoadActivityExecutionListReq)((Object)CrmBeanUtil.copy((Object)((Object)reqVo), LoadActivityExecutionListReq.class));
        listReq.setPosCode(UserUtils.getUser().getPoscode());
        BoolQueryBuilder baseBuilder = this.buildQueryBuilder(listReq);
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)baseBuilder);
        nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)(reqVo.getPageNum() - 1), (int)reqVo.getPageSize()));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"activityTime").unmappedType("keyword").order(SortOrder.DESC));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        if (SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(listReq.getActivityType())) {
            return this.sfaVisitStepActivityCostExecutionEsDataRepositories.search((SearchQuery)query);
        }
        return this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search((SearchQuery)query);
    }

    @Override
    public List<? extends SfaVisitStepActivityExecutionRedisData> loadVisitActivityList(String visitInfoId, String activityType2) {
        Iterable<SfaVisitStepActivityExecutionRedisData> esData = this.doLoadVisitActivityList(visitInfoId, activityType2);
        return Lists.newArrayList(esData);
    }

    @Override
    public List<SfaActivityExecutionEntityResp> loadVisitActivityList(LoadVisitActivityListReq reqVo) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.checkLoadVisitActivityList(reqVo);
        LoadActivityExecutionListReq listReq = (LoadActivityExecutionListReq)((Object)CrmBeanUtil.copy((Object)((Object)reqVo), LoadActivityExecutionListReq.class));
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getActivityTime())) {
            listReq.setStartActivityTime(reqVo.getActivityTime());
            listReq.setEndActivityTime(reqVo.getActivityTime());
        }
        listReq.setPosCode(sfaVisitPlanInfoEntity.getVisitPosCode());
        listReq.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        String visitStatus2 = sfaVisitPlanInfoEntity.getVisitStatus();
        Boolean executed = SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(sfaVisitPlanInfoEntity.getVisitBigType()) ? Boolean.valueOf(!SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getVal().equals(visitStatus2) && !SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal().equals(visitStatus2)) : Boolean.valueOf(!SfaVisitEnum.visitStatus.V1.getVal().equals(visitStatus2) && !SfaVisitEnum.visitStatus.V2.getVal().equals(visitStatus2));
        listReq.setExecuted(executed);
        Iterable<SfaVisitStepActivityExecutionRedisData> esData = this.doLoadActivityExecutionList(listReq);
        return this.buildDataList(esData);
    }

    protected Iterable<? extends SfaVisitStepActivityExecutionRedisData> doLoadActivityExecutionList(LoadActivityExecutionListReq listReq) {
        BoolQueryBuilder baseBuilder = this.buildQueryBuilder(listReq);
        if (SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(listReq.getActivityType())) {
            return this.sfaVisitStepActivityCostExecutionEsDataRepositories.search((QueryBuilder)baseBuilder);
        }
        return this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search((QueryBuilder)baseBuilder);
    }

    protected Iterable<? extends SfaVisitStepActivityExecutionRedisData> doLoadVisitActivityList(String visitInfoId, String activityType2) {
        BoolQueryBuilder baseBuilder = QueryBuilders.boolQuery();
        baseBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"visitPlanInfoId", (String)visitInfoId));
        if (SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(activityType2)) {
            return this.sfaVisitStepActivityCostExecutionEsDataRepositories.search((QueryBuilder)baseBuilder);
        }
        return this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search((QueryBuilder)baseBuilder);
    }

    protected void checkLoadActivityExecutionList(LoadActivityExecutionListReq listReq) {
        if (StringUtils.isBlank((CharSequence)listReq.getActivityType())) {
            throw new BusinessException("\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)listReq.getClientCode())) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)listReq.getPosCode())) {
            throw new BusinessException("\u804c\u4f4d\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
    }

    protected BoolQueryBuilder buildQueryBuilder(LoadActivityExecutionListReq listReq) {
        this.checkLoadActivityExecutionList(listReq);
        BoolQueryBuilder baseBuilder = QueryBuilders.boolQuery();
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        String dateTimeNow = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        Boolean executed = listReq.getExecuted();
        if (null == executed || !executed.booleanValue()) {
            if (SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(listReq.getActivityType())) {
                builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"activityStartTime").lte((Object)dateTimeNow));
                builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"activityEndTime").gte((Object)dateTimeNow));
            } else {
                builder.must((QueryBuilder)QueryBuilders.termQuery((String)"activityDate", (String)dateTimeNow));
            }
            BoolQueryBuilder executeStatusBuilderBase = QueryBuilders.boolQuery();
            BoolQueryBuilder executeStatusBuilderWaiting = QueryBuilders.boolQuery();
            executeStatusBuilderWaiting.must((QueryBuilder)QueryBuilders.termQuery((String)"executeStatus", (String)SfaActivityEnum.StepActivityExecuteStatus.WAITING.getVal()));
            BoolQueryBuilder executeStatusBuilderExecuting = QueryBuilders.boolQuery();
            executeStatusBuilderExecuting.must((QueryBuilder)QueryBuilders.termQuery((String)"executeStatus", (String)SfaActivityEnum.StepActivityExecuteStatus.EXECUTING.getVal()));
            executeStatusBuilderExecuting.must((QueryBuilder)QueryBuilders.termQuery((String)"posCode.keyword", (String)listReq.getPosCode()));
            executeStatusBuilderBase.should((QueryBuilder)executeStatusBuilderWaiting);
            executeStatusBuilderBase.should((QueryBuilder)executeStatusBuilderExecuting);
            baseBuilder.must((QueryBuilder)executeStatusBuilderBase);
        } else {
            builder.must((QueryBuilder)QueryBuilders.termsQuery((String)"executeStatus", (String[])new String[]{SfaActivityEnum.StepActivityExecuteStatus.COMPLETE.getVal(), SfaActivityEnum.StepActivityExecuteStatus.PAST_DUE.getVal()}));
        }
        if (StringUtils.isNotBlank((CharSequence)listReq.getStartActivityStartTime())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"activityStartTime").from((Object)listReq.getStartActivityStartTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)listReq.getEndActivityStartTime())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"activityStartTime").to((Object)listReq.getEndActivityStartTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)listReq.getStartActivityEndTime())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"activityEndTime").from((Object)listReq.getStartActivityEndTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)listReq.getEndActivityEndTime())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"activityEndTime").to((Object)listReq.getEndActivityEndTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)listReq.getStartActivityTime())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"activityTime").from((Object)listReq.getStartActivityTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)listReq.getEndActivityTime())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"activityTime").to((Object)listReq.getEndActivityTime()));
        }
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)listReq.getVisitPlanInfoId())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"visitPlanInfoId", (String)listReq.getVisitPlanInfoId()));
        }
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"stepCode", (String)listReq.getStepCode()));
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientCode.keyword", (String)listReq.getClientCode()));
        baseBuilder.must((QueryBuilder)builder);
        return baseBuilder;
    }

    protected List<SfaActivityExecutionEntityResp> buildDataList(Iterable<? extends SfaVisitStepActivityExecutionRedisData> esData) {
        ArrayList results = Lists.newArrayList();
        Map dict = DictUtil.getDictValueMapsByCodes((String)SfaActivityEnum.StepActivityExecuteStatus.DICT_CODE);
        esData.forEach(v -> {
            SfaActivityExecutionEntityResp resp = (SfaActivityExecutionEntityResp)((Object)((Object)CrmBeanUtil.copy((Object)v, SfaActivityExecutionEntityResp.class)));
            resp.setExecuteStatusName((String)dict.get(resp.getExecuteStatus()));
            results.add(resp);
        });
        return results;
    }

    private SfaVisitPlanInfoEntity checkLoadVisitActivityList(LoadVisitActivityListReq reqVo) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity;
        if (StringUtils.isBlank((CharSequence)reqVo.getActivityType())) {
            throw new BusinessException("\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getStepCode())) {
            throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getId())) {
            if (StringUtils.isBlank((CharSequence)reqVo.getRedisHashKey())) {
                throw new BusinessException("RedisHashKey \u4e3a\u7a7a\uff01");
            }
            SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(reqVo.getRedisHashKey());
            String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
            sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)this.redisService.hmget(SfaVisitPlanInfoEntity.getInstance().redisHashCurrent(now, visitRedisHashKey.getVisitBigType()).toString(), (Object)reqVo.getRedisHashKey());
            if (null == sfaVisitPlanInfoEntity) {
                throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u62dc\u8bbf\u4efb\u52a1[" + reqVo.getRedisHashKey() + "]");
            }
        } else {
            sfaVisitPlanInfoEntity = this.sfaVisitPlanInfoServiceEsImpl.findById(reqVo.getId());
            if (null == sfaVisitPlanInfoEntity) {
                throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u62dc\u8bbf\u4efb\u52a1[" + reqVo.getId() + "]");
            }
        }
        return sfaVisitPlanInfoEntity;
    }

    private Set<String> executedActivityIdOfCurrentDayFromEs(String activityType2, String stepCode, String clientCode) {
        Set<String> esHistory = SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal().equals(activityType2) ? this.sfaVisitStepActivityExecutionServiceEsImpl.getCompleteDisplayActivityIdsAfterDate(stepCode, clientCode, LocalDate.now()) : this.sfaVisitStepActivityExecutionServiceEsImpl.getCompleteCostActivityIdsAfterDate(stepCode, clientCode, LocalDate.now());
        return esHistory;
    }

    @Override
    public SfaVisitStepActivityExecutionRespVo query(SfaVisitStepActivityExecutionReqVo reqVo) {
        return null;
    }

    @Override
    @CrmDictMethod
    public SfaActivityExecutionRespVo queryDetailById(String id) {
        SfaVisitStepActivityExecutionEntity executionEntity = (SfaVisitStepActivityExecutionEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one();
        if (executionEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6267\u884c\u660e\u7ec6\u6570\u636e");
        }
        SfaActivityExecutionRespVo respVo = this.sfaActivityExecutionService.queryDetailById(executionEntity.getActivityExecutionId());
        List executionTypeEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepActivityExecutionTypeService.lambdaQuery().eq(SfaVisitStepActivityExecutionTypeEntity::getStepActivityExecutionId, (Object)executionEntity.getId())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)executionTypeEntities)) {
            List executionTypeRespVoList = CrmBeanUtil.copyList((List)executionTypeEntities, SfaVisitStepActivityExecutionTypeRespVo.class);
            executionTypeRespVoList.forEach(data -> {
                List sfaVisitPictureEntityList = ((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)data.getId())).list();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaVisitPictureEntityList)) {
                    List pictureRespVos = CrmBeanUtil.copyList((List)sfaVisitPictureEntityList, SfaVisitPictureRespVo.class);
                    data.setPictureList(pictureRespVos);
                }
            });
            respVo.setStepActivityExecutionTypeList(executionTypeRespVoList);
        }
        return respVo;
    }

    @Override
    public SfaActivityExecutionRespVo queryVisitActivityExecutionDetailById(SfaVisitStepActivityExecutionReqVo reqVo) {
        SfaVisitStepActivityExecutionEntity executionEntity = (SfaVisitStepActivityExecutionEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepActivityExecutionEntity::getActivityExecutionId, (Object)reqVo.getActivityExecutionId())).eq(SfaVisitStepActivityExecutionEntity::getStepCode, (Object)reqVo.getVisitId())).one();
        SfaActivityExecutionRespVo respVo = null;
        if (executionEntity == null) {
            respVo = this.sfaActivityExecutionService.queryDetailById(reqVo.getActivityExecutionId());
            if (respVo == null) {
                throw new BusinessException("\u67e5\u8be2\u6d3b\u52a8\u6267\u884c\u8be6\u60c5\u4fe1\u606f\u4e3a\u7a7a");
            }
        } else {
            respVo = this.sfaActivityExecutionService.queryDetailById(executionEntity.getActivityExecutionId());
            List executionTypeEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepActivityExecutionTypeService.lambdaQuery().eq(SfaVisitStepActivityExecutionTypeEntity::getStepActivityExecutionId, (Object)executionEntity.getId())).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)executionTypeEntities)) {
                List executionTypeRespVoList = CrmBeanUtil.copyList((List)executionTypeEntities, SfaVisitStepActivityExecutionTypeRespVo.class);
                executionTypeRespVoList.forEach(data -> {
                    List sfaVisitPictureEntityList = ((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)data.getId())).list();
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaVisitPictureEntityList)) {
                        List pictureRespVos = CrmBeanUtil.copyList((List)sfaVisitPictureEntityList, SfaVisitPictureRespVo.class);
                        data.setPictureList(pictureRespVos);
                    }
                });
                respVo.setStepActivityExecutionTypeList(executionTypeRespVoList);
            }
        }
        return respVo;
    }

    @Override
    public SfaActivityExecutionRespVo findVisitCostActivityExecutionByVisitId(String visitId) {
        SfaVisitStepActivityExecutionEntity executionEntity = (SfaVisitStepActivityExecutionEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepActivityExecutionEntity::getActivityType, (Object)SfaActivityEnum.activityType.COST_ACTIVITY.getVal())).eq(SfaVisitStepActivityExecutionEntity::getStepCode, (Object)visitId)).one();
        if (executionEntity == null) {
            SfaActivityExecutionRespVo sfaActivityExecutionRespVo = new SfaActivityExecutionRespVo();
            sfaActivityExecutionRespVo.setStepActivityExecutionTypeList((List)Lists.newArrayList());
            return sfaActivityExecutionRespVo;
        }
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.sfaActivityExecutionService.queryDetailById(executionEntity.getActivityExecutionId());
        sfaActivityExecutionRespVo.setRemarks(executionEntity.getRemarks());
        List executionTypeEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepActivityExecutionTypeService.lambdaQuery().eq(SfaVisitStepActivityExecutionTypeEntity::getStepActivityExecutionId, (Object)executionEntity.getId())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)executionTypeEntities)) {
            List executionTypeRespVoList = CrmBeanUtil.copyList((List)executionTypeEntities, SfaVisitStepActivityExecutionTypeRespVo.class);
            executionTypeRespVoList.forEach(data -> {
                List sfaVisitPictureEntityList = ((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)data.getId())).list();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaVisitPictureEntityList)) {
                    List pictureRespVos = CrmBeanUtil.copyList((List)sfaVisitPictureEntityList, SfaVisitPictureRespVo.class);
                    data.setPictureList(pictureRespVos);
                }
            });
            sfaActivityExecutionRespVo.setStepActivityExecutionTypeList(executionTypeRespVoList);
        }
        return sfaActivityExecutionRespVo;
    }

    @Override
    public SfaActivityExecutionRespVo findVisitDisplayActivityExecutionByVisitId(String visitId) {
        SfaVisitStepActivityExecutionEntity executionEntity = (SfaVisitStepActivityExecutionEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepActivityExecutionEntity::getActivityType, (Object)SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal())).eq(SfaVisitStepActivityExecutionEntity::getStepCode, (Object)visitId)).one();
        if (executionEntity == null) {
            SfaActivityExecutionRespVo respVo = new SfaActivityExecutionRespVo();
            respVo.setStepActivityExecutionTypeList((List)Lists.newArrayList());
            return respVo;
        }
        SfaActivityExecutionRespVo respVo = this.sfaActivityExecutionService.queryDetailById(executionEntity.getActivityExecutionId());
        respVo.setRemarks(executionEntity.getRemarks());
        List executionTypeEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepActivityExecutionTypeService.lambdaQuery().eq(SfaVisitStepActivityExecutionTypeEntity::getStepActivityExecutionId, (Object)executionEntity.getId())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)executionTypeEntities)) {
            List executionTypeRespVoList = CrmBeanUtil.copyList((List)executionTypeEntities, SfaVisitStepActivityExecutionTypeRespVo.class);
            executionTypeRespVoList.forEach(data -> {
                List sfaVisitPictureEntityList = ((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)data.getId())).list();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaVisitPictureEntityList)) {
                    List pictureRespVos = CrmBeanUtil.copyList((List)sfaVisitPictureEntityList, SfaVisitPictureRespVo.class);
                    data.setPictureList(pictureRespVos);
                }
            });
            respVo.setStepActivityExecutionTypeList(executionTypeRespVoList);
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitStepActivityExecutionReqVo reqVo) {
        SfaVisitStepActivityExecutionEntity entity = (SfaVisitStepActivityExecutionEntity)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepActivityExecutionEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional
    public void saveVisitActivityExecutionForVisit(SfaVisitStepActivityExecutionReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getVisitId(), (String)"\u62dc\u8bbfid\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkParam(reqVo);
        SfaVisitStepActivityExecutionEntity visitStepActivityExecutionEntity = (SfaVisitStepActivityExecutionEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepActivityExecutionEntity::getStepCode, (Object)reqVo.getVisitId())).eq(SfaVisitStepActivityExecutionEntity::getActivityExecutionId, (Object)reqVo.getActivityExecutionId())).one();
        if (null != visitStepActivityExecutionEntity) {
            String id = visitStepActivityExecutionEntity.getId();
            this.removeById((Serializable)((Object)id));
            List stepActivityExecutionTypeEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepActivityExecutionTypeService.lambdaQuery().eq(SfaVisitStepActivityExecutionTypeEntity::getStepActivityExecutionId, (Object)id)).list();
            List stepIds = stepActivityExecutionTypeEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            this.sfaVisitStepActivityExecutionTypeService.removeByIds(stepIds);
            List sfaVisitPictureEntities = ((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().in(SfaVisitPictureEntity::getBusinessId, stepIds)).list();
            List picIdList = sfaVisitPictureEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            this.sfaVisitPictureService.removeByIds(picIdList);
        }
        this.saveWorkActivityExecution(reqVo);
    }

    @Override
    @Transactional
    public String saveVisitActivityExecutionForWorkbench(SfaVisitStepActivityExecutionReqVo reqVo) {
        this.checkParam(reqVo);
        return this.saveWorkActivityExecution(reqVo);
    }

    public String saveWorkActivityExecution(SfaVisitStepActivityExecutionReqVo reqVo) {
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.sfaActivityExecutionService.queryDetailById(reqVo.getActivityExecutionId());
        if (sfaActivityExecutionRespVo == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6267\u884c\u660e\u7ec6\u6570\u636e");
        }
        List lastExecutionEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepActivityExecutionEntity::getActivityExecutionId, (Object)reqVo.getActivityExecutionId())).orderByDesc(CrmBaseEntity::getCreateDate)).orderByDesc(CrmBaseEntity::getCreateDateSecond)).list();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)lastExecutionEntityList)) {
            sfaActivityExecutionRespVo.setLastActivityTime(((SfaVisitStepActivityExecutionEntity)lastExecutionEntityList.get(0)).getActivityTime());
        }
        sfaActivityExecutionRespVo.setClientName(reqVo.getClientName());
        String activityTime = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
        reqVo.setActivityTime(activityTime);
        reqVo.setActivityType(sfaActivityExecutionRespVo.getActivityType());
        SfaVisitStepActivityExecutionEntity executionEntity = (SfaVisitStepActivityExecutionEntity)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepActivityExecutionEntity.class);
        executionEntity.setActivityName(sfaActivityExecutionRespVo.getActivityName());
        executionEntity.setActivityStartTime(sfaActivityExecutionRespVo.getActivityStartTime());
        executionEntity.setActivityEndTime(sfaActivityExecutionRespVo.getActivityEndTime());
        if (sfaActivityExecutionRespVo.getActivityFrequency() != null) {
            executionEntity.setActivityFrequency(sfaActivityExecutionRespVo.getActivityFrequency());
        }
        executionEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        executionEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save(executionEntity);
        String stepActivityExecutionId = executionEntity.getId();
        reqVo.getStepActivityExecutionTypeList().forEach(data -> {
            SfaVisitStepActivityExecutionTypeEntity executionTypeEntity = (SfaVisitStepActivityExecutionTypeEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaVisitStepActivityExecutionTypeEntity.class)));
            executionTypeEntity.setStepActivityExecutionId(stepActivityExecutionId);
            this.sfaVisitStepActivityExecutionTypeService.save((Object)executionTypeEntity);
            String businessId = executionTypeEntity.getId();
            List pictureEntityList = CrmBeanUtil.copyList((List)data.getPictureList(), SfaVisitPictureEntity.class);
            pictureEntityList.forEach(pic -> {
                pic.setBusinessId(businessId);
                pic.setVisitId(reqVo.getVisitId());
            });
            this.sfaVisitPictureService.saveBatch(pictureEntityList);
        });
        String id = executionEntity.getId();
        return id;
    }

    private void checkParam(SfaVisitStepActivityExecutionReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getActivityExecutionId(), (String)"\u6d3b\u52a8\u6267\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientName(), (String)"\u7f51\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientId(), (String)"\u7f51\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u7f51\u70b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getLongitude(), (String)"\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getLatitude(), (String)"\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getStepActivityExecutionTypeList(), (String)"\u6d3b\u52a8\u6267\u884c\u7c7b\u578b\u62cd\u7167\u6570\u636e\u4e3a\u7a7a");
        reqVo.getStepActivityExecutionTypeList().forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getActivityRequire(), (String)"\u6d3b\u52a8\u7167\u7247\u7c7b\u578b\u4e3a\u7a7a");
            if (!SfaActivityEnum.activityRequire.GETMAP.containsKey(data.getActivityRequire())) {
                throw new BusinessException("\u9519\u8bef\u7684\u6d3b\u52a8\u7167\u7247\u7c7b\u578b");
            }
            AssertUtils.isNotEmpty((Collection)data.getPictureList(), (String)"\u6d3b\u52a8\u7167\u7247\u4e3a\u7a7a");
        });
        UserRedis user = UserUtils.getUser();
        reqVo.setUserName(user.getUsername());
        reqVo.setRealName(user.getRealname());
        reqVo.setPosCode(user.getPoscode());
        reqVo.setPosName(user.getPosname());
        reqVo.setOrgCode(user.getOrgcode());
        reqVo.setOrgName(user.getOrgname());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitStepActivityExecutionReqVo reqVo) {
        SfaVisitStepActivityExecutionEntity entity = (SfaVisitStepActivityExecutionEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitStepActivityExecutionReqVo reqVo) {
        List sfaVisitStepActivityExecutionEntities = this.sfaVisitStepActivityExecutionMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepActivityExecutionEntities)) {
            sfaVisitStepActivityExecutionEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitStepActivityExecutionEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitStepActivityExecutionReqVo reqVo) {
        List sfaVisitStepActivityExecutionEntities = this.sfaVisitStepActivityExecutionMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepActivityExecutionEntities)) {
            sfaVisitStepActivityExecutionEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepActivityExecutionEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitStepActivityExecutionReqVo reqVo) {
        List sfaVisitStepActivityExecutionEntities = this.sfaVisitStepActivityExecutionMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepActivityExecutionEntities)) {
            sfaVisitStepActivityExecutionEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepActivityExecutionEntities);
    }

    private MdmCustomerMsgRespVo getMdmCustomerMsgRespVo(String clientCode) {
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = null;
        Result mdmCustomerMsgRespVoResult = this.mdmCustomerMsgFeign.query(null, clientCode);
        if (mdmCustomerMsgRespVoResult.isSuccess() && mdmCustomerMsgRespVoResult.getResult() != null) {
            mdmCustomerMsgRespVo = (MdmCustomerMsgRespVo)mdmCustomerMsgRespVoResult.getResult();
        }
        return mdmCustomerMsgRespVo;
    }

    private MdmTerminalVo getMdmTerminalVo(String clientCode) {
        MdmTerminalVo mdmTerminalVo = null;
        Result mdmTerminalVoResult = this.mdmTerminalFeign.query(null, clientCode);
        if (mdmTerminalVoResult.isSuccess() && mdmTerminalVoResult.getResult() != null) {
            mdmTerminalVo = (MdmTerminalVo)mdmTerminalVoResult.getResult();
        }
        return mdmTerminalVo;
    }

    @Override
    @Transactional
    public List<? extends VisitStepListener.VisitStepListenerCommittedData> dataDurability(List<? extends VisitStepListener.VisitStepListenerCommittedData> baseEntity, SfaVisitStepFromRespVo fromRespVo) {
        if (org.springframework.util.CollectionUtils.isEmpty(baseEntity)) {
            return Lists.newArrayList();
        }
        List<? extends VisitStepListener.VisitStepListenerCommittedData> executionEntities = baseEntity;
        this.save(executionEntities);
        this.doTransToEs(executionEntities, fromRespVo);
        return baseEntity;
    }

    @Override
    @Transactional
    public void save(List<? extends SfaVisitStepActivityExecutionEntity> executionEntities) {
        this.saveOrUpdateBatch(executionEntities);
        List<? extends SfaVisitStepActivityExecutionEntity> redisData = executionEntities;
        this.saveActivityRequire(redisData);
    }

    private void saveActivityRequire(List<SfaVisitStepActivityExecutionRedisData> redisData) {
        if (null == redisData) {
            return;
        }
        ArrayList attachmentEntities = Lists.newArrayList();
        for (SfaVisitStepActivityExecutionRedisData redisDatum : redisData) {
            if (!SfaVisitEnum.VISIT_OFF_LINE.online.equals((Object)redisDatum.getLineType())) continue;
            List<ActivityStepExecuteData.ActivityRequireReqVo> activityRequireReqVoList = redisDatum.getActivityRequireReqVoList();
            String id = redisDatum.getId();
            SfaAttachmentUtil.delByBizIdInBizTypeEnums(Lists.newArrayList((Object[])new AttachmentBizTypeEnum[]{AttachmentBizTypeEnum.ACTIVITY_REQUIRE0, AttachmentBizTypeEnum.ACTIVITY_REQUIRE1, AttachmentBizTypeEnum.ACTIVITY_REQUIRE2}), id);
            if (null == activityRequireReqVoList) continue;
            for (ActivityStepExecuteData.ActivityRequireReqVo requireReqVo : activityRequireReqVoList) {
                AttachmentBizTypeEnum bizType = (AttachmentBizTypeEnum)AttachmentBizTypeEnum.VAL_MAP_ENUM.get("activity_require" + requireReqVo.getActivityRequire());
                attachmentEntities.addAll(SfaAttachmentUtil.build(requireReqVo.getPictureList(), bizType, id));
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)attachmentEntities)) {
            SfaAttachmentUtil.insert(attachmentEntities);
        }
    }

    protected void doTransToEs(List<? extends SfaVisitStepActivityExecutionEntity> redisDataList, SfaVisitStepFromRespVo fromRespVo) {
        if (org.springframework.util.CollectionUtils.isEmpty(redisDataList)) {
            return;
        }
        SfaVisitStepActivityExecutionRedisData redisData = (SfaVisitStepActivityExecutionRedisData)redisDataList.get(0);
        if (SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal().equals(redisData.getActivityType())) {
            this.transToEsForDisplay(redisDataList, fromRespVo);
        } else {
            this.transToEsForCost(redisDataList, fromRespVo);
        }
    }

    protected void transToEsForCost(List<? extends SfaVisitStepActivityExecutionEntity> redisDataList, SfaVisitStepFromRespVo fromRespVo) {
        ArrayList esData = Lists.newArrayList();
        for (SfaVisitStepActivityExecutionEntity sfaVisitStepActivityExecutionEntity : redisDataList) {
            SfaVisitStepActivityExecutionRedisData redisData = (SfaVisitStepActivityExecutionRedisData)sfaVisitStepActivityExecutionEntity;
            SfaVisitStepActivityCostExecutionEsData dataResp = (SfaVisitStepActivityCostExecutionEsData)CrmBeanUtil.copy((Object)redisData, SfaVisitStepActivityCostExecutionEsData.class);
            dataResp.setActivityRequireReqVoList(redisData.getActivityRequireReqVoList());
            if (null != fromRespVo) {
                dataResp.setSfaVisitStepFrom(fromRespVo);
                dataResp.setFormId(fromRespVo.getId());
                dataResp.setStepCode(fromRespVo.getStepCode());
            }
            if (StringUtils.isBlank((CharSequence)dataResp.getVisitPlanInfoId())) {
                dataResp.setVisitPlanInfoId(dataResp.getId());
            }
            esData.add(dataResp);
        }
        if (!putMappingCost) {
            this.elasticsearchTemplate.putMapping(SfaVisitStepActivityCostExecutionEsData.class);
            putMappingCost = true;
        }
        this.sfaVisitStepActivityCostExecutionEsDataRepositories.saveAll(esData);
        this.sfaVisitStepActivityCostExecutionEsDataRepositories.refresh();
    }

    protected void transToEsForDisplay(List<? extends SfaVisitStepActivityExecutionEntity> redisDataList, SfaVisitStepFromRespVo fromRespVo) {
        ArrayList esData = Lists.newArrayList();
        for (SfaVisitStepActivityExecutionEntity sfaVisitStepActivityExecutionEntity : redisDataList) {
            SfaVisitStepActivityExecutionRedisData redisData = (SfaVisitStepActivityExecutionRedisData)sfaVisitStepActivityExecutionEntity;
            SfaVisitStepActivityDisplayExecutionEsData dataResp = (SfaVisitStepActivityDisplayExecutionEsData)CrmBeanUtil.copy((Object)redisData, SfaVisitStepActivityDisplayExecutionEsData.class);
            dataResp.setActivityRequireReqVoList(redisData.getActivityRequireReqVoList());
            if (null != fromRespVo) {
                dataResp.setSfaVisitStepFrom(fromRespVo);
                dataResp.setFormId(fromRespVo.getId());
                dataResp.setStepCode(fromRespVo.getStepCode());
            }
            SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.loadSfaActData(redisData.getActivityExecutionId());
            dataResp.setDisplayContent(this.buildDisplayContent(sfaActivityExecutionRespVo));
            if (StringUtils.isBlank((CharSequence)dataResp.getVisitPlanInfoId())) {
                dataResp.setVisitPlanInfoId(dataResp.getId());
            }
            esData.add(dataResp);
        }
        if (!putMappingDisplay) {
            this.elasticsearchTemplate.putMapping(SfaVisitStepActivityDisplayExecutionEsData.class);
            putMappingDisplay = true;
        }
        this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.saveAll(esData);
        this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.refresh();
    }

    protected SfaActivityExecutionRespVo loadSfaActData(String activityExecutionId) {
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.sfaActivityExecutionService.queryDetailById(activityExecutionId);
        if (sfaActivityExecutionRespVo == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6570\u636e");
        }
        return sfaActivityExecutionRespVo;
    }

    private ActivityDisplayStepExecuteDataResp.DisplayContent buildDisplayContent(SfaActivityExecutionRespVo sfaActivityExecutionRespVo) {
        ActivityDisplayStepExecuteDataResp.DisplayContent displayContent = new ActivityDisplayStepExecuteDataResp.DisplayContent();
        displayContent.setActivityProductList(sfaActivityExecutionRespVo.getActivityProductList());
        List visitPictureList = sfaActivityExecutionRespVo.getVisitPictureList();
        List pictureList = CrmAttachment.convertVisitPic((List)visitPictureList);
        displayContent.setPictureList(pictureList);
        return displayContent;
    }
}

