/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.integral.service.component;

import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.integral.controller.SfaIntegralSaveUtil;
import com.biz.crm.integral.req.SfaIntegralDetailAddReq;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitInfoPlanListener;
import com.biz.crm.moblie.controller.visit.component.VisitInfoPlanListener;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class SfaIntegralVisitListener
extends AbstractVisitInfoPlanListener {
    protected static Map<String, String> visitBigTypeMappingIntegralTaskType = Maps.newHashMap();
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;

    @Override
    protected Set<String> visitBigTypeRegistry() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal());
        hashSet.add(SfaVisitEnum.VisitBigType.VISIT.getVal());
        return hashSet;
    }

    @Override
    public void created(VisitInfoPlanListener.VisitInfoPlanListenerEvent event) {
    }

    @Override
    public void begin(VisitInfoPlanListener.DoneEvent doneEvent) {
    }

    @Override
    public void committed(VisitInfoPlanListener.DoneEvent doneEvent) {
        SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = doneEvent.getSfaVisitPlanInfoRedisData();
        if (!SfaVisitEnum.visitType.PLAN_VISIT.getVal().equals(sfaVisitPlanInfoRedisData.getVisitType())) {
            return;
        }
        if (this.isComplete(doneEvent, sfaVisitPlanInfoRedisData)) {
            SfaIntegralDetailAddReq integralDetailAddReq = new SfaIntegralDetailAddReq();
            String integralTaskType = visitBigTypeMappingIntegralTaskType.get(sfaVisitPlanInfoRedisData.getVisitBigType());
            String userName = sfaVisitPlanInfoRedisData.getVisitUserName();
            String posCode = sfaVisitPlanInfoRedisData.getVisitPosCode();
            StringJoiner bizId = new StringJoiner(":");
            bizId.add(integralTaskType);
            bizId.add(userName);
            bizId.add(posCode);
            bizId.add(sfaVisitPlanInfoRedisData.getVisitDate());
            integralDetailAddReq.setBizId(bizId.toString());
            integralDetailAddReq.setIntegralTaskType(integralTaskType);
            integralDetailAddReq.setPosCode(posCode);
            integralDetailAddReq.setUserName(userName);
            integralDetailAddReq.setExtParam(null);
            SfaIntegralSaveUtil.saveIntegralDetail(integralDetailAddReq);
        }
    }

    protected boolean isComplete(VisitInfoPlanListener.DoneEvent doneEvent, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData) {
        GetVisitListReq req = new GetVisitListReq();
        req.setVisitPositionCode(sfaVisitPlanInfoRedisData.getVisitPosCode());
        req.setVisitUserName(sfaVisitPlanInfoRedisData.getVisitUserName());
        req.setVisitDate(sfaVisitPlanInfoRedisData.getVisitDate());
        req.setVisitBigType(sfaVisitPlanInfoRedisData.getVisitBigType());
        List<SfaVisitPlanInfoEntity> planInfoEntities = this.sfaVisitPlanInfoService.doGetVisitInfoList(req).stream().filter(v -> SfaVisitEnum.visitType.PLAN_VISIT.getVal().equals(v.getVisitType())).collect(Collectors.toList());
        int complete = SfaVisitPlanInfoEntity.countingCompletedNum(planInfoEntities);
        return complete == planInfoEntities.size() && planInfoEntities.size() != 0;
    }

    @Override
    public void noCommit(VisitInfoPlanListener.DoneEvent doneEvent) {
    }

    @Override
    public void overdue(VisitInfoPlanListener.VisitInfoPlanListenerEvent event) {
    }

    static {
        visitBigTypeMappingIntegralTaskType.put(SfaVisitEnum.VisitBigType.VISIT.getVal(), IntegralEnum.taskType.DAY_VISIT_PLAN.getValue());
        visitBigTypeMappingIntegralTaskType.put(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal(), IntegralEnum.taskType.DAY_HELP_VISIT_PLAN.getValue());
    }
}

