/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitGroupReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitGroupRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitnote.service.ISfaVisitGroupService;
import com.biz.crm.visitnote.service.ISfaVisitPlanService;
import com.biz.crm.visitnote.service.ISfaVisitTempPlanService;
import com.biz.crm.visitnote.service.component.resolver.SfaVisitPlanResolver;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaWorkVisitPlanController"})
@Api(tags={"\u5c0f\u7a0b\u5e8f\u7aef-\u5de5\u4f5c\u53f0-\u62dc\u8bbf\u8ba1\u5212"})
public class SfaWorkVisitPlanController {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkVisitPlanController.class);
    @Autowired
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Autowired
    private ISfaVisitGroupService sfaVisitGroupService;
    @Autowired
    private ISfaVisitPlanService sfaVisitPlanService;
    @Autowired
    private ISfaVisitTempPlanService sfaVisitTempPlanService;

    @ApiOperation(value="\u4e34\u65f6\u62dc\u8bbf\u8ba1\u5212\u5217\u8868\u67e5\u8be2(\u4e34\u65f6/\u5468\u671f\u62dc\u8bbf\u8ba1\u5212)")
    @PostMapping(value={"/findVisitPlanInfoList"})
    @CrmLog
    public Result<List<SfaVisitPlanInfoRespVo>> findVisitPlanInfoList(@RequestBody SfaVisitPlanInfoReqVo reqVo) {
        return Result.ok((Object)CrmBeanUtil.copyList(this.doFindVisitPlanInfoList(reqVo), SfaVisitPlanInfoRespVo.class));
    }

    private List<SfaVisitPlanInfoEntity> doFindVisitPlanInfoList(SfaVisitPlanInfoReqVo reqVo) {
        LocalDate visitDate;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqVo.getVisitDate())) {
            throw new BusinessException("\u65e5\u671f\u4e3a\u7a7a\uff01");
        }
        try {
            visitDate = LocalDate.parse(reqVo.getVisitDate(), CrmDateUtils.yyyyMMdd);
        }
        catch (Exception e) {
            throw new BusinessException("\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (Throwable)e);
        }
        SfaVisitPlanResolver.futureDaysCheck(visitDate);
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis.getUsertype().equals(UserTypeEnum.CUSTOMER_EMPLOYEE.getCode())) {
            userRedis.setPoscode(userRedis.getUsername());
        }
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqVo.getVisitPosCode())) {
            reqVo.setVisitUserName(userRedis.getUsername());
            reqVo.setVisitPosCode(userRedis.getPoscode());
        }
        GetVisitListReq.MoreReq req = new GetVisitListReq.MoreReq();
        req.setVisitUserName(reqVo.getVisitUserName());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqVo.getVisitPosCode())) {
            throw new BusinessException("\u804c\u4f4d\u4e3a\u7a7a\uff01");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqVo.getClientType())) {
            throw new BusinessException("\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        req.setVisitPositionCode(reqVo.getVisitPosCode());
        req.setVisitDate(reqVo.getVisitDate());
        req.setClientType(reqVo.getClientType());
        req.setKeyWord(reqVo.getKeyWord());
        List<SfaVisitPlanInfoEntity> list = this.sfaVisitPlanInfoService.getVisitInfoListByClientType(req);
        return list;
    }

    @ApiOperation(value="\u67e5\u8be2\u7ebf\u8def\u7ec4\u5217\u8868")
    @PostMapping(value={"/findVisitGroupList"})
    @CrmLog
    public Result<PageResult<SfaVisitGroupRespVo>> findVisitGroupList(@RequestBody SfaVisitGroupReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setUserName(userName);
        }
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        PageResult<SfaVisitGroupRespVo> result = this.sfaVisitGroupService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u7ebf\u8def\u7ec4\u67e5\u8be2")
    @PostMapping(value={"/visitGroupQuery"})
    @CrmLog
    public Result<SfaVisitGroupRespVo> visitGroupQuery(@RequestBody SfaVisitGroupReqVo reqVo) {
        SfaVisitGroupRespVo respVo = this.sfaVisitGroupService.query(reqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u7ebf\u8def\u7ec4\u65b0\u589e")
    @PostMapping(value={"/visitGroupSave"})
    @CrmLog
    public Result visitGroupSave(@RequestBody SfaVisitGroupReqVo reqVo) {
        this.sfaVisitGroupService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7ebf\u8def\u7ec4\u66f4\u65b0\u66f4\u65b0")
    @PostMapping(value={"/visitGroupUpdate"})
    @CrmLog
    public Result visitGroupUpdate(@RequestBody SfaVisitGroupReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setUserName(userName);
        }
        this.sfaVisitGroupService.update(reqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u7ebf\u8def\u7ec4\u5220\u9664")
    @PostMapping(value={"/visitGroupDelete"})
    @CrmLog
    public Result visitGroupDelete(@RequestBody List<String> ids) {
        this.sfaVisitGroupService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u5468\u671f\u6027\u62dc\u8bbf\u5217\u8868")
    @PostMapping(value={"/findVisitPlanList"})
    @CrmLog
    public Result<PageResult<SfaVisitPlanRespVo>> findVisitPlanList(@RequestBody SfaVisitPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            UserRedis user = UserUtils.getUser();
            if (user.getUsertype().equals(UserTypeEnum.CUSTOMER_EMPLOYEE.getCode())) {
                user.setPoscode(user.getUsername());
            }
            reqVo.setVisitUserName(user.getUsername());
            reqVo.setVisitPosCode(user.getPoscode());
        }
        reqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        reqVo.setRouteType(SfaVisitEnum.routeTypeEnum.R1.getVal());
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        PageResult<SfaVisitPlanRespVo> result = this.sfaVisitPlanService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5468\u671f\u6027\u62dc\u8bbf\u67e5\u8be2")
    @PostMapping(value={"/visitPlanQuery"})
    @CrmLog
    public Result<SfaVisitPlanRespVo> visitPlanQuery(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanReqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        SfaVisitPlanRespVo respVo = this.sfaVisitPlanService.query(sfaVisitPlanReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u5468\u671f\u6027\u62dc\u8bbf\u65b0\u589e")
    @PostMapping(value={"/visitPlanSave"})
    @CrmLog
    public Result visitPlanSave(@RequestBody SfaVisitPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            if (userRedis.getUsertype().equals(UserTypeEnum.CUSTOMER_EMPLOYEE.getCode())) {
                userRedis.setPoscode(userRedis.getUsername());
                userRedis.setPosname(userRedis.getRealname());
            }
            reqVo.setVisitUserName(userRedis.getUsername());
            reqVo.setVisitRealName(userRedis.getRealname());
            reqVo.setVisitOrgCode(userRedis.getOrgcode());
            reqVo.setVisitOrgName(userRedis.getOrgname());
            reqVo.setVisitPosCode(userRedis.getPoscode());
            reqVo.setVisitPosName(userRedis.getPosname());
        }
        reqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        reqVo.setRouteType(SfaVisitEnum.routeTypeEnum.R1.getVal());
        this.sfaVisitPlanService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5468\u671f\u6027\u62dc\u8bbf\u66f4\u65b0")
    @PostMapping(value={"/visitPlanUpdate"})
    @CrmLog
    public Result visitPlanUpdate(@RequestBody SfaVisitPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(userName);
        }
        reqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        reqVo.setRouteType(SfaVisitEnum.routeTypeEnum.R1.getVal());
        this.sfaVisitPlanService.update(reqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5468\u671f\u6027\u62dc\u8bbf\u5220\u9664")
    @PostMapping(value={"/visitPlanDelete"})
    @CrmLog
    public Result visitPlanDelete(@RequestBody List<String> ids) {
        this.sfaVisitPlanService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u65e5\u671f\u5df2\u5b58\u5728\u7684\u5ba2\u6237\u7c7b\u578b")
    @PostMapping(value={"/findAlreadyCusOrTerminal"})
    @CrmLog
    public Result<List<String>> findAlreadyCusOrTerminal(@RequestBody SfaVisitPlanInfoReqVo reqVo) {
        List clientCodeList = this.doFindVisitPlanInfoList(reqVo).stream().map(SfaVisitPlanInfoEntity::getClientCode).collect(Collectors.toList());
        return Result.ok(clientCodeList);
    }
}

