/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.CompetitorStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.CompetitorStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.CompetitorWorkbenchDataReq;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepColletEntity;
import com.biz.crm.visitstep.model.SfaVisitStepColletEsData;
import com.biz.crm.visitstep.model.SfaVisitStepColletItemEntity;
import com.biz.crm.visitstep.model.SfaVisitStepColletRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepColletEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepColletItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepColletService;
import com.biz.crm.visitstep.service.impl.SfaVisitStepColletServiceImpl;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnMissingBean(name={"competitorVisitStepExecutorExpandImpl"})
public class CompetitorVisitStepExecutor<ExecuteReq extends CompetitorStepExecuteData>
extends AbstractVisitStepRedisExecutor<ExecuteReq, CompetitorStepExecuteDataResp, ExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(CompetitorVisitStepExecutor.class);
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private SfaVisitStepColletEsDataRepositories sfaVisitStepColletEsDataRepositories;
    @Resource
    private SfaVisitStepColletServiceImpl sfaVisitStepColletServiceImpl;
    @Resource
    private ISfaVisitStepColletService sfaVisitStepColletService;
    @Resource
    private ISfaVisitStepColletItemService sfaVisitStepColletItemService;

    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return this.sfaVisitStepColletServiceImpl;
    }

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_COMPETITOR.getVal();
    }

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepColletRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setFormId(visitStepExecuteReq.getFormId());
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.online);
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 1296000L);
    }

    @Override
    public void executeOffLine(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepColletRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        super.check(visitStepExecuteReq);
        redisData.setFormId(visitStepExecuteReq.getFormId());
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.offline);
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 1296000L);
    }

    @Transactional
    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        String id = UUIDGenerator.generate();
        visitStepExecuteReq.setRedisHashKey(id);
        this.check(null, visitStepExecuteReq);
        SfaVisitStepColletRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        CompetitorWorkbenchDataReq dataReq = (CompetitorWorkbenchDataReq)visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        redisData.setId(id);
        redisData.setVisitPlanInfoId(id);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.dataDurability(Lists.newArrayList((Object[])new SfaVisitStepColletRedisData[]{redisData}), fromRespVo);
    }

    protected SfaVisitStepColletRedisData buildRedisData(VisitStepExecuteReq<? extends CompetitorStepExecuteData> visitStepExecuteReq) {
        CompetitorStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData)CrmBeanUtil.copy((Object)executeData, SfaVisitStepColletRedisData.class);
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setSfaVisitStepColletItemReqVos(executeData.getSfaVisitStepColletItemReqVos());
        redisData.setSfaVisitPictureReqVos(executeData.getSfaVisitPictureReqVos());
        return redisData;
    }

    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepColletRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)redisData);
        if (SfaVisitEnum.ClientType.TERMINAL.getVal().equals(sfaVisitPlanInfoEntity.getClientType())) {
            this.injectOrgInfoOfTerminal(sfaVisitPlanInfoEntity, redisData);
        } else {
            this.injectOrgInfoOfTerminalCustomer(sfaVisitPlanInfoEntity, redisData);
        }
        if (sfaVisitPlanInfoEntity instanceof SfaVisitPlanInfoEntity) {
            this.buildClientData(redisData, (SfaVisitPlanInfoEntity)sfaVisitPlanInfoEntity);
        } else {
            this.buildClientData(redisData, sfaVisitPlanInfoEntity.getClientCode(), sfaVisitPlanInfoEntity.getClientType());
        }
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    private void injectOrgInfoOfTerminal(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepColletRedisData redisData) {
        MdmTerminalVo clientVo = (MdmTerminalVo)this.mdmTerminalFeign.query(null, sfaVisitPlanInfoEntity.getClientCode()).getResult();
        if (null == clientVo) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u6570\u636e[" + sfaVisitPlanInfoEntity.getClientCode() + "]");
        }
        MdmOrgRespVo resultParent = (MdmOrgRespVo)this.mdmOrgFeign.getParentOrg(null, clientVo.getOrgCode()).getResult();
        if (null != resultParent) {
            redisData.setClientAreaId(resultParent.getOrgCode());
            redisData.setClientArea(resultParent.getOrgName());
        }
        redisData.setClientOfficeId(clientVo.getOrgCode());
        redisData.setClientOffice(clientVo.getOrgName());
    }

    private void injectOrgInfoOfTerminalCustomer(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepColletRedisData redisData) {
        MdmCustomerMsgRespVo clientVo = (MdmCustomerMsgRespVo)this.mdmCustomerMsgFeign.query(null, sfaVisitPlanInfoEntity.getClientCode()).getResult();
        if (null == clientVo) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u6570\u636e[" + sfaVisitPlanInfoEntity.getClientCode() + "]");
        }
        MdmOrgRespVo resultParent = (MdmOrgRespVo)this.mdmOrgFeign.getParentOrg(null, clientVo.getOrgCode()).getResult();
        if (null != resultParent) {
            redisData.setClientAreaId(resultParent.getOrgCode());
            redisData.setClientArea(resultParent.getOrgName());
        }
        redisData.setClientOfficeId(clientVo.getOrgCode());
        redisData.setClientOffice(clientVo.getOrgName());
    }

    protected void check(SfaVisitPlanInfoEntity entity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        CompetitorStepExecuteData stepExecuteData = (CompetitorStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        super.checkLongitudeAndLatitude(visitStepExecuteReq, entity, stepExecuteData.getLongitude(), stepExecuteData.getLatitude());
        if (CollectionUtils.isEmpty(stepExecuteData.getSfaVisitStepColletItemReqVos())) {
            throw new BusinessException("\u7ade\u54c1\u5546\u54c1\u6e05\u5355\u4e3a\u7a7a");
        }
        List<CrmAttachment> sfaVisitPictureReqVos = stepExecuteData.getSfaVisitPictureReqVos();
        this.checkPics(sfaVisitPictureReqVos, 1, 5, "\u7ade\u54c1");
    }

    @Override
    protected CompetitorStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData)this.redisService.hmget(SfaVisitStepColletRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)redisHashKey.getRedisHashKey());
        if (null == redisData) {
            redisData = new SfaVisitStepColletRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setSfaVisitPictureReqVos(list);
                    this.setSfaVisitStepColletItemReqVos(list);
                }
            };
        }
        CompetitorStepExecuteDataResp dataResp = (CompetitorStepExecuteDataResp)CrmBeanUtil.copy((Object)redisData, CompetitorStepExecuteDataResp.class);
        dataResp.setSfaVisitPictureReqVos(redisData.getSfaVisitPictureReqVos());
        dataResp.setSfaVisitStepColletItemReqVos(redisData.getSfaVisitStepColletItemReqVos());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }

    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional optional = this.sfaVisitStepColletEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return (StepExecuteDataResp)optional.get();
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
    }

    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        SfaVisitStepColletEsData esData = this.sfaVisitStepColletEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }

    @Override
    protected CompetitorStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        String bizId = loadParam.getBizId();
        if (StringUtils.isNotBlank((CharSequence)loadParam.getVisitPlanInfoId())) {
            if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            CompetitorStepExecuteDataResp dataResp = this.buildDataResp(loadParam.getVisitPlanInfoId(), loadParam.getStepCode(), null);
            return dataResp;
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            SfaClientData clientData = SfaClientHelper.loadClientData(loadParam.getClientType(), loadParam.getClientCode());
            if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            CompetitorStepExecuteDataResp dataResp = new CompetitorStepExecuteDataResp(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setSfaVisitPictureReqVos(list);
                    this.setSfaVisitStepColletItemReqVos(list);
                }
            };
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode(), loadParam.getVisitBigType(), clientData.getClientSubclass()));
            return dataResp;
        }
        CompetitorStepExecuteDataResp dataResp = this.buildDataResp(null, null, bizId);
        return dataResp;
    }

    protected CompetitorStepExecuteDataResp buildDataResp(String visitPlanInfoId, String stepCode, String bizId) {
        LambdaQueryChainWrapper colletLambdaQuery = this.sfaVisitStepColletService.lambdaQuery();
        SfaVisitStepColletEntity colletEntity = (SfaVisitStepColletEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)colletLambdaQuery.eq(StringUtils.isNotBlank((CharSequence)stepCode), SfaVisitStepColletEntity::getStepCode, (Object)stepCode)).eq(StringUtils.isNotBlank((CharSequence)visitPlanInfoId), SfaVisitStepColletEntity::getVisitPlanInfoId, (Object)visitPlanInfoId)).eq(StringUtils.isNotBlank((CharSequence)bizId), BaseIdEntity::getId, (Object)bizId)).one();
        CompetitorStepExecuteDataResp dataResp = (CompetitorStepExecuteDataResp)CrmBeanUtil.copy((Object)colletEntity, CompetitorStepExecuteDataResp.class);
        List itemEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitStepColletItemService.lambdaQuery().eq(SfaVisitStepColletItemEntity::getColletId, (Object)colletEntity.getId())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).list();
        List sfaVisitStepColletItemReqVos = CrmBeanUtil.copyList((List)itemEntities, CompetitorStepExecuteData.ColletItemReqVo.class);
        dataResp.setSfaVisitStepColletItemReqVos(sfaVisitStepColletItemReqVos);
        List attachments = CrmBeanUtil.copyList(SfaAttachmentUtil.getList(AttachmentBizTypeEnum.VISIT_STEP_COLLET, colletEntity.getId()), CrmAttachment.class);
        dataResp.setSfaVisitPictureReqVos(attachments);
        return dataResp;
    }

    private CompetitorStepExecuteDataResp buildDataResp(SfaVisitStepColletEsData redisData) {
        if (null == redisData) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
        }
        CompetitorStepExecuteDataResp dataResp = (CompetitorStepExecuteDataResp)CrmBeanUtil.copy((Object)redisData, CompetitorStepExecuteDataResp.class);
        dataResp.setSfaVisitPictureReqVos(redisData.getSfaVisitPictureReqVos());
        dataResp.setSfaVisitStepColletItemReqVos(redisData.getSfaVisitStepColletItemReqVos());
        dataResp.setSfaVisitStepFrom(redisData.getSfaVisitStepFrom());
        return dataResp;
    }

    @Override
    protected List<? extends VisitStepListener.VisitStepListenerCommittedData> loadRedisDataList(ExecutorLoadReq loadParam) {
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData)this.redisService.hmget(SfaVisitStepColletRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), loadParam.getStepCode()).toString(), (Object)loadParam.getRedisHashKey());
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)loadParam)));
            return null;
        }
        return Lists.newArrayList((Object[])new SfaVisitStepColletRedisData[]{redisData});
    }
}

