/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.service.component.resolver.impl;

import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitGroupReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitGroupRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitclientRelRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.impl.VisitPlanInfoHelper;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.biz.crm.visitnote.service.ISfaVisitGroupService;
import com.biz.crm.visitnote.service.component.SfaVisitPlanExecuteContext;
import com.biz.crm.visitnote.service.component.resolver.impl.AbstractSfaVisitPlanResolver;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="lineResolver")
public class SfaVisitPlanLineResolver
extends AbstractSfaVisitPlanResolver {
    @Resource
    private ISfaVisitGroupService iSfaVisitGroupService;
    @Resource
    private VisitPlanInfoHelper visitPlanInfoHelper;

    @Override
    public void doResolve(SfaVisitPlanExecuteContext context) {
        LocalDate visitDate;
        SfaVisitPlanExecuteContext.FuturePlanInfo futurePlanInfo = new SfaVisitPlanExecuteContext.FuturePlanInfo();
        SfaVisitPlanEntity currentPlanEntity = context.getCurrentPlanEntity();
        while (null != (visitDate = this.visitDateNext(context, futurePlanInfo))) {
            SfaVisitGroupRespVo sfaVisitGroupRespVo = this.loadSfaVisitGroupRespVo(context);
            if (null == sfaVisitGroupRespVo) {
                futurePlanInfo.putPlan(visitDate, Lists.newArrayList());
                return;
            }
            List sfaVisitclientRelRespVos = sfaVisitGroupRespVo.getSfaVisitclientRelRespVos();
            if (CollectionUtils.isEmpty((Collection)sfaVisitclientRelRespVos)) {
                futurePlanInfo.putPlan(visitDate, Lists.newArrayList());
                return;
            }
            List<SfaVisitPlanInfoEntity> planInfoEntities = this.resolveSfaVisitPlanInfoEntityList(context, sfaVisitclientRelRespVos);
            futurePlanInfo.putPlan(visitDate, planInfoEntities);
        }
        context.getPlanCodeMapFuturePlanInfo().put(currentPlanEntity.getVisitPlanCode(), futurePlanInfo);
    }

    protected List<SfaVisitPlanInfoEntity> resolveSfaVisitPlanInfoEntityList(SfaVisitPlanExecuteContext context, List<SfaVisitclientRelRespVo> sfaVisitclientRelRespVos) {
        ArrayList visitPlanInfoEntities = Lists.newArrayList();
        int i = 0;
        for (SfaVisitclientRelRespVo data : sfaVisitclientRelRespVos) {
            SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.buildSfaVisitPlanInfoEntity(context, data);
            sfaVisitPlanInfoEntity.setVisitSort(i);
            visitPlanInfoEntities.add(sfaVisitPlanInfoEntity);
            ++i;
        }
        return visitPlanInfoEntities;
    }

    protected SfaVisitPlanInfoEntity buildSfaVisitPlanInfoEntity(SfaVisitPlanExecuteContext context, SfaVisitclientRelRespVo data) {
        SfaVisitPlanEntity sfaVisitPlanEntity = context.getCurrentPlanEntity();
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanEntity), SfaVisitPlanInfoEntity.class);
        sfaVisitPlanInfoEntity.setVisitType(sfaVisitPlanEntity.getPlanType());
        sfaVisitPlanInfoEntity.setVisitTypeName((String)SfaVisitEnum.visitType.GETMAP.get(sfaVisitPlanEntity.getPlanType()));
        sfaVisitPlanInfoEntity.setClientType(data.getClientType());
        sfaVisitPlanInfoEntity.setClientTypeName((String)SfaVisitEnum.ClientType.GETMAP.get(sfaVisitPlanInfoEntity.getClientType()));
        sfaVisitPlanInfoEntity.setClientCode(data.getClientCode());
        sfaVisitPlanInfoEntity.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
        sfaVisitPlanInfoEntity.setVisitStatusName(SfaVisitEnum.visitStatus.V1.getDesc());
        sfaVisitPlanInfoEntity.setVisitDate(context.getVisitDate().format(CrmDateUtils.yyyyMMdd));
        sfaVisitPlanInfoEntity.setVisitDateOfYearMonth(context.getVisitDate().format(CrmDateUtils.yyyyMM));
        sfaVisitPlanInfoEntity.setVisitDateOfYear(context.getVisitDate().format(CrmDateUtils.yyyy));
        sfaVisitPlanInfoEntity.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        sfaVisitPlanInfoEntity.setVisitBigTypeName(SfaVisitEnum.VisitBigType.VISIT.getDesc());
        sfaVisitPlanInfoEntity.setId(UUIDGenerator.generate());
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)sfaVisitPlanInfoEntity);
        return sfaVisitPlanInfoEntity;
    }

    protected SfaVisitGroupRespVo loadSfaVisitGroupRespVo(SfaVisitPlanExecuteContext context) {
        final SfaVisitPlanRangeEntity sfaVisitPlanRangeEntity = this.getLine(context);
        if (null == sfaVisitPlanRangeEntity) {
            return null;
        }
        SfaVisitGroupReqVo groupReqVo = new SfaVisitGroupReqVo(){
            {
                this.setId(sfaVisitPlanRangeEntity.getVisitGroupId());
            }
        };
        SfaVisitGroupRespVo sfaVisitGroupRespVo = this.iSfaVisitGroupService.query(groupReqVo);
        this.visitPlanInfoHelper.loadUserDataForVisitGroup(sfaVisitGroupRespVo);
        return sfaVisitGroupRespVo;
    }

    protected SfaVisitPlanRangeEntity getLine(SfaVisitPlanExecuteContext context) {
        LocalDate visitDate = context.getVisitDate();
        SfaVisitPlanEntity sfaVisitPlanEntity = context.getCurrentPlanEntity();
        Map<String, List<SfaVisitPlanRangeEntity>> planCodeMapPlanRange = context.getPlanCodeMapPlanRange();
        List<SfaVisitPlanRangeEntity> planRangeEntities = planCodeMapPlanRange.get(sfaVisitPlanEntity.getVisitPlanCode());
        if (CollectionUtils.isEmpty(planRangeEntities)) {
            return null;
        }
        Integer num = this.notWeekNum(LocalDate.parse(sfaVisitPlanEntity.getVisitStartDate()), visitDate, sfaVisitPlanEntity.getNotWeekSet());
        LocalDate startDate = context.getVisitStartDate();
        long days = visitDate.toEpochDay() - startDate.toEpochDay() - (long)num.intValue();
        long lineNum = 0L;
        int size = planRangeEntities.size();
        if (size > 1) {
            lineNum = days % (long)size;
        }
        return planRangeEntities.get((int)lineNum);
    }

    private Integer notWeekNum(LocalDate startDate, LocalDate visitEndDate, String week) {
        long days = visitEndDate.toEpochDay() - startDate.toEpochDay() + 1L;
        Integer num = 0;
        int i = 0;
        while ((long)i < days) {
            LocalDate visitDate = startDate.plusDays(i);
            if (StringUtils.isNotEmpty((String)week) && week.contains(String.valueOf(visitDate.getDayOfWeek().getValue()))) {
                Integer n = num;
                Integer n2 = num = Integer.valueOf(num + 1);
            }
            ++i;
        }
        return num;
    }
}

