/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepStoreCheckReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaAttachmentRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepStoreCheckRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.visitstep.mapper.SfaVisitStepStoreCheckMapper;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEntity;
import com.biz.crm.visitstep.repositories.SfaVisitStepStoreCheckEsDataRepositories;
import com.biz.crm.visitstep.req.GetStoreCheckPageReq;
import com.biz.crm.visitstep.req.GetStoreCheckReq;
import com.biz.crm.visitstep.resp.SfaVisitStepStoreCheckTableRespVo;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SfaVisitStepStoreCheckServiceEsImpl {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepStoreCheckServiceEsImpl.class);
    @Resource
    private SfaVisitStepStoreCheckEsDataRepositories sfaVisitStepStoreCheckEsDataRepositories;
    @Resource
    private SfaVisitStepStoreCheckMapper sfaVisitStepStoreCheckMapper;

    public PageResult<SfaVisitStepStoreCheckRespVo> getWorkbenchStoreCheckPage(GetStoreCheckPageReq req) {
        Page page = PageUtil.buildPage((Integer)req.getPageNum(), (Integer)req.getPageSize());
        SfaVisitStepStoreCheckReqVo reqVo = (SfaVisitStepStoreCheckReqVo)CrmBeanUtil.copy((Object)((Object)req), SfaVisitStepStoreCheckReqVo.class);
        List<SfaVisitStepStoreCheckRespVo> list = this.sfaVisitStepStoreCheckMapper.findList((Page<SfaVisitStepStoreCheckRespVo>)page, reqVo);
        return PageResult.builder().data(CrmBeanUtil.copyList(list, SfaVisitStepStoreCheckRespVo.class)).count(Long.valueOf(page.getTotal())).build();
    }

    @EsDataPermission(userName="userName.keyword", position="posCode.keyword", org="orgCode.keyword", customer="clientCode.keyword")
    public PageResult<SfaVisitStepStoreCheckTableRespVo> findStoreCheckReportEsList(GetStoreCheckReq req) {
        if (StringUtils.isBlank((CharSequence)req.getStepCode())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6b65\u9aa4\u7f16\u7801");
        }
        Page page = PageUtil.buildPage((Integer)req.getPageNum(), (Integer)req.getPageSize());
        SfaVisitStepStoreCheckReqVo reqVo = (SfaVisitStepStoreCheckReqVo)CrmBeanUtil.copy((Object)((Object)req), SfaVisitStepStoreCheckReqVo.class);
        reqVo.setCheckTypeDesc(req.getClientTypeName());
        List<SfaVisitStepStoreCheckRespVo> list = this.sfaVisitStepStoreCheckMapper.findList((Page<SfaVisitStepStoreCheckRespVo>)page, reqVo);
        return PageResult.builder().data(CrmBeanUtil.copyList(list, SfaVisitStepStoreCheckTableRespVo.class)).count(Long.valueOf(page.getTotal())).build();
    }

    public SfaVisitStepStoreCheckRespVo findStoreCheckReportDetailEs(String id) {
        SfaVisitStepStoreCheckEntity entity = (SfaVisitStepStoreCheckEntity)this.sfaVisitStepStoreCheckMapper.selectById((Serializable)((Object)id));
        if (ObjectUtils.isEmpty((Object)entity)) {
            return new SfaVisitStepStoreCheckRespVo();
        }
        SfaVisitStepStoreCheckRespVo respVo = (SfaVisitStepStoreCheckRespVo)CrmBeanUtil.copy((Object)entity, SfaVisitStepStoreCheckRespVo.class);
        respVo.setRegularShelfDisplayList(CrmBeanUtil.copyList(SfaAttachmentUtil.getList(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY.getVal(), respVo.getId()), SfaAttachmentRespVo.class));
        respVo.setMaterialDisplayList(CrmBeanUtil.copyList(SfaAttachmentUtil.getList(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY.getVal(), respVo.getId()), SfaAttachmentRespVo.class));
        respVo.setPriceList(CrmBeanUtil.copyList(SfaAttachmentUtil.getList(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE.getVal(), respVo.getId()), SfaAttachmentRespVo.class));
        return respVo;
    }
}

