/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstepbase;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.LocationUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisitBaseCheck {
    private static final Logger log = LoggerFactory.getLogger(VisitBaseCheck.class);

    public static void checkBaseData(VisitBaseVo vo) {
        AssertUtils.isNotEmpty((String)vo.getRedisHashKey(), (String)"redisHashKey\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)vo.getFormId(), (String)"\u8868\u5355id\u4e3a\u7a7a");
        if (vo.getStepExecuteData() == null) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static void checkVisitStepDistance(SfaVisitPlanInfoEntity entity, SfaVisitStepFromRespVo stepFromVo, String longitude, String latitude) {
        if (entity != null && entity.getLatitude() != null && entity.getLatitude() != null && stepFromVo != null && stepFromVo.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue()) && StringUtils.isNotEmpty((String)stepFromVo.getDistance())) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)longitude)) {
                throw new BusinessException("\u7ecf\u5ea6\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)latitude)) {
                throw new BusinessException("\u7eac\u5ea6\u4e3a\u7a7a");
            }
            BigDecimal distance = new BigDecimal(stepFromVo.getDistance()).setScale(2, 5);
            log.info("\u5f53\u524d\u6b65\u9aa4\u914d\u7f6e\u7684\u8ddd\u79bb:{}", (Object)distance);
            log.info("\u5f53\u524d\u4f4d\u7f6e\u7684\u7ecf\u5ea6:{},\u7eac\u5ea6:{},\u62dc\u8bbf\u5ba2\u6237\u7684\u7ecf\u5ea6:{},\u7eac\u5ea6:{}", new Object[]{longitude, latitude, entity.getLongitude(), entity.getLatitude()});
            double data = LocationUtils.getDistance(new BigDecimal(longitude), new BigDecimal(latitude), entity.getLongitude(), entity.getLatitude());
            BigDecimal nowDistance = new BigDecimal(data).setScale(2, 5);
            log.info("\u5f53\u524d\u4f4d\u7f6e\u8ddd\u79bb\u62dc\u8bbf\u5ba2\u6237\u7684\u8ddd\u79bb:{}", (Object)nowDistance);
            if (distance.compareTo(nowDistance) == -1) {
                throw new BusinessException("\u60a8\u672a\u5728\u5ba2\u6237\u8ddd\u79bb" + distance + "M\u5185\uff0c\u8bf7\u524d\u5f80\u5ba2\u6237\u5730\u5740\u8fdb\u884c\u64cd\u4f5c\uff01");
            }
        }
    }
}

