/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.collection.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.collection.controller.resp.BaseVisitStepResp;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.collection.mapper.SfaVisitRoleConfigMapper;
import com.biz.crm.collection.mapper.SfaVisitRoleDirectoryMapper;
import com.biz.crm.collection.model.SfaVisitRoleConfigEntity;
import com.biz.crm.collection.model.SfaVisitRoleDirectoryEntity;
import com.biz.crm.collection.service.ISfaVisitRoleConfigService;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaVisitRoleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.eunm.sfa.VisitStepFromEnum;
import com.biz.crm.mdm.role.MdmRoleFeign;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.nebular.mdm.role.req.MdmUserRoleReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.nebular.sfa.collection.req.FindVisitDetailReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleDirectoryReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitRoleDirectoryServiceExpandImpl"})
@Transactional
public class SfaVisitRoleDirectoryServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitRoleDirectoryMapper, SfaVisitRoleDirectoryEntity>
implements ISfaVisitRoleDirectoryService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitRoleDirectoryServiceImpl.class);
    @Resource
    private SfaVisitRoleDirectoryMapper sfaVisitRoleDirectoryMapper;
    @Resource
    private MdmRoleFeign mdmRoleFeign;
    @Resource
    private RedisService redisService;
    @Autowired
    private ISfaVisitRoleConfigService sfaVisitRoleConfigService;
    @Resource
    private SfaVisitRoleConfigMapper sfaVisitRoleConfigMapper;

    @Override
    public PageResult<SfaVisitRoleDirectoryRespVo> findList(SfaVisitRoleDirectoryReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitRoleDirectoryRespVo> list = this.sfaVisitRoleDirectoryMapper.findList((Page<SfaVisitRoleDirectoryRespVo>)page, reqVo);
        list.forEach(data -> data.setDoNotDesc(SfaVisitRoleEnum.getSfaVisitRole(data.getDoNot()).getDesc()));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<SfaVisitRoleDirectoryRespVo> findRoleDirectoryList(SfaVisitRoleConfigReqVo reqVo) {
        List<Object> sfaVisitRoleDirectoryRespVos = new ArrayList<SfaVisitRoleDirectoryRespVo>();
        if (!StringUtils.isNotEmpty((String)reqVo.getVisitUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            reqVo.setVisitUserName(userRedis.getUsername());
            reqVo.setVisitPosCode(userRedis.getPoscode());
        }
        this.checkFindRoleConfigList(reqVo);
        List roleList = (List)ApiResultUtil.objResult((Result)this.mdmRoleFeign.getRoleByPositionCode(reqVo.getVisitPosCode()), (boolean)true);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)roleList)) {
            reqVo.setRoleCodeList(roleList);
            List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVoList = this.sfaVisitRoleDirectoryMapper.findRoleDirectoryListByRoleList(reqVo.getVisitType(), reqVo.getSfacusType(), roleList);
            if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitRoleDirectoryRespVoList)) {
                Map<String, List<SfaVisitRoleDirectoryRespVo>> resultMap = sfaVisitRoleDirectoryRespVoList.stream().collect(Collectors.groupingBy(SfaVisitRoleDirectoryRespVo::getDirectoryCode));
                for (Map.Entry<String, List<SfaVisitRoleDirectoryRespVo>> map : resultMap.entrySet()) {
                    SfaVisitRoleDirectoryRespVo data = map.getValue().get(0);
                    sfaVisitRoleDirectoryRespVos.add(data);
                }
                sfaVisitRoleDirectoryRespVos = sfaVisitRoleDirectoryRespVos.stream().sorted(Comparator.comparing(SfaVisitRoleDirectoryRespVo::getSort)).collect(Collectors.toList());
            }
        }
        return sfaVisitRoleDirectoryRespVos;
    }

    private Map<String, SfaVisitRoleDirectoryRespVo> findRoleDirectoryMap(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitEnum.sfaVisitType sfaVisitType2) {
        List<String> roleList = this.getPositionRoleList(sfaVisitPlanInfoEntity.getVisitUserName(), sfaVisitPlanInfoEntity.getVisitPosCode());
        if (org.springframework.util.CollectionUtils.isEmpty(roleList)) {
            return Maps.newHashMap();
        }
        List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVoList = this.sfaVisitRoleDirectoryMapper.findRoleDirectoryListByRoleList(sfaVisitType2.getVal(), sfaVisitPlanInfoEntity.getClientType(), roleList);
        Map<String, SfaVisitRoleDirectoryRespVo> resultMap = sfaVisitRoleDirectoryRespVoList.stream().collect(Collectors.toMap(SfaVisitRoleDirectoryRespVo::getDirectoryCode, v -> v, (t, t2) -> t2));
        return resultMap;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, VisitStepResp> findRoleVisitStepMap(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(sfaVisitPlanInfoEntity.getRedisHashKey());
        return this.findRoleVisitStepMap(visitRedisHashKey, sfaVisitPlanInfoEntity.getClientSubclass());
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, VisitStepResp> findRoleVisitStepMap(SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey, String clientSubclass) {
        String visitBigType = visitRedisHashKey.getVisitBigType();
        String visitPosCode = visitRedisHashKey.getVisitPosCode();
        String clientType = visitRedisHashKey.getClientType();
        List<String> roleList = this.getPositionRoleList(visitRedisHashKey.getVisitUserName(), visitPosCode);
        if (org.springframework.util.CollectionUtils.isEmpty(roleList)) {
            return Maps.newHashMap();
        }
        ArrayList clientTypes = null;
        ArrayList clientSubclassList = null;
        if (!SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal().equals(visitBigType)) {
            clientTypes = Lists.newArrayList((Object[])new String[]{clientType});
            String configRange = ParamUtil.getParameterValue((String)"sfa_visit_step_config_client_subclass_range");
            clientSubclassList = YesNoEnum.yesNoEnum.NO.getValue().equals(configRange) ? null : Lists.newArrayList((Object[])new String[]{clientSubclass});
        }
        List<VisitStepResp> visitSteps = this.sfaVisitRoleDirectoryMapper.findRoleVisitSteps(visitBigType, clientTypes, roleList, clientSubclassList);
        LocalDateTime now = LocalDateTime.now();
        Map<String, VisitStepResp> resultMap = visitSteps.stream().filter(v -> !VisitStepFromEnum.timeType.DIY_TIME.getValue().equals(v.getTimeType()) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)v.getStartTime()) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)v.getEndTime()) || now.compareTo(LocalDateTime.parse(v.getStartTime() + " " + "00:00:00", CrmDateUtils.yyyyMMddHHmmss)) >= 0 && now.compareTo(LocalDateTime.parse(v.getEndTime() + " " + "23:59:59", CrmDateUtils.yyyyMMddHHmmss)) <= 0).collect(Collectors.toMap(BaseVisitStepResp::getStepCode, v -> {
            v.setIsSuccess(SfaVisitEnum.isSuccess.NOT_SUCCESS.getVal());
            v.setIsSuccessDesc(SfaVisitEnum.isSuccess.NOT_SUCCESS.getDesc());
            YesNoEnum.yesNoEnum yesNoEnum2 = YesNoEnum.yesNoEnum.getEnum((String)v.getDoNot());
            if (null != yesNoEnum2) {
                v.setDoNotDesc(yesNoEnum2.getDes());
            }
            return v;
        }, (t, t2) -> {
            if (YesNoEnum.yesNoEnum.yes.getValue().equals(t.getDoNot())) {
                return t;
            }
            return t2;
        }));
        return resultMap;
    }

    @Override
    @Transactional(readOnly=true)
    public void buildSfaVisitPlanInfoFormId(SfaVisitResp.SfaVisitPlanInfoResp visitPlanInfo, String visitPosCode) {
        ArrayList clientTypes = Lists.newArrayList((Object[])new String[]{visitPlanInfo.getClientType()});
        ArrayList clientSubclassList = Lists.newArrayList((Object[])new String[]{visitPlanInfo.getClientSubclass()});
        String visitBigType = visitPlanInfo.getVisitBigType();
        Map<String, Map<String, VisitStepResp>> stepRespMap = this.findRoleVisitStepMapForClientTypes(visitPlanInfo.getVisitUserName(), visitPosCode, clientTypes, visitBigType, clientSubclassList);
        visitPlanInfo.buildFormId(stepRespMap);
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Map<String, VisitStepResp>> findRoleVisitStepMapForClientTypes(String visitUserName, String visitPosCode, List<String> clientTypes, String visitBigType, List<String> clientSubclassList) {
        List<String> roleList = this.getPositionRoleList(visitUserName, visitPosCode);
        if (org.springframework.util.CollectionUtils.isEmpty(roleList)) {
            return Maps.newHashMap();
        }
        if (SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal().equals(visitBigType)) {
            clientTypes = null;
            clientSubclassList = null;
        }
        String configRange = ParamUtil.getParameterValue((String)"sfa_visit_step_config_client_subclass_range");
        if (YesNoEnum.yesNoEnum.NO.getValue().equals(configRange)) {
            clientSubclassList = null;
        }
        List<VisitStepResp> visitSteps = this.sfaVisitRoleDirectoryMapper.findRoleVisitSteps(visitBigType, clientTypes, roleList, clientSubclassList);
        HashMap clientTypeMapResult = Maps.newHashMap();
        Map<String, List<VisitStepResp>> clientTypeMap = visitSteps.stream().collect(Collectors.groupingBy(v -> {
            if (SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal().equals(visitBigType)) {
                return v.getVisitType() + SfaVisitEnum.ClientType.TERMINAL.getVal();
            }
            return v.getVisitType() + v.getClientType();
        }));
        for (Map.Entry<String, List<VisitStepResp>> entry : clientTypeMap.entrySet()) {
            Map<String, VisitStepResp> resultMap = entry.getValue().stream().collect(Collectors.toMap(BaseVisitStepResp::getStepCode, v -> v, (t, t2) -> t2));
            clientTypeMapResult.put(entry.getKey(), resultMap);
        }
        return clientTypeMapResult;
    }

    protected List<String> getPositionRoleList(String visitUserName, String visitPosCode) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)visitPosCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u804c\u4f4d\u7f16\u7801\uff01");
        }
        MdmUserRoleReqVo mdmUserRoleReqVo = new MdmUserRoleReqVo();
        mdmUserRoleReqVo.setUserName(visitUserName);
        mdmUserRoleReqVo.setPositionCode(visitPosCode);
        List roleList = (List)ApiResultUtil.objResult((Result)this.mdmRoleFeign.obtainUserRoleList(mdmUserRoleReqVo), (boolean)true);
        if (null == roleList) {
            throw new BusinessException("\u67e5\u8be2\u7528\u6237\u89d2\u8272\u5931\u8d25\uff0c\u4e3b\u6570\u636e\u670d\u52a1\u4e0d\u53ef\u7528\uff01");
        }
        return roleList.stream().map(MdmRoleRespVo::getRoleCode).collect(Collectors.toList());
    }

    @Override
    @Transactional(readOnly=true)
    public List<SfaVisitRoleDirectoryRespVo> findVisitRoleDirectoryList(String redisHashKey, String visitBigType) {
        AssertUtils.isNotEmpty((String)redisHashKey, (String)"\u62dc\u8bbfredisHashKey\u4e3a\u7a7a");
        String dateNow = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)this.redisService.hmget(SfaVisitPlanInfoEntity.getInstance().redisHashCurrent(dateNow, visitBigType).toString(), (Object)redisHashKey);
        if (null == sfaVisitPlanInfoEntity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u8ba1\u5212\u4fe1\u606f\uff01");
        }
        UserRedis userRedis = UserUtils.getUser();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)sfaVisitPlanInfoEntity.getVisitPosCode(), (CharSequence)userRedis.getPoscode())) {
            throw new BusinessException("\u4f60\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\u6216\u5207\u6362\u804c\u4f4d\u518d\u5c1d\u8bd5\uff01");
        }
        Map<String, SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos = this.findRoleDirectoryMap(sfaVisitPlanInfoEntity, SfaVisitEnum.sfaVisitType.VISIT);
        sfaVisitRoleDirectoryRespVos.remove(SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal());
        sfaVisitRoleDirectoryRespVos.remove(SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal());
        this.buildStepInfo(sfaVisitRoleDirectoryRespVos, redisHashKey);
        List<SfaVisitRoleDirectoryRespVo> dataList = sfaVisitRoleDirectoryRespVos.values().stream().sorted(Comparator.comparing(SfaVisitRoleDirectoryRespVo::getSort)).collect(Collectors.toList());
        return dataList;
    }

    @Override
    @Transactional(readOnly=true)
    public List<VisitStepResp> findVisitRoleDirectoryList(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity) {
        Map<String, VisitStepResp> roleVisitStepMap = this.findRoleVisitStepMap(sfaVisitPlanInfoEntity);
        List<VisitStepResp> dataList = roleVisitStepMap.values().stream().filter(v -> !SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal().equals(v.getPageCode()) && !SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal().equals(v.getPageCode())).sorted(Comparator.comparing(VisitStepResp::getSort)).collect(Collectors.toList());
        return dataList;
    }

    @Override
    @Deprecated
    @CrmAPIDiscard
    public List<SfaVisitRoleDirectoryRespVo> findVisitDetail(FindVisitDetailReqVo findVisitDetailReqVo) {
        SfaVisitRoleConfigReqVo reqVo = (SfaVisitRoleConfigReqVo)CrmBeanUtil.copy((Object)findVisitDetailReqVo, SfaVisitRoleConfigReqVo.class);
        AssertUtils.isNotEmpty((String)reqVo.getVisitId(), (String)"\u62dc\u8bbfid\u4e3a\u7a7a");
        String redisHash = null;
        AssertUtils.isNotEmpty(redisHash, (String)"\u62dc\u8bbfredisHash\u4e3a\u7a7a");
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)((Object)this.redisService.hmget(redisHash));
        UserRedis userRedis = UserUtils.getUser();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)sfaVisitPlanInfoEntity.getVisitPosCode(), (CharSequence)userRedis.getPoscode())) {
            throw new BusinessException("\u4f60\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\u6216\u5207\u6362\u804c\u4f4d\u518d\u5c1d\u8bd5\uff01");
        }
        Map<String, SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos = this.findRoleDirectoryMap(sfaVisitPlanInfoEntity, SfaVisitEnum.sfaVisitType.VISIT);
        this.buildStepInfo(sfaVisitRoleDirectoryRespVos, reqVo.getVisitId());
        List<SfaVisitRoleDirectoryRespVo> dataList = sfaVisitRoleDirectoryRespVos.values().stream().sorted(Comparator.comparing(SfaVisitRoleDirectoryRespVo::getSort)).collect(Collectors.toList());
        return dataList;
    }

    private void buildStepInfo(Map<String, SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos, String redisHashKey) {
        sfaVisitRoleDirectoryRespVos.forEach((directoryCode, data) -> {
            data.setIsSuccess(SfaVisitEnum.isSuccess.NOT_SUCCESS.getVal());
            data.setIsSuccessDesc(SfaVisitEnum.isSuccess.NOT_SUCCESS.getDesc());
            YesNoEnum.yesNoEnum yesNoEnum2 = YesNoEnum.yesNoEnum.getEnum((String)data.getDoNot());
            if (null != yesNoEnum2) {
                data.setDoNotDesc(yesNoEnum2.getDes());
            }
        });
    }

    private void assembleVisitStep(List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryList, String visitId, String yesNo) {
    }

    private void checkFindRoleConfigList(SfaVisitRoleConfigReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u4eba\u5458\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getSfacusType(), (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitType(), (String)"\u62dc\u8bbf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    public SfaVisitRoleDirectoryRespVo query(SfaVisitRoleDirectoryReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitRoleDirectoryReqVo reqVo) {
        SfaVisitRoleDirectoryEntity entity = (SfaVisitRoleDirectoryEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitRoleDirectoryEntity.class));
        this.save((Object)entity);
    }

    @Override
    public void update(SfaVisitRoleDirectoryReqVo reqVo) {
        SfaVisitRoleDirectoryEntity entity = (SfaVisitRoleDirectoryEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaVisitRoleDirectoryEntities = this.sfaVisitRoleDirectoryMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitRoleDirectoryEntities)) {
            sfaVisitRoleDirectoryEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitRoleDirectoryEntities);
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaVisitRoleDirectoryEntities = this.sfaVisitRoleDirectoryMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitRoleDirectoryEntities)) {
            sfaVisitRoleDirectoryEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitRoleDirectoryEntities);
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaVisitRoleDirectoryEntities = this.sfaVisitRoleDirectoryMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitRoleDirectoryEntities)) {
            sfaVisitRoleDirectoryEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitRoleDirectoryEntities);
    }

    @Override
    public String findRoleStepIsOffLine(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity) {
        List roleConfigEntities;
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(sfaVisitPlanInfoEntity.getRedisHashKey());
        List<String> roleList = this.getPositionRoleList(visitRedisHashKey.getVisitUserName(), visitRedisHashKey.getVisitPosCode());
        String visitBigType = visitRedisHashKey.getVisitBigType();
        ArrayList clientSubclassList = null;
        if (!SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal().equals(visitBigType)) {
            String configRange = ParamUtil.getParameterValue((String)"sfa_visit_step_config_client_subclass_range");
            clientSubclassList = YesNoEnum.yesNoEnum.NO.getValue().equals(configRange) ? null : Lists.newArrayList((Object[])new String[]{sfaVisitPlanInfoEntity.getClientSubclass()});
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(roleConfigEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitRoleConfigService.lambdaQuery().in(SfaVisitRoleConfigEntity::getRoleCode, roleList)).eq(SfaVisitRoleConfigEntity::getVisitType, (Object)visitRedisHashKey.getVisitBigType())).eq(SfaVisitRoleConfigEntity::getSfacusType, (Object)visitRedisHashKey.getClientType())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(CollectionUtil.listNotEmptyNotSizeZero((List)clientSubclassList), SfaVisitRoleConfigEntity::getClientSubclass, (Collection)clientSubclassList)).select(new SFunction[]{SfaVisitRoleConfigEntity::getIsOffLine}).list()))) {
            List isOffLineList = roleConfigEntities.stream().filter(data -> YesNoEnum.yesNoEnum.YES.getValue().equals(data.getIsOffLine())).map(SfaVisitRoleConfigEntity::getIsOffLine).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(isOffLineList)) {
                return YesNoEnum.yesNoEnum.YES.getValue();
            }
            return YesNoEnum.yesNoEnum.NO.getValue();
        }
        return YesNoEnum.yesNoEnum.NO.getValue();
    }
}

