/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.helpdefense.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.helpdefense.mapper.SfaVisitHelpDefenseMapper;
import com.biz.crm.helpdefense.model.SfaHelpDefenseDetailEntity;
import com.biz.crm.helpdefense.model.SfaHelpDefenseEntity;
import com.biz.crm.helpdefense.model.SfaVisitHelpDefenseDetailEntity;
import com.biz.crm.helpdefense.model.SfaVisitHelpDefenseEntity;
import com.biz.crm.helpdefense.service.ISfaHelpDefenseDetailService;
import com.biz.crm.helpdefense.service.ISfaHelpDefenseService;
import com.biz.crm.helpdefense.service.ISfaVisitHelpDefenseDetailService;
import com.biz.crm.helpdefense.service.ISfaVisitHelpDefenseService;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.nebular.sfa.helpdefense.req.FindHelpDefenseScheduleReqVo;
import com.biz.crm.nebular.sfa.helpdefense.req.FindVisitHelpDefenseListReqVo;
import com.biz.crm.nebular.sfa.helpdefense.req.HelpDefenseInStoreReqVo;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaVisitHelpDefenseDetailReqVo;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaVisitHelpDefenseReqVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.FindHelpDefenseScheduleRespVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaVisitHelpDefenseDetailRespVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaVisitHelpDefenseRespVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.step.HelpDefenseStepCheckInfoVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.step.HelpDefenseStepInOutStoreInfoVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.step.HelpDefenseStepInfoVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.step.LoadHelpDefenseExecutionInfoRespVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitHelpDefenseServiceExpandImpl"})
@Transactional
public class SfaVisitHelpDefenseServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitHelpDefenseMapper, SfaVisitHelpDefenseEntity>
implements ISfaVisitHelpDefenseService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitHelpDefenseServiceImpl.class);
    @Resource
    private SfaVisitHelpDefenseMapper sfaVisitHelpDefenseMapper;
    @Autowired
    private ISfaHelpDefenseDetailService sfaHelpDefenseDetailService;
    @Autowired
    private ISfaVisitPictureService sfaVisitPictureService;
    @Autowired
    private ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;
    @Autowired
    private ISfaHelpDefenseService sfaHelpDefenseService;
    @Autowired
    private ISfaVisitHelpDefenseDetailService sfaVisitHelpDefenseDetailService;

    @Override
    public PageResult<SfaVisitHelpDefenseRespVo> findList(SfaVisitHelpDefenseReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitHelpDefenseRespVo> list = this.sfaVisitHelpDefenseMapper.findList((Page<SfaVisitHelpDefenseRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaVisitHelpDefenseRespVo> findVisitHelpDefenseReport(SfaVisitHelpDefenseReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitHelpDefenseRespVo> list = this.sfaVisitHelpDefenseMapper.findReportList((Page<SfaVisitHelpDefenseRespVo>)page, reqVo);
        list.forEach(data -> {
            List sfaVisitHelpDefenseDetailEntities = ((LambdaQueryChainWrapper)this.sfaVisitHelpDefenseDetailService.lambdaQuery().eq(SfaVisitHelpDefenseDetailEntity::getVisitHelpDefenseId, (Object)data.getId())).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaVisitHelpDefenseDetailEntities)) {
                Long num = sfaVisitHelpDefenseDetailEntities.stream().filter(da -> da.getIsQualified().equals(SfaVisitEnum.SfaVisitQualified.NOT_QUALIFIED.getVal())).count();
                BigDecimal qualifiedNum = new BigDecimal(num);
                BigDecimal total = new BigDecimal(sfaVisitHelpDefenseDetailEntities.size());
                qualifiedNum.divide(total, 2, 1);
                data.setQualifiedNum(qualifiedNum);
            } else {
                data.setQualifiedNum(BigDecimal.ZERO);
            }
            List sfaVisitPictureEntities = ((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)data.getId())).list();
            Map<String, List<SfaVisitPictureEntity>> picMap = sfaVisitPictureEntities.stream().collect(Collectors.groupingBy(SfaVisitPictureEntity::getPicType));
            ArrayList inStorePicList = new ArrayList();
            ArrayList outStorePicList = new ArrayList();
            for (Map.Entry<String, List<SfaVisitPictureEntity>> pic : picMap.entrySet()) {
                List<SfaVisitPictureEntity> picList = pic.getValue();
                if (pic.getKey().equals(SfaVisitEnum.visitPicType.DEALER_IN_STORE_PIC.getVal())) {
                    picList.forEach(p -> {
                        String picUrl = p.getPicUrl() + p.getPicPath();
                        inStorePicList.add(picUrl);
                    });
                    continue;
                }
                if (!pic.getKey().equals(SfaVisitEnum.visitPicType.DEALER_OUT_STORE_PIC.getVal())) continue;
                picList.forEach(p -> {
                    String picUrl = p.getPicUrl() + p.getPicPath();
                    outStorePicList.add(picUrl);
                });
            }
            data.setInStorePicList(inStorePicList);
            data.setOutStorePicList(outStorePicList);
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmDictMethod
    public SfaVisitHelpDefenseRespVo queryVisitHelpDefenseReportDetail(final String id) {
        SfaVisitHelpDefenseReqVo reqVo = new SfaVisitHelpDefenseReqVo(){
            {
                this.setPageNum(1);
                this.setPageSize(1);
                this.setId(id);
            }
        };
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitHelpDefenseRespVo> list = this.sfaVisitHelpDefenseMapper.findReportList((Page<SfaVisitHelpDefenseRespVo>)page, reqVo);
        if (!CollectionUtil.listNotEmptyNotSizeZero(list)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bbf\u62a5\u8868\u8be6\u7ec6\u4fe1\u606f");
        }
        SfaVisitHelpDefenseRespVo respVo = list.get(0);
        List sfaVisitHelpDefenseDetailEntities = ((LambdaQueryChainWrapper)this.sfaVisitHelpDefenseDetailService.lambdaQuery().eq(SfaVisitHelpDefenseDetailEntity::getVisitHelpDefenseId, (Object)respVo.getId())).list();
        List detailRespVos = CrmBeanUtil.copyList((List)sfaVisitHelpDefenseDetailEntities, SfaVisitHelpDefenseDetailRespVo.class);
        Long num = sfaVisitHelpDefenseDetailEntities.stream().filter(da -> da.getIsQualified().equals(SfaVisitEnum.SfaVisitQualified.NOT_QUALIFIED.getVal())).count();
        BigDecimal qualifiedNum = new BigDecimal(num);
        BigDecimal total = new BigDecimal(sfaVisitHelpDefenseDetailEntities.size());
        qualifiedNum.divide(total, 2, 1);
        respVo.setQualifiedNum(qualifiedNum);
        respVo.setSfaVisitHelpDefenseDetailList(detailRespVos);
        List sfaVisitPictureEntities = ((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)respVo.getId())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaVisitPictureEntities)) {
            Map<String, List<SfaVisitPictureEntity>> picMap = sfaVisitPictureEntities.stream().collect(Collectors.groupingBy(SfaVisitPictureEntity::getPicType));
            ArrayList inStorePicList = Lists.newArrayList();
            ArrayList outStorePicList = Lists.newArrayList();
            for (Map.Entry<String, List<SfaVisitPictureEntity>> pic : picMap.entrySet()) {
                if (pic.getKey().equals(SfaVisitEnum.visitPicType.DEALER_IN_STORE_PIC.getVal())) {
                    pic.getValue().forEach(p -> {
                        String url = p.getPicUrl() + p.getPicPath();
                        inStorePicList.add(url);
                    });
                    continue;
                }
                if (!pic.getKey().equals(SfaVisitEnum.visitPicType.DEALER_OUT_STORE_PIC.getVal())) continue;
                pic.getValue().forEach(p -> {
                    String url = p.getPicUrl() + p.getPicPath();
                    outStorePicList.add(url);
                });
            }
            respVo.setInStorePicList((List)inStorePicList);
            respVo.setOutStorePicList((List)outStorePicList);
        }
        return respVo;
    }

    @Override
    public PageResult<SfaVisitHelpDefenseRespVo> findVisitHelpDefenseList(FindVisitHelpDefenseListReqVo findVisitHelpDefenseListReqVo) {
        AssertUtils.isNotEmpty((String)findVisitHelpDefenseListReqVo.getDefenseDate(), (String)"\u534f\u8bbf\u65e5\u671f\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)findVisitHelpDefenseListReqVo.getLongitude(), (String)"\u7ecf\u5ea6\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)findVisitHelpDefenseListReqVo.getLatitude(), (String)"\u7eac\u5ea6\u4e3a\u7a7a");
        if (!StringUtils.isNotEmpty((String)findVisitHelpDefenseListReqVo.getUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            findVisitHelpDefenseListReqVo.setUserName(userRedis.getUsername());
            findVisitHelpDefenseListReqVo.setPosCode(userRedis.getPoscode());
        }
        SfaVisitHelpDefenseReqVo reqVo = (SfaVisitHelpDefenseReqVo)CrmBeanUtil.copy((Object)findVisitHelpDefenseListReqVo, SfaVisitHelpDefenseReqVo.class);
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        reqVo.setHelpDefenseStatus(SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getVal());
        List<SfaVisitHelpDefenseRespVo> sfaVisitHelpDefenseRespVos = this.sfaVisitHelpDefenseMapper.findVisitHelpDefenseList((Page<SfaVisitHelpDefenseRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitHelpDefenseRespVos)) {
            sfaVisitHelpDefenseRespVos.forEach(data -> {
                if (data.getDistance() != null) {
                    data.setDistance(data.getDistance().divide(new BigDecimal(1000)).setScale(2, 1));
                }
                if (StringUtils.isNotEmpty((String)reqVo.getUserName())) {
                    Map<String, String> buttons = this.getButtons(reqVo.getUserName(), data.getHelpDefenseStatus(), data.getDefenseDate());
                    data.setButtons(buttons);
                }
            });
        }
        return PageResult.builder().data(sfaVisitHelpDefenseRespVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public FindHelpDefenseScheduleRespVo findHelpDefenseSchedule(FindHelpDefenseScheduleReqVo findHelpDefenseScheduleVo) {
        SfaVisitHelpDefenseReqVo reqVo = (SfaVisitHelpDefenseReqVo)CrmBeanUtil.copy((Object)findHelpDefenseScheduleVo, SfaVisitHelpDefenseReqVo.class);
        FindHelpDefenseScheduleRespVo respVo = new FindHelpDefenseScheduleRespVo();
        AssertUtils.isNotEmpty((String)reqVo.getDefenseDate(), (String)"\u534f\u8bbf\u65e5\u671f\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((String)reqVo.getUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            reqVo.setUserName(userRedis.getUsername());
            reqVo.setPosCode(userRedis.getPoscode());
        }
        List<SfaVisitHelpDefenseRespVo> sfaVisitHelpDefenseRespVos = this.sfaVisitHelpDefenseMapper.findHelpDefenseSchedule(reqVo);
        respVo.setHelpDefenseTotal(Integer.valueOf(sfaVisitHelpDefenseRespVos.size()));
        Long num = sfaVisitHelpDefenseRespVos.stream().filter(data -> data.getHelpDefenseStatus().equals(SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getVal())).count();
        respVo.setHelpDefenseSuccess(Integer.valueOf(num.toString()));
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String helpDefenseInStore(HelpDefenseInStoreReqVo helpDefenseInStoreReqVo) {
        SfaHelpDefenseDetailEntity sfaHelpDefenseDetailEntity = this.checkInStore(helpDefenseInStoreReqVo);
        SfaHelpDefenseEntity sfaHelpDefenseEntity = (SfaHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)this.sfaHelpDefenseService.lambdaQuery().eq(BaseIdEntity::getId, (Object)sfaHelpDefenseDetailEntity.getHelpDefenseId())).one());
        if (null == sfaHelpDefenseEntity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bbf\u8ba1\u5212");
        }
        SfaVisitHelpDefenseEntity oldEntity = (SfaVisitHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitHelpDefenseEntity::getHelpDefenseDetailId, (Object)sfaHelpDefenseDetailEntity.getId())).one());
        SfaVisitHelpDefenseEntity entity = this.buildSfaVisitHelpDefenseEntity(helpDefenseInStoreReqVo, sfaHelpDefenseDetailEntity, sfaHelpDefenseEntity);
        if (null == oldEntity) {
            this.save((Object)entity);
        } else {
            this.sfaVisitPictureService.remove((Wrapper)Wrappers.lambdaUpdate(SfaVisitPictureEntity.class).eq(SfaVisitPictureEntity::getBusinessId, (Object)oldEntity.getId()));
            entity.setId(oldEntity.getId());
            this.updateById((Object)entity);
        }
        String id = entity.getId();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)helpDefenseInStoreReqVo.getHelpDefensePicList())) {
            List sfaVisitPictureEntities = CrmBeanUtil.copyList((List)helpDefenseInStoreReqVo.getHelpDefensePicList(), SfaVisitPictureEntity.class);
            sfaVisitPictureEntities.forEach(data -> {
                data.setBusinessId(id);
                data.setPicType(SfaVisitEnum.visitPicType.DEALER_IN_STORE_PIC.getVal());
            });
            this.sfaVisitPictureService.saveBatch(sfaVisitPictureEntities);
        }
        SfaHelpDefenseDetailEntity updateSfaHelpDefenseDetailEntity = new SfaHelpDefenseDetailEntity();
        updateSfaHelpDefenseDetailEntity.setId(sfaHelpDefenseDetailEntity.getId());
        updateSfaHelpDefenseDetailEntity.setHelpDefenseStatus(SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal());
        this.sfaHelpDefenseDetailService.updateById((Object)updateSfaHelpDefenseDetailEntity);
        return id;
    }

    private SfaVisitHelpDefenseEntity buildSfaVisitHelpDefenseEntity(HelpDefenseInStoreReqVo helpDefenseInStoreReqVo, SfaHelpDefenseDetailEntity sfaHelpDefenseDetailEntity, SfaHelpDefenseEntity sfaHelpDefenseEntity) {
        SfaVisitHelpDefenseEntity entity = new SfaVisitHelpDefenseEntity();
        entity.setId(null);
        UserRedis userRedis = UserUtils.getUser();
        entity.setUserName(userRedis.getUsername());
        entity.setRealName(userRedis.getRealname());
        entity.setOrgName(userRedis.getOrgname());
        entity.setOrgCode(userRedis.getOrgcode());
        entity.setPosCode(userRedis.getPoscode());
        entity.setPosName(userRedis.getPosname());
        entity.setInStore(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        entity.setInStoreAddress(helpDefenseInStoreReqVo.getInStoreAddress());
        entity.setInStoreLatitude(helpDefenseInStoreReqVo.getInStoreLatitude());
        entity.setInStoreLongitude(helpDefenseInStoreReqVo.getInStoreLongitude());
        entity.setRemarks(helpDefenseInStoreReqVo.getRemarks());
        entity.setClientId(sfaHelpDefenseDetailEntity.getClientId());
        entity.setClientType(sfaHelpDefenseDetailEntity.getClientType());
        entity.setClientCode(sfaHelpDefenseDetailEntity.getClientCode());
        entity.setClientAddress(sfaHelpDefenseDetailEntity.getClientAddress());
        entity.setClientName(sfaHelpDefenseDetailEntity.getClientName());
        entity.setClientPhone(sfaHelpDefenseDetailEntity.getClientPhone());
        entity.setDefenseDate(sfaHelpDefenseEntity.getHelpDefenseDate());
        entity.setHelpDefenseDetailId(sfaHelpDefenseDetailEntity.getId());
        entity.setHelpDefenseStatus(SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal());
        return entity;
    }

    @Override
    public List<SfaVisitRoleDirectoryRespVo> findHelpDefenseROleDirectory(String id) {
        final SfaHelpDefenseDetailEntity sfaHelpDefenseDetailEntity = (SfaHelpDefenseDetailEntity)((Object)((LambdaQueryChainWrapper)this.sfaHelpDefenseDetailService.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one());
        if (sfaHelpDefenseDetailEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bbf\u660e\u7ec6\u4fe1\u606f");
        }
        SfaVisitHelpDefenseEntity sfaVisitHelpDefenseEntity = (SfaVisitHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitHelpDefenseEntity::getHelpDefenseDetailId, (Object)sfaHelpDefenseDetailEntity.getId())).one());
        if (sfaVisitHelpDefenseEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bbf\u660e\u7ec6\u4fe1\u606f");
        }
        SfaVisitRoleConfigReqVo reqVo = new SfaVisitRoleConfigReqVo(){
            {
                this.setSfacusType(sfaHelpDefenseDetailEntity.getClientType());
                this.setVisitType(SfaVisitEnum.sfaVisitType.VISIT.getVal());
                this.setVisitPosCode(sfaHelpDefenseDetailEntity.getCoverHelpPosCode());
                this.setVisitUserName(sfaHelpDefenseDetailEntity.getCoverHelpUserName());
            }
        };
        List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos = this.sfaVisitRoleDirectoryService.findRoleDirectoryList(reqVo);
        List visitHelpDefenseDetailEntityList = ((LambdaQueryChainWrapper)this.sfaVisitHelpDefenseDetailService.lambdaQuery().eq(SfaVisitHelpDefenseDetailEntity::getVisitHelpDefenseId, (Object)sfaVisitHelpDefenseEntity.getId())).list();
        sfaVisitRoleDirectoryRespVos.forEach(data -> {
            data.setIsSuccess(YesNoEnum.YesNoCodeNumberEnum.NO.getCode().toString());
            data.setIsSuccessDesc(YesNoEnum.YesNoCodeNumberEnum.NO.getValue());
        });
        if (CollectionUtil.listNotEmptyNotSizeZero((List)visitHelpDefenseDetailEntityList)) {
            Map<String, String> roleMap = visitHelpDefenseDetailEntityList.stream().collect(Collectors.toMap(SfaVisitHelpDefenseDetailEntity::getDirectoryCode, SfaVisitHelpDefenseDetailEntity::getIsQualified));
            sfaVisitRoleDirectoryRespVos.forEach(data -> {
                if (roleMap.containsKey(data.getDirectoryCode())) {
                    data.setIsSuccessDesc((String)SfaVisitEnum.SfaVisitQualified.GETMAP.get(roleMap.get(data.getDirectoryCode())));
                    data.setIsSuccess((String)roleMap.get(data.getDirectoryCode()));
                }
            });
        }
        return sfaVisitRoleDirectoryRespVos;
    }

    @Override
    public LoadHelpDefenseExecutionInfoRespVo loadHelpDefenseExecutionInfo(String id) {
        SfaHelpDefenseDetailEntity sfaHelpDefenseDetailEntity = (SfaHelpDefenseDetailEntity)((Object)((LambdaQueryChainWrapper)this.sfaHelpDefenseDetailService.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one());
        if (sfaHelpDefenseDetailEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bbf\u660e\u7ec6\u4fe1\u606f");
        }
        SfaHelpDefenseEntity helpDefenseEntity = (SfaHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)this.sfaHelpDefenseService.lambdaQuery().eq(BaseIdEntity::getId, (Object)sfaHelpDefenseDetailEntity.getHelpDefenseId())).one());
        if (sfaHelpDefenseDetailEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bbf\u4fe1\u606f");
        }
        SfaVisitHelpDefenseEntity sfaVisitHelpDefenseEntity = (SfaVisitHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitHelpDefenseEntity::getHelpDefenseDetailId, (Object)sfaHelpDefenseDetailEntity.getId())).one());
        if (sfaVisitHelpDefenseEntity == null) {
            sfaVisitHelpDefenseEntity = new SfaVisitHelpDefenseEntity();
        }
        LoadHelpDefenseExecutionInfoRespVo executionInfoRespVo = (LoadHelpDefenseExecutionInfoRespVo)CrmBeanUtil.copy((Object)((Object)sfaHelpDefenseDetailEntity), LoadHelpDefenseExecutionInfoRespVo.class);
        executionInfoRespVo.setRealName(helpDefenseEntity.getHelpRealName());
        this.buildInOutStoreInfo(executionInfoRespVo, sfaVisitHelpDefenseEntity);
        executionInfoRespVo.setVisitInfo(this.buildVisitInfo(sfaHelpDefenseDetailEntity, sfaVisitHelpDefenseEntity));
        return executionInfoRespVo;
    }

    private LoadHelpDefenseExecutionInfoRespVo.VisitInfo buildVisitInfo(final SfaHelpDefenseDetailEntity sfaHelpDefenseDetailEntity, SfaVisitHelpDefenseEntity sfaVisitHelpDefenseEntity) {
        SfaVisitRoleConfigReqVo reqVo = new SfaVisitRoleConfigReqVo(){
            {
                this.setSfacusType(sfaHelpDefenseDetailEntity.getClientType());
                this.setVisitType(SfaVisitEnum.sfaVisitType.VISIT.getVal());
                this.setVisitPosCode(sfaHelpDefenseDetailEntity.getCoverHelpPosCode());
                this.setVisitUserName(sfaHelpDefenseDetailEntity.getCoverHelpUserName());
            }
        };
        List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos = this.sfaVisitRoleDirectoryService.findRoleDirectoryList(reqVo);
        List checkInfoVosTemp = CrmBeanUtil.copyList(sfaVisitRoleDirectoryRespVos, HelpDefenseStepCheckInfoVo.class);
        Map<Object, Object> helpDefenseDetailMap = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sfaVisitHelpDefenseEntity.getId()) ? ((LambdaQueryChainWrapper)this.sfaVisitHelpDefenseDetailService.lambdaQuery().eq(SfaVisitHelpDefenseDetailEntity::getVisitHelpDefenseId, (Object)sfaVisitHelpDefenseEntity.getId())).list().stream().collect(Collectors.toMap(SfaVisitHelpDefenseDetailEntity::getDirectoryCode, SfaVisitHelpDefenseDetailEntity::getIsQualified)) : Maps.newHashMap();
        checkInfoVosTemp.forEach(data -> {
            if (helpDefenseDetailMap.containsKey(data.getDirectoryCode())) {
                data.setIsQualified((String)helpDefenseDetailMap.get(data.getDirectoryCode()));
                data.setIsQualifiedDesc((String)SfaVisitEnum.SfaVisitQualified.GETMAP.get(helpDefenseDetailMap.get(data.getDirectoryCode())));
            }
        });
        LoadHelpDefenseExecutionInfoRespVo.VisitInfo visitInfo = new LoadHelpDefenseExecutionInfoRespVo.VisitInfo();
        List checkInfoVos = checkInfoVosTemp.stream().sorted(Comparator.comparing(HelpDefenseStepCheckInfoVo::getSort)).collect(Collectors.toList());
        visitInfo.setHelpDefenseStepInfoVos(checkInfoVos);
        visitInfo.setHelpDefenseSummary(sfaVisitHelpDefenseEntity.getHelpDefenseSummary());
        visitInfo.setKeyQuestions(sfaVisitHelpDefenseEntity.getKeyQuestions());
        return visitInfo;
    }

    private void buildInOutStoreInfo(LoadHelpDefenseExecutionInfoRespVo executionInfoRespVo, SfaVisitHelpDefenseEntity sfaVisitHelpDefenseEntity) {
        Map<String, List<SfaVisitPictureEntity>> picMap = this.loadVisitHelpDefensePic(sfaVisitHelpDefenseEntity);
        String in = SfaVisitEnum.visitPicType.DEALER_IN_STORE_PIC.getVal();
        String out = SfaVisitEnum.visitPicType.DEALER_OUT_STORE_PIC.getVal();
        HelpDefenseStepInOutStoreInfoVo inStoreInfoVo = new HelpDefenseStepInOutStoreInfoVo();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sfaVisitHelpDefenseEntity.getInStore())) {
            inStoreInfoVo.setAddress(sfaVisitHelpDefenseEntity.getInStoreAddress());
            inStoreInfoVo.setInOutDateTime(sfaVisitHelpDefenseEntity.getInStore());
            inStoreInfoVo.setLatitude(sfaVisitHelpDefenseEntity.getInStoreLatitude());
            inStoreInfoVo.setLongitude(sfaVisitHelpDefenseEntity.getInStoreLongitude());
        }
        ArrayList pictureRespVos = picMap.containsKey(in) ? CrmBeanUtil.copyList(picMap.get(in), SfaVisitPictureRespVo.class) : Lists.newArrayList();
        inStoreInfoVo.setPicList((List)pictureRespVos);
        executionInfoRespVo.setHelpDefenseStepInfoVoAsInStore((HelpDefenseStepInfoVo)inStoreInfoVo);
        HelpDefenseStepInOutStoreInfoVo outStoreInfoVo = new HelpDefenseStepInOutStoreInfoVo();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sfaVisitHelpDefenseEntity.getOutStore())) {
            outStoreInfoVo.setAddress(sfaVisitHelpDefenseEntity.getOutStoreAddress());
            outStoreInfoVo.setInOutDateTime(sfaVisitHelpDefenseEntity.getOutStore());
            outStoreInfoVo.setLatitude(sfaVisitHelpDefenseEntity.getOutStoreLatitude());
            outStoreInfoVo.setLongitude(sfaVisitHelpDefenseEntity.getOutStoreLongitude());
        }
        pictureRespVos = picMap.containsKey(in) ? CrmBeanUtil.copyList(picMap.get(out), SfaVisitPictureRespVo.class) : Lists.newArrayList();
        outStoreInfoVo.setPicList((List)pictureRespVos);
        executionInfoRespVo.setHelpDefenseStepInfoVoAsOutStore((HelpDefenseStepInfoVo)outStoreInfoVo);
    }

    private Map<String, List<SfaVisitPictureEntity>> loadVisitHelpDefensePic(SfaVisitHelpDefenseEntity sfaVisitHelpDefenseEntity) {
        Map<Object, Object> picMap;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sfaVisitHelpDefenseEntity.getId())) {
            String in = SfaVisitEnum.visitPicType.DEALER_IN_STORE_PIC.getVal();
            String out = SfaVisitEnum.visitPicType.DEALER_OUT_STORE_PIC.getVal();
            picMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)sfaVisitHelpDefenseEntity.getId())).in(SfaVisitPictureEntity::getPicType, (Collection)Lists.newArrayList((Object[])new String[]{in, out}))).list().stream().collect(Collectors.groupingBy(SfaVisitPictureEntity::getPicType));
        } else {
            picMap = Maps.newHashMap();
        }
        return picMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void helpDefenseOutStore(SfaVisitHelpDefenseReqVo reqVo) {
        SfaHelpDefenseDetailEntity sfaHelpDefenseDetailEntity = this.checkOutStore(reqVo);
        SfaVisitHelpDefenseEntity entity = (SfaVisitHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitHelpDefenseEntity::getHelpDefenseDetailId, (Object)sfaHelpDefenseDetailEntity.getId())).one());
        if (entity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bbf\u6267\u884c\u6570\u636e");
        }
        SfaVisitHelpDefenseEntity updateEntity = new SfaVisitHelpDefenseEntity();
        updateEntity.setId(entity.getId());
        updateEntity.setHelpDefenseStatus(SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getVal());
        updateEntity.setOutStore(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        updateEntity.setOutStoreAddress(reqVo.getOutStoreAddress());
        updateEntity.setOutStoreLatitude(reqVo.getOutStoreLatitude());
        updateEntity.setOutStoreLongitude(reqVo.getOutStoreLongitude());
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getHelpDefensePicList())) {
            List sfaVisitPictureEntities = CrmBeanUtil.copyList((List)reqVo.getHelpDefensePicList(), SfaVisitPictureEntity.class);
            sfaVisitPictureEntities.forEach(data -> {
                data.setBusinessId(entity.getId());
                data.setPicType(SfaVisitEnum.visitPicType.DEALER_OUT_STORE_PIC.getVal());
            });
            this.sfaVisitPictureService.saveBatch(sfaVisitPictureEntities);
        }
        this.updateById((Object)updateEntity);
        SfaHelpDefenseDetailEntity updateSfaHelpDefenseDetailEntity = new SfaHelpDefenseDetailEntity();
        updateSfaHelpDefenseDetailEntity.setId(sfaHelpDefenseDetailEntity.getId());
        updateSfaHelpDefenseDetailEntity.setHelpDefenseStatus(SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getVal());
        this.sfaHelpDefenseDetailService.updateById((Object)updateSfaHelpDefenseDetailEntity);
    }

    @Override
    @Transactional
    public void saveHelpDefenseDetail(SfaVisitHelpDefenseDetailReqVo reqVo) {
        this.checkHelpDefenseStep(reqVo);
        SfaHelpDefenseDetailEntity sfaHelpDefenseDetailEntity = (SfaHelpDefenseDetailEntity)((Object)((LambdaQueryChainWrapper)this.sfaHelpDefenseDetailService.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getId())).one());
        if (null == sfaHelpDefenseDetailEntity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bbf\u8ba1\u5212\u660e\u7ec6\u6570\u636e");
        }
        SfaVisitHelpDefenseEntity sfaVisitHelpDefenseEntity = (SfaVisitHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitHelpDefenseEntity::getHelpDefenseDetailId, (Object)sfaHelpDefenseDetailEntity.getId())).one());
        if (sfaVisitHelpDefenseEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u534f\u9632\u6267\u884c\u6570\u636e");
        }
        this.sfaVisitHelpDefenseDetailService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaVisitHelpDefenseDetailEntity.class).eq(SfaVisitHelpDefenseDetailEntity::getVisitHelpDefenseId, (Object)sfaVisitHelpDefenseEntity.getId())).eq(SfaVisitHelpDefenseDetailEntity::getDirectoryCode, (Object)reqVo.getDirectoryCode()));
        SfaVisitHelpDefenseDetailEntity sfaVisitHelpDefenseDetailEntity = (SfaVisitHelpDefenseDetailEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitHelpDefenseDetailEntity.class));
        sfaVisitHelpDefenseDetailEntity.setVisitHelpDefenseId(sfaVisitHelpDefenseEntity.getId());
        sfaVisitHelpDefenseDetailEntity.setId(null);
        this.sfaVisitHelpDefenseDetailService.save((Object)sfaVisitHelpDefenseDetailEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveHelpDefenseSummary(SfaVisitHelpDefenseReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getHelpDefenseSummary(), (String)"\u534f\u8bbf\u603b\u7ed3\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getKeyQuestions(), (String)"\u91cd\u5927\u95ee\u9898\u8bb0\u5f55\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u534f\u8bbf\u660e\u7ec6id\u4e3a\u7a7a");
        SfaHelpDefenseDetailEntity defenseDetailEntity = (SfaHelpDefenseDetailEntity)((Object)this.sfaHelpDefenseDetailService.getById((Serializable)((Object)reqVo.getId())));
        if (null == defenseDetailEntity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u7684\u534f\u8bbf\u660e\u7ec6\u6570\u636e");
        }
        SfaVisitHelpDefenseEntity sfaVisitHelpDefenseEntity = (SfaVisitHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitHelpDefenseEntity::getHelpDefenseDetailId, (Object)defenseDetailEntity.getId())).one());
        if (sfaVisitHelpDefenseEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bbf\u6267\u884c\u6570\u636e");
        }
        SfaVisitHelpDefenseEntity updateEntity = new SfaVisitHelpDefenseEntity();
        updateEntity.setId(sfaVisitHelpDefenseEntity.getId());
        updateEntity.setHelpDefenseSummary(reqVo.getHelpDefenseSummary());
        updateEntity.setKeyQuestions(reqVo.getKeyQuestions());
        this.updateById((Object)updateEntity);
    }

    @Override
    @CrmDictMethod
    public SfaVisitHelpDefenseRespVo queryHelpDefenseDetail(String id) {
        SfaHelpDefenseDetailEntity sfaHelpDefenseDetailEntity = (SfaHelpDefenseDetailEntity)((Object)((LambdaQueryChainWrapper)this.sfaHelpDefenseDetailService.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one());
        if (sfaHelpDefenseDetailEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bbf\u8ba1\u5212\u660e\u7ec6\u4fe1\u606f");
        }
        SfaVisitHelpDefenseEntity sfaVisitHelpDefenseEntity = (SfaVisitHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitHelpDefenseEntity::getHelpDefenseDetailId, (Object)sfaHelpDefenseDetailEntity.getId())).one());
        if (sfaVisitHelpDefenseEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bbf\u6267\u884c\u6570\u636e\u4fe1\u606f");
        }
        SfaVisitHelpDefenseRespVo respVo = (SfaVisitHelpDefenseRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitHelpDefenseEntity), SfaVisitHelpDefenseRespVo.class);
        List sfaVisitHelpDefenseDetailEntities = ((LambdaQueryChainWrapper)this.sfaVisitHelpDefenseDetailService.lambdaQuery().eq(SfaVisitHelpDefenseDetailEntity::getVisitHelpDefenseId, (Object)sfaVisitHelpDefenseEntity.getId())).list();
        List sfaVisitHelpDefenseDetailRespVos = CrmBeanUtil.copyList((List)sfaVisitHelpDefenseDetailEntities, SfaVisitHelpDefenseDetailRespVo.class);
        this.loadOutInStorePicList(respVo, sfaVisitHelpDefenseEntity.getId());
        respVo.setSfaVisitHelpDefenseDetailList(sfaVisitHelpDefenseDetailRespVos);
        return respVo;
    }

    private void loadOutInStorePicList(SfaVisitHelpDefenseRespVo respVo, String id) {
        List pictureEntities = ((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)id)).list();
        Map<String, List<SfaVisitPictureEntity>> stringListMap = pictureEntities.stream().collect(Collectors.groupingBy(SfaVisitPictureEntity::getPicType));
        List<SfaVisitPictureEntity> entities = stringListMap.get(SfaVisitEnum.visitPicType.DEALER_IN_STORE_PIC.getVal());
        List<Object> picUrls = null != entities ? entities.stream().map(v -> v.getPicUrl() + v.getPicPath()).collect(Collectors.toList()) : Lists.newArrayList();
        respVo.setInStorePicList((List)picUrls);
        entities = stringListMap.get(SfaVisitEnum.visitPicType.DEALER_OUT_STORE_PIC.getVal());
        picUrls = null != entities ? entities.stream().map(v -> v.getPicUrl() + v.getPicPath()).collect(Collectors.toList()) : Lists.newArrayList();
        respVo.setOutStorePicList((List)picUrls);
    }

    private SfaHelpDefenseDetailEntity checkInStore(HelpDefenseInStoreReqVo helpDefenseInStoreReqVo) {
        AssertUtils.isNotEmpty((String)helpDefenseInStoreReqVo.getInStoreAddress(), (String)"\u8fdb\u5e97\u5730\u5740\u4e3a\u7a7a");
        if (helpDefenseInStoreReqVo.getInStoreLatitude() == null && helpDefenseInStoreReqVo.getInStoreLongitude() == null) {
            throw new BusinessException("\u8fdb\u5e97\u7ecf\u7eac\u5ea6\u4e3a\u7a7a");
        }
        AssertUtils.isNotEmpty((String)helpDefenseInStoreReqVo.getId(), (String)"\u534f\u8bbf\u660e\u7ec6id\u4e3a\u7a7a");
        SfaHelpDefenseDetailEntity sfaHelpDefenseDetailEntity = (SfaHelpDefenseDetailEntity)((Object)((LambdaQueryChainWrapper)this.sfaHelpDefenseDetailService.lambdaQuery().eq(BaseIdEntity::getId, (Object)helpDefenseInStoreReqVo.getId())).one());
        if (sfaHelpDefenseDetailEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bbf\u660e\u7ec6\u4fe1\u606f");
        }
        if (!SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getVal().equals(sfaHelpDefenseDetailEntity.getHelpDefenseStatus())) {
            throw new BusinessException("\u5f85\u534f\u8bbf\u65f6\u624d\u53ef\u8fdb\u5e97\u6253\u5361");
        }
        SfaVisitHelpDefenseReqVo reqVo = new SfaVisitHelpDefenseReqVo();
        UserRedis userRedis = UserUtils.getUser();
        reqVo.setUserName(userRedis.getUsername());
        reqVo.setPosCode(userRedis.getPoscode());
        reqVo.setClientType(sfaHelpDefenseDetailEntity.getClientType());
        reqVo.setHelpDefenseStatus(SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal());
        reqVo.setDefenseDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
        List<SfaVisitHelpDefenseRespVo> sfaVisitHelpDefenseRespVos = this.sfaVisitHelpDefenseMapper.findHelpDefenseSchedule(reqVo);
        if (sfaVisitHelpDefenseRespVos.size() > 0) {
            throw new BusinessException("\u5df2\u6709\u6b63\u5728\u534f\u8bbf\u7684\u5ba2\u6237");
        }
        return sfaHelpDefenseDetailEntity;
    }

    private SfaHelpDefenseDetailEntity checkOutStore(SfaVisitHelpDefenseReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getOutStoreAddress(), (String)"\u79bb\u5e97\u5730\u5740\u4e3a\u7a7a");
        if (reqVo.getOutStoreLatitude() == null && reqVo.getOutStoreLongitude() == null) {
            throw new BusinessException("\u79bb\u5e97\u7ecf\u7eac\u5ea6\u4e3a\u7a7a");
        }
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u534f\u8bbf\u660e\u7ec6id\u4e3a\u7a7a");
        SfaHelpDefenseDetailEntity sfaHelpDefenseDetailEntity = (SfaHelpDefenseDetailEntity)((Object)((LambdaQueryChainWrapper)this.sfaHelpDefenseDetailService.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getId())).one());
        if (sfaHelpDefenseDetailEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bbf\u8ba1\u5212\u660e\u7ec6\u4fe1\u606f");
        }
        return sfaHelpDefenseDetailEntity;
    }

    private void checkHelpDefenseStep(SfaVisitHelpDefenseDetailReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u534f\u8bbf\u8ba1\u5212\u660e\u7ec6id\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getDirectoryName(), (String)"\u534f\u8bbf\u6b65\u9aa4\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getDirectoryCode(), (String)"\u534f\u8bbf\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getIsQualified(), (String)"\u534f\u8bbf\u662f\u5426\u5408\u683c\u4e3a\u7a7a");
    }

    private Map<String, String> getButtons(String userName, String helpDefenseStatus, String defenseDate) {
        LocalDate now = LocalDate.now();
        LocalDate localVisitDate = LocalDate.parse(defenseDate, CrmDateUtils.yyyyMMdd);
        HashMap<String, String> map = new HashMap<String, String>();
        String username = UserUtils.getUser().getUsername();
        AssertUtils.isNotEmpty((String)username, (String)"\u672a\u83b7\u53d6\u5230\u767b\u9646\u4eba\u4fe1\u606f");
        map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
        map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
        map.put(SfaVisitEnum.visitButton.DETAIL.getVal(), SfaVisitEnum.visitButton.DETAIL.getDesc());
        map.put(SfaVisitEnum.visitButton.VISIT.getVal(), SfaVisitEnum.visitButton.VISIT.getDesc());
        if (!now.isEqual(localVisitDate)) {
            map.remove(SfaVisitEnum.visitButton.DETAIL.getVal());
            map.remove(SfaVisitEnum.visitButton.VISIT.getVal());
        }
        if (helpDefenseStatus.equals(SfaVisitEnum.visitStatus.V1.getVal())) {
            map.remove(SfaVisitEnum.visitButton.DETAIL.getVal());
            if (!userName.equals(username)) {
                map.remove(SfaVisitEnum.visitButton.VISIT.getVal());
            }
        } else if (helpDefenseStatus.equals(SfaVisitEnum.visitStatus.V2.getVal())) {
            map.remove(SfaVisitEnum.visitButton.DETAIL.getVal());
            if (!userName.equals(username)) {
                map.remove(SfaVisitEnum.visitButton.VISIT.getVal());
            }
        } else if (helpDefenseStatus.equals(SfaVisitEnum.visitStatus.V3.getVal())) {
            map.remove(SfaVisitEnum.visitButton.VISIT.getVal());
        } else if (helpDefenseStatus.equals(SfaVisitEnum.visitStatus.V4.getVal())) {
            map.remove(SfaVisitEnum.visitButton.VISIT.getVal());
        }
        return map;
    }

    @Override
    public SfaVisitHelpDefenseRespVo query(SfaVisitHelpDefenseReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitHelpDefenseReqVo reqVo) {
        SfaVisitHelpDefenseEntity entity = (SfaVisitHelpDefenseEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitHelpDefenseEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitHelpDefenseReqVo reqVo) {
        SfaVisitHelpDefenseEntity entity = (SfaVisitHelpDefenseEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }
}

