/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.req;

import com.biz.crm.base.BusinessException;
import com.biz.crm.visitstep.req.VisitStepPageReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

@ApiModel(value="\u67e5\u8be2\u5e97\u9762\u68c0\u67e5\u5206\u9875-\u53c2\u6570")
public class GetStoreCheckPageReq
extends VisitStepPageReq {
    @ApiModelProperty(value="\u5ba2\u6237\u7f16\u7801")
    private String clientCode;
    @ApiModelProperty(value="\u68c0\u67e5\u65f6\u95f4")
    private String endCheckTime;
    @ApiModelProperty(value="\u68c0\u67e5\u65f6\u95f4")
    private String startCheckTime;
    @ApiModelProperty(value="\u68c0\u67e5\u9879\u63cf\u8ff0(0-\u5e38\u89c4\u8d27\u67b6\u9648\u5217,1-\u7269\u6599\u9648\u5217,2-\u4ef7\u683c\u7b7e)")
    private String checkTypeDesc;

    public NativeSearchQuery buildQuery() {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        if (StringUtils.isBlank((CharSequence)this.getClientCode())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5ba2\u6237\u7f16\u7801");
        }
        if (StringUtils.isBlank((CharSequence)this.getStepCode())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6b65\u9aa4\u7f16\u7801");
        }
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"stepCode.keyword", (String)this.getStepCode()));
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientCode.keyword", (String)this.getClientCode()));
        if (StringUtils.isNotBlank((CharSequence)this.getStartCheckTime())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"checkTime").from((Object)this.getStartCheckTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getEndCheckTime())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"checkTime").to((Object)this.getEndCheckTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getCheckTypeDesc())) {
            builder.must((QueryBuilder)QueryBuilders.matchQuery((String)"checkTypeDesc", (Object)this.getCheckTypeDesc()));
        }
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)(this.getPageNum() - 1), (int)this.getPageSize()));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"checkTime").order(SortOrder.DESC));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }

    public String getClientCode() {
        return this.clientCode;
    }

    public String getEndCheckTime() {
        return this.endCheckTime;
    }

    public String getStartCheckTime() {
        return this.startCheckTime;
    }

    public String getCheckTypeDesc() {
        return this.checkTypeDesc;
    }

    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    public void setEndCheckTime(String endCheckTime) {
        this.endCheckTime = endCheckTime;
    }

    public void setStartCheckTime(String startCheckTime) {
        this.startCheckTime = startCheckTime;
    }

    public void setCheckTypeDesc(String checkTypeDesc) {
        this.checkTypeDesc = checkTypeDesc;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetStoreCheckPageReq)) {
            return false;
        }
        GetStoreCheckPageReq other = (GetStoreCheckPageReq)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$clientCode = this.getClientCode();
        String other$clientCode = other.getClientCode();
        if (this$clientCode == null ? other$clientCode != null : !this$clientCode.equals(other$clientCode)) {
            return false;
        }
        String this$endCheckTime = this.getEndCheckTime();
        String other$endCheckTime = other.getEndCheckTime();
        if (this$endCheckTime == null ? other$endCheckTime != null : !this$endCheckTime.equals(other$endCheckTime)) {
            return false;
        }
        String this$startCheckTime = this.getStartCheckTime();
        String other$startCheckTime = other.getStartCheckTime();
        if (this$startCheckTime == null ? other$startCheckTime != null : !this$startCheckTime.equals(other$startCheckTime)) {
            return false;
        }
        String this$checkTypeDesc = this.getCheckTypeDesc();
        String other$checkTypeDesc = other.getCheckTypeDesc();
        return !(this$checkTypeDesc == null ? other$checkTypeDesc != null : !this$checkTypeDesc.equals(other$checkTypeDesc));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetStoreCheckPageReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientCode = this.getClientCode();
        result = result * 59 + ($clientCode == null ? 43 : $clientCode.hashCode());
        String $endCheckTime = this.getEndCheckTime();
        result = result * 59 + ($endCheckTime == null ? 43 : $endCheckTime.hashCode());
        String $startCheckTime = this.getStartCheckTime();
        result = result * 59 + ($startCheckTime == null ? 43 : $startCheckTime.hashCode());
        String $checkTypeDesc = this.getCheckTypeDesc();
        result = result * 59 + ($checkTypeDesc == null ? 43 : $checkTypeDesc.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "GetStoreCheckPageReq(clientCode=" + this.getClientCode() + ", endCheckTime=" + this.getEndCheckTime() + ", startCheckTime=" + this.getStartCheckTime() + ", checkTypeDesc=" + this.getCheckTypeDesc() + ")";
    }
}

