/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksignrule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.cache.util.SfaWorkSignRuleInfoUtil;
import com.biz.crm.cache.util.SfaWorkSignRuleUtil;
import com.biz.crm.calculatesalary.service.ISfaCalculateSalaryDateService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgTreeRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgWithPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.worksignrule.SfaWorkSignPersonnelVo;
import com.biz.crm.nebular.sfa.worksignrule.SfaWorkSignRuleVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignExecuteReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPersonnelReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPlaceReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignRuleReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignSpecialReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignTimeReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPersonnelRespVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignRuleRespVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignSpecialRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import com.biz.crm.worksignrule.mapper.SfaWorkSignPersonnelMapper;
import com.biz.crm.worksignrule.mapper.SfaWorkSignPlaceMapper;
import com.biz.crm.worksignrule.mapper.SfaWorkSignRuleMapper;
import com.biz.crm.worksignrule.mapper.SfaWorkSignSpecialMapper;
import com.biz.crm.worksignrule.mapper.SfaWorkSignTimeMapper;
import com.biz.crm.worksignrule.model.SfaWorkSignPersonnelEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignPlaceEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignRuleEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignSpecialEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;
import com.biz.crm.worksignrule.service.ISfaWorkSignPersonnelService;
import com.biz.crm.worksignrule.service.ISfaWorkSignPlaceService;
import com.biz.crm.worksignrule.service.ISfaWorkSignRuleService;
import com.biz.crm.worksignrule.service.ISfaWorkSignSpecialService;
import com.biz.crm.worksignrule.service.ISfaWorkSignTimeService;
import com.biz.crm.worksignrule.service.impl.ExecuteSignRuleContext;
import com.biz.crm.worksignrule.service.impl.SignRuleResolveHelper;
import com.biz.crm.worksignrule.vo.ExecuteWorkSignRuleVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@ConditionalOnMissingBean(name={"SfaWorkSignRuleServiceExpandImpl"})
public class SfaWorkSignRuleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaWorkSignRuleMapper, SfaWorkSignRuleEntity>
implements ISfaWorkSignRuleService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignRuleServiceImpl.class);
    private final Object $lock = new Object[0];
    @Resource
    private ISfaWorkSignPersonnelService iSfaWorkSignPersonnelService;
    @Resource
    private ISfaWorkSignPlaceService iSfaWorkSignPlaceService;
    @Resource
    private ISfaWorkSignTimeService iSfaWorkSignTimeService;
    @Resource
    private ISfaWorkSignSpecialService iSfaWorkSignSpecialService;
    @Resource
    private ISfaWorkSignRuleInfoService iSfaWorkSignRuleInfoService;
    @Resource
    private ISfaWorkSignRecordService iSfaWorkSignRecordService;
    @Resource
    private SfaWorkSignRuleMapper sfaWorkSignRuleMapper;
    @Resource
    private SfaWorkSignPersonnelMapper personnelMapper;
    @Resource
    private SfaWorkSignPlaceMapper placeMapper;
    @Resource
    private SfaWorkSignSpecialMapper specialMapper;
    @Resource
    private SfaWorkSignTimeMapper signTimeMapper;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private ISfaCalculateSalaryDateService dateService;
    @Resource
    private SfaWorkSignRuleUtil sfaWorkSignRuleUtil;
    @Resource
    private SfaWorkSignRuleInfoUtil sfaWorkSignRuleInfoUtil;
    @Resource
    protected SignRuleResolveHelper signRuleResolveHelper;

    @Override
    @CrmLog
    public PageResult<SfaWorkSignRuleRespVo> findList(SfaWorkSignRuleVo sfaWorkSignRuleVo) {
        Page page = new Page((long)sfaWorkSignRuleVo.getPageNum().intValue(), (long)sfaWorkSignRuleVo.getPageSize().intValue());
        List<SfaWorkSignRuleRespVo> list = this.sfaWorkSignRuleMapper.findList((Page<SfaWorkSignRuleVo>)page, sfaWorkSignRuleVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaWorkSignRuleRespVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        SfaWorkSignRuleEntity entity = (SfaWorkSignRuleEntity)((Object)this.sfaWorkSignRuleMapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return null;
        }
        return this.sfaWorkSignRuleUtil.getObj(entity.getRuleCode());
    }

    @Override
    @CrmLog
    public SfaWorkSignRuleRespVo query(SfaWorkSignRuleReqVo reqVo) {
        List list = this.findList((SfaWorkSignRuleVo)reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new SfaWorkSignRuleRespVo();
        }
        SfaWorkSignRuleRespVo sfaWorkSignRuleRespVo = (SfaWorkSignRuleRespVo)list.get(0);
        SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo = new SfaWorkSignPersonnelReqVo();
        sfaWorkSignPersonnelReqVo.setRuleCode(sfaWorkSignRuleRespVo.getRuleCode());
        sfaWorkSignPersonnelReqVo.setPageSize(Integer.valueOf(-1));
        List personnelEntities = this.iSfaWorkSignPersonnelService.list((Wrapper)Wrappers.lambdaQuery(SfaWorkSignPersonnelEntity.class).eq(SfaWorkSignPersonnelEntity::getRuleCode, (Object)sfaWorkSignRuleRespVo.getRuleCode()));
        List sfaWorkSignPersonnelRespVos = CrmBeanUtil.copyList((List)personnelEntities, SfaWorkSignPersonnelRespVo.class);
        if (CollectionUtil.listNotEmpty((List)sfaWorkSignPersonnelRespVos)) {
            List org = sfaWorkSignPersonnelRespVos.stream().filter(data -> WorkSignEnum.codeType.ORG.getVal().equals(data.getCodeType())).collect(Collectors.toList());
            List posLevel = sfaWorkSignPersonnelRespVos.stream().filter(data -> WorkSignEnum.codeType.POS_LEVEL.getVal().equals(data.getCodeType())).collect(Collectors.toList());
            sfaWorkSignRuleRespVo.setSfaWorkSignPersonnelRespVo(org);
            sfaWorkSignRuleRespVo.setSfaWorkSignPersonnelPosRespVo(posLevel);
        }
        SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo = new SfaWorkSignPlaceReqVo();
        sfaWorkSignPlaceReqVo.setRuleCode(sfaWorkSignRuleRespVo.getRuleCode());
        sfaWorkSignPlaceReqVo.setPageSize(Integer.valueOf(-1));
        List sfaWorkSignPlaceRespVos = this.iSfaWorkSignPlaceService.findList(sfaWorkSignPlaceReqVo).getData();
        sfaWorkSignRuleRespVo.setSfaWorkSignPlaceRespVos(sfaWorkSignPlaceRespVos);
        SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo = new SfaWorkSignTimeReqVo();
        sfaWorkSignTimeReqVo.setRuleCode(sfaWorkSignRuleRespVo.getRuleCode());
        sfaWorkSignTimeReqVo.setPageSize(Integer.valueOf(-1));
        List sfaWorkSignTimeRespVos = this.iSfaWorkSignTimeService.findList(sfaWorkSignTimeReqVo).getData();
        sfaWorkSignRuleRespVo.setSfaWorkSignTimeRespVos(sfaWorkSignTimeRespVos);
        SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo = new SfaWorkSignSpecialReqVo();
        sfaWorkSignSpecialReqVo.setRuleCode(sfaWorkSignRuleRespVo.getRuleCode());
        List<SfaWorkSignSpecialRespVo> sfaWorkSignSpecialRespVos = this.iSfaWorkSignSpecialService.findNonPageList(sfaWorkSignSpecialReqVo);
        if (CollectionUtil.listNotEmpty(sfaWorkSignSpecialRespVos)) {
            ArrayList<SfaWorkSignSpecialRespVo> sfaWorkSignSpecialMustRespVos = new ArrayList<SfaWorkSignSpecialRespVo>();
            ArrayList<SfaWorkSignSpecialRespVo> sfaWorkSignSpecialNotRespVos = new ArrayList<SfaWorkSignSpecialRespVo>();
            for (SfaWorkSignSpecialRespVo specialRespVos : sfaWorkSignSpecialRespVos) {
                if (SfaWorkSignEnum.workSignSpecialType.One.getVal().equals(specialRespVos.getWssType())) {
                    sfaWorkSignSpecialMustRespVos.add(specialRespVos);
                    continue;
                }
                sfaWorkSignSpecialNotRespVos.add(specialRespVos);
            }
            sfaWorkSignRuleRespVo.setSfaWorkSignSpecialMustRespVos(sfaWorkSignSpecialMustRespVos);
            sfaWorkSignRuleRespVo.setSfaWorkSignSpecialNotRespVos(sfaWorkSignSpecialNotRespVos);
        }
        return sfaWorkSignRuleRespVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(SfaWorkSignRuleReqVo reqVo) {
        Object object = this.$lock;
        synchronized (object) {
            this.saveCheck(reqVo);
            SfaWorkSignRuleEntity entity = (SfaWorkSignRuleEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignRuleEntity.class));
            String code = CodeUtil.getCodeDefault();
            entity.setRuleCode(code);
            this.save((Object)entity);
            this.saveData(reqVo, entity);
        }
    }

    public void saveData(SfaWorkSignRuleReqVo reqVo, SfaWorkSignRuleEntity entity) {
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqVo.getSfaWorkSignPersonnelReqVo())) {
            if (CollectionUtil.listNotEmpty((List)reqVo.getSfaWorkSignPersonnelPosReqVo())) {
                reqVo.getSfaWorkSignPersonnelReqVo().addAll(reqVo.getSfaWorkSignPersonnelPosReqVo());
            }
            List personnelContainList = reqVo.getSfaWorkSignPersonnelReqVo().stream().map(o -> {
                SfaWorkSignPersonnelEntity personnelEntity = new SfaWorkSignPersonnelEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)personnelEntity));
                personnelEntity.setId(null);
                personnelEntity.setRuleCode(entity.getRuleCode());
                return personnelEntity;
            }).collect(Collectors.toList());
            this.iSfaWorkSignPersonnelService.saveOrUpdateBatch(personnelContainList, 200);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaWorkSignPlaceReqVos())) {
            List signPlaceEntityList = reqVo.getSfaWorkSignPlaceReqVos().stream().map(o -> {
                SfaWorkSignPlaceEntity signPlaceEntity = new SfaWorkSignPlaceEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)signPlaceEntity));
                signPlaceEntity.setRuleCode(entity.getRuleCode());
                return signPlaceEntity;
            }).collect(Collectors.toList());
            this.iSfaWorkSignPlaceService.saveOrUpdateBatch(signPlaceEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaWorkSignTimeReqVos())) {
            List sfaWorkSignTimeReqVos = reqVo.getSfaWorkSignTimeReqVos();
            ArrayList signTimeEntityList = Lists.newArrayList();
            Integer i = 1;
            for (SfaWorkSignTimeReqVo temp : sfaWorkSignTimeReqVos) {
                SfaWorkSignTimeEntity signTimeEntity = (SfaWorkSignTimeEntity)((Object)CrmBeanUtil.copy((Object)temp, SfaWorkSignTimeEntity.class));
                signTimeEntity.setRuleCode(entity.getRuleCode());
                signTimeEntity.setWstNo(i.toString());
                signTimeEntityList.add(signTimeEntity);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.iSfaWorkSignTimeService.saveOrUpdateBatch(signTimeEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaWorkSignSpecialMustReqVos())) {
            List signSpecialEntityList = reqVo.getSfaWorkSignSpecialMustReqVos().stream().map(o -> {
                SfaWorkSignSpecialEntity signSpecialEntity = new SfaWorkSignSpecialEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)signSpecialEntity));
                signSpecialEntity.setWssType(SfaWorkSignEnum.workSignSpecialType.One.getVal());
                signSpecialEntity.setRuleCode(entity.getRuleCode());
                return signSpecialEntity;
            }).collect(Collectors.toList());
            this.iSfaWorkSignSpecialService.saveOrUpdateBatch(signSpecialEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaWorkSignSpecialNotReqVos())) {
            List specialEntityList = reqVo.getSfaWorkSignSpecialNotReqVos().stream().map(o -> {
                SfaWorkSignSpecialEntity specialEntity = new SfaWorkSignSpecialEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)specialEntity));
                specialEntity.setWssType(SfaWorkSignEnum.workSignSpecialType.Two.getVal());
                specialEntity.setRuleCode(entity.getRuleCode());
                return specialEntity;
            }).collect(Collectors.toList());
            this.iSfaWorkSignSpecialService.saveOrUpdateBatch(specialEntityList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaWorkSignRuleReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaWorkSignRuleEntity entity = (SfaWorkSignRuleEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u8003\u52e4\u89c4\u5219\u6570\u636e\u4e0d\u5b58\u5728");
        }
        reqVo.setRuleCode(entity.getRuleCode());
        this.saveCheck(reqVo);
        SfaWorkSignRuleEntity updateEntity = (SfaWorkSignRuleEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignRuleEntity.class));
        updateEntity.setRuleCode(null);
        this.updateById((Object)updateEntity);
        reqVo.setRuleCode(entity.getRuleCode());
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo, entity);
        this.sfaWorkSignRuleUtil.deleteKey(entity.getRuleCode());
    }

    public void deleteBatchDate(SfaWorkSignRuleReqVo reqVo) {
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getRuleCode()) || CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getRuleCodes())) {
            SfaWorkSignPersonnelReqVo signPersonnelReqVo = new SfaWorkSignPersonnelReqVo();
            signPersonnelReqVo.setRuleCode(reqVo.getRuleCode());
            signPersonnelReqVo.setRuleCodes(reqVo.getRuleCodes());
            this.personnelMapper.deleteProductsByParams(signPersonnelReqVo);
            SfaWorkSignPlaceReqVo signPlaceReqVo = new SfaWorkSignPlaceReqVo();
            signPlaceReqVo.setRuleCode(reqVo.getRuleCode());
            signPlaceReqVo.setRuleCodes(reqVo.getRuleCodes());
            this.placeMapper.deleteProductsByParams(signPlaceReqVo);
            SfaWorkSignTimeReqVo signTimeReqVo = new SfaWorkSignTimeReqVo();
            signTimeReqVo.setRuleCode(reqVo.getRuleCode());
            signTimeReqVo.setRuleCodes(reqVo.getRuleCodes());
            this.signTimeMapper.deleteProductsByParams(signTimeReqVo);
            SfaWorkSignSpecialReqVo signSpecialReqVo = new SfaWorkSignSpecialReqVo();
            signSpecialReqVo.setRuleCode(reqVo.getRuleCode());
            signSpecialReqVo.setRuleCodes(reqVo.getRuleCodes());
            this.specialMapper.deleteProductsByParams(signSpecialReqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(SfaWorkSignRuleReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqVo.setPageSize(Integer.valueOf(-1));
        List list = this.findList((SfaWorkSignRuleVo)reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            throw new BusinessException("\u8003\u52e4\u89c4\u5219\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (list.size() != reqVo.getIds().size()) {
            throw new BusinessException("\u4e3b\u952eID\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        List<String> result = this.sfaWorkSignRuleMapper.findUseRuleCodeByIds(reqVo.getIds());
        if (result != null && result.size() > 0) {
            throw new BusinessException("\u89c4\u5219\uff1a" + result.get(0) + " \u5df2\u751f\u6210\u8003\u52e4\u6570\u636e");
        }
        this.sfaWorkSignRuleMapper.deleteProductsByParams(reqVo);
        List<String> ruleCodes = list.stream().map(SfaWorkSignRuleVo::getRuleCode).collect(Collectors.toList());
        reqVo.setRuleCodes(ruleCodes);
        this.deleteBatchDate(reqVo);
        ruleCodes.forEach(code -> this.sfaWorkSignRuleUtil.deleteKey((String)code));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(SfaWorkSignRuleReqVo reqVo) {
        List sfaWorkSignRuleEntities;
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5c06\u542f\u7528\u4fe1\u606f");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaWorkSignRuleEntities = this.sfaWorkSignRuleMapper.selectBatchIds(reqVo.getIds())))) {
            if (sfaWorkSignRuleEntities.size() != reqVo.getIds().size()) {
                throw new BusinessException("\u4e3b\u952eID\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
            }
            sfaWorkSignRuleEntities.forEach(o -> {
                List personnelEntities = this.iSfaWorkSignPersonnelService.list((Wrapper)Wrappers.lambdaQuery(SfaWorkSignPersonnelEntity.class).eq(SfaWorkSignPersonnelEntity::getRuleCode, (Object)o.getRuleCode()));
                if (CollectionUtil.listEmpty((List)personnelEntities)) {
                    throw new BusinessException("\u8be5\u89c4\u5219\u672a\u914d\u7f6e\u6253\u5361\u7ec4\u7ec7:" + o.getRuleCode());
                }
                List signPersonnelReqVos = CrmBeanUtil.copyList((List)personnelEntities, SfaWorkSignPersonnelReqVo.class);
                List orgReqVos = signPersonnelReqVos.stream().filter(data -> WorkSignEnum.codeType.ORG.getVal().equals(data.getCodeType())).collect(Collectors.toList());
                List posReqVos = signPersonnelReqVos.stream().filter(data -> WorkSignEnum.codeType.POS_LEVEL.getVal().equals(data.getCodeType())).collect(Collectors.toList());
                SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo = (SfaWorkSignRuleReqVo)CrmBeanUtil.copy((Object)o, SfaWorkSignRuleReqVo.class);
                sfaWorkSignRuleReqVo.setSfaWorkSignPersonnelReqVo(orgReqVos);
                sfaWorkSignRuleReqVo.setSfaWorkSignPersonnelPosReqVo(posReqVos);
                this.checkSignRange(sfaWorkSignRuleReqVo.getSfaWorkSignPersonnelReqVo(), sfaWorkSignRuleReqVo);
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSignRuleEntities);
        if (CollectionUtil.listNotEmpty((List)sfaWorkSignRuleEntities)) {
            sfaWorkSignRuleEntities.forEach(entity -> this.sfaWorkSignRuleUtil.deleteKey(entity.getRuleCode()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(SfaWorkSignRuleReqVo reqVo) {
        List sfaWorkSignRuleEntities;
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if ((sfaWorkSignRuleEntities = this.sfaWorkSignRuleMapper.selectBatchIds(reqVo.getIds())).size() != reqVo.getIds().size()) {
            throw new BusinessException("\u4e3b\u952eID\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRuleEntities)) {
            sfaWorkSignRuleEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRuleEntities);
        List ruleCodes = sfaWorkSignRuleEntities.stream().map(SfaWorkSignRuleEntity::getRuleCode).collect(Collectors.toList());
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        this.iSfaWorkSignRecordService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(SfaWorkSignRecordEntity::getRuleDate, (Object)nowDate)).in(SfaWorkSignRecordEntity::getRuleCode, ruleCodes));
        this.iSfaWorkSignRuleInfoService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRuleInfoEntity.class).eq(SfaWorkSignRuleInfoEntity::getRuleDate, (Object)nowDate)).in(SfaWorkSignRuleInfoEntity::getRuleCode, ruleCodes));
        if (CollectionUtil.listNotEmpty((List)sfaWorkSignRuleEntities)) {
            sfaWorkSignRuleEntities.forEach(entity -> this.sfaWorkSignRuleUtil.deleteKey(entity.getRuleCode()));
        }
    }

    private void defCheck(SfaWorkSignRuleReqVo reqVo) {
        if (StringUtils.isBlank((CharSequence)reqVo.getRuleType())) {
            reqVo.setRuleType(SfaWorkSignEnum.WorkSignRuleType.STATIC.getVal());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getElectronFence())) {
            reqVo.setElectronFence(SfaWorkSignEnum.ElectronFenceEnum.NONE.getVal());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getRuleEffective())) {
            reqVo.setRuleEffective(SfaWorkSignEnum.RuleEffective.TOMORROW.getVal());
        }
        if (!YesNoEnum.yesNoEnum.YES.getValue().equals(reqVo.getHolidayWhether())) {
            reqVo.setHolidayWhether(YesNoEnum.yesNoEnum.NO.getValue());
        }
        if (!YesNoEnum.yesNoEnum.YES.getValue().equals(reqVo.getWsrPhotograph())) {
            reqVo.setWsrPhotograph(YesNoEnum.yesNoEnum.NO.getValue());
        }
        if (!YesNoEnum.yesNoEnum.YES.getValue().equals(reqVo.getWsrPhotograph())) {
            reqVo.setWsrPhotograph(YesNoEnum.yesNoEnum.NO.getValue());
        }
        if (!YesNoEnum.yesNoEnum.YES.getValue().equals(reqVo.getNonWorkingDaySignAstrict())) {
            reqVo.setNonWorkingDaySignAstrict(YesNoEnum.yesNoEnum.NO.getValue());
        }
    }

    public void saveCheck(SfaWorkSignRuleReqVo reqVo) {
        this.defCheck(reqVo);
        AssertUtils.isNotEmpty((String)reqVo.getRuleName(), (String)"\u8bf7\u8f93\u5165\u89c4\u5219\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getRuleType(), (String)"\u8bf7\u9009\u62e9\u89c4\u5219\u7c7b\u578b");
        this.checkPlace(reqVo.getElectronFence(), reqVo.getSfaWorkSignPlaceReqVos());
        this.checkSpecialDate(reqVo.getSfaWorkSignSpecialMustReqVos());
        this.checkSpecialDate(reqVo.getSfaWorkSignSpecialNotReqVos());
        this.checkSignRange(reqVo.getSfaWorkSignPersonnelReqVo(), reqVo);
        this.checkSignTime(reqVo);
        AssertUtils.isNotEmpty((String)reqVo.getWorkingDay(), (String)"\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5");
        AssertUtils.isNotEmpty((String)reqVo.getGooffWorkSignAstrict(), (String)"\u8bf7\u9009\u62e9\u4e0b\u73ed\u6253\u5361\u9650\u5236");
        this.checkDataExist(reqVo);
        reqVo.getSfaWorkSignPersonnelReqVo().forEach(data -> data.setCodeType(WorkSignEnum.codeType.ORG.getVal()));
        if (CollectionUtil.listNotEmpty((List)reqVo.getSfaWorkSignPersonnelPosReqVo())) {
            reqVo.getSfaWorkSignPersonnelPosReqVo().forEach(data -> data.setCodeType(WorkSignEnum.codeType.POS_LEVEL.getVal()));
        }
    }

    private void checkPlace(String electronFence, List<SfaWorkSignPlaceReqVo> placeReqVos) {
        if (CollectionUtil.listNotEmpty(placeReqVos)) {
            int p = 1;
            for (SfaWorkSignPlaceReqVo placeReqVo : placeReqVos) {
                AssertUtils.isNotEmpty((String)placeReqVo.getWspNo(), (String)("\u7b2c" + p + "\u6761\u6253\u5361\u5730\u70b9\uff0c\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
                this.iSfaWorkSignPlaceService.saveCheck(placeReqVo);
                ++p;
            }
        }
        if (!SfaWorkSignEnum.ElectronFenceEnum.NONE.getVal().equals(electronFence)) {
            AssertUtils.isNotEmpty(placeReqVos, (String)"\u8bf7\u6dfb\u52a0\u6253\u5361\u5730\u70b9");
            boolean nonClockAll = false;
            boolean nonClockIn = false;
            boolean nonClockOut = false;
            for (SfaWorkSignPlaceReqVo vo : placeReqVos) {
                if (SfaWorkSignEnum.WorkSignType.CLOCK_ALL.getVal().equals(vo.getPlaceSignType())) {
                    nonClockAll = true;
                    continue;
                }
                if (SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal().equals(vo.getPlaceSignType())) {
                    nonClockIn = true;
                    continue;
                }
                if (!SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getVal().equals(vo.getPlaceSignType())) continue;
                nonClockOut = true;
            }
            if (!(nonClockAll || nonClockIn && nonClockOut)) {
                throw new BusinessException("\u6253\u5361\u5730\u70b9\u5fc5\u987b\u5305\u542b\u4e0a\u4e0b\u73ed\u6253\u5361\uff01");
            }
        }
    }

    private void checkSignTime(SfaWorkSignRuleReqVo reqVo) {
        if (SfaWorkSignEnum.WorkSignRuleType.STATIC.getVal().equals(reqVo.getRuleType())) {
            AssertUtils.isNotEmpty((Collection)reqVo.getSfaWorkSignTimeReqVos(), (String)"\u8bf7\u9009\u62e9\u6253\u5361\u65f6\u95f4");
        } else if (SfaWorkSignEnum.WorkSignRuleType.FREE_TIME.getVal().equals(reqVo.getRuleType())) {
            SfaWorkSignTimeReqVo vo = new SfaWorkSignTimeReqVo();
            vo.setGotoTime("00:00:00");
            vo.setGooffTime("23:59:59");
            vo.setGotoStartTime("00:00:00");
            vo.setGotoEndTime("23:59:59");
            vo.setGooffStartTime("00:00:00");
            vo.setGooffEndTime("23:59:59");
            List sfaWorkSignTimeReqVos = reqVo.getSfaWorkSignTimeReqVos();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)sfaWorkSignTimeReqVos)) {
                vo.setId(((SfaWorkSignTimeReqVo)sfaWorkSignTimeReqVos.get(0)).getId());
            }
            reqVo.setSfaWorkSignTimeReqVos(Arrays.asList(vo));
        }
        List sfaWorkSignTimeReqVos = reqVo.getSfaWorkSignTimeReqVos();
        AssertUtils.isNotNull((Object)sfaWorkSignTimeReqVos, (String)"\u8bf7\u914d\u7f6e\u6253\u5361\u65f6\u95f4");
        String endTime = null;
        int i = 1;
        for (SfaWorkSignTimeReqVo timeReqVo : sfaWorkSignTimeReqVos) {
            this.iSfaWorkSignTimeService.saveCheck(timeReqVo);
            if (StringUtils.isEmpty(endTime)) {
                endTime = timeReqVo.getGooffEndTime();
            } else {
                if (LocalTime.parse(endTime).compareTo(LocalTime.parse(timeReqVo.getGotoStartTime())) > 0) {
                    throw new BusinessException("<\u7b2c" + (i - 1) + ">\u6bb5\u6253\u5361\u4e0b\u73ed\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e<\u7b2c" + i + ">\u6bb5\u6253\u5361\u4e0a\u73ed\u5f00\u59cb\u65f6\u95f4");
                }
                endTime = timeReqVo.getGooffEndTime();
            }
            ++i;
        }
    }

    private void checkSignRange(List<SfaWorkSignPersonnelReqVo> sfaWorkSignPersonnelReqVos, SfaWorkSignRuleReqVo reqVo) {
        List ruleEntities;
        AssertUtils.isNotEmpty(sfaWorkSignPersonnelReqVos, (String)"\u8bf7\u6dfb\u52a0\u6253\u5361\u7ec4\u7ec7");
        ArrayList<String> wspCodes = new ArrayList<String>();
        for (SfaWorkSignPersonnelReqVo vo : sfaWorkSignPersonnelReqVos) {
            AssertUtils.isNotEmpty((String)vo.getWspCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)vo.getWspName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)vo.getCodeType(), (String)"\u7f16\u7801\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            vo.setCurrentAble(YesNoEnum.yesNoEnum.NO.getValue());
            wspCodes.add(vo.getWspCode());
        }
        List personnelPosReqVo = reqVo.getSfaWorkSignPersonnelPosReqVo();
        personnelPosReqVo.forEach(data -> data.setCurrentAble(YesNoEnum.yesNoEnum.NO.getValue()));
        List stringsOrg = reqVo.getSfaWorkSignPersonnelReqVo().stream().map(SfaWorkSignPersonnelVo::getWspCode).collect(Collectors.toList());
        ArrayList listOrg = Lists.newArrayList();
        List partition = Lists.partition(stringsOrg, (int)999);
        for (List strings : partition) {
            listOrg.addAll(this.iSfaWorkSignPersonnelService.list((Wrapper)Wrappers.lambdaQuery(SfaWorkSignPersonnelEntity.class).select(new SFunction[]{BaseIdEntity::getId, SfaWorkSignPersonnelEntity::getRuleCode}).in(SfaWorkSignPersonnelEntity::getWspCode, (Collection)strings)));
        }
        if (CollectionUtil.listEmpty((List)listOrg)) {
            return;
        }
        Set stringsRuleCode = listOrg.stream().map(SfaWorkSignPersonnelEntity::getRuleCode).collect(Collectors.toSet());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(SfaWorkSignRuleEntity.class);
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getId())) {
            queryWrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        if (CollectionUtil.listEmpty((List)(ruleEntities = this.list((Wrapper)((LambdaQueryWrapper)queryWrapper.eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).in(SfaWorkSignRuleEntity::getRuleCode, stringsRuleCode))))) {
            return;
        }
        Set stringsRuleCodeNew = ruleEntities.stream().map(SfaWorkSignRuleEntity::getRuleCode).collect(Collectors.toSet());
        if (CollectionUtil.listNotEmpty((List)reqVo.getSfaWorkSignPersonnelPosReqVo())) {
            List stringsPos = reqVo.getSfaWorkSignPersonnelPosReqVo().stream().map(SfaWorkSignPersonnelVo::getWspCode).collect(Collectors.toList());
            ArrayList personnelEntities = Lists.newArrayList();
            List partitionPos = Lists.partition(stringsPos, (int)999);
            for (List strings : partitionPos) {
                personnelEntities.addAll(this.iSfaWorkSignPersonnelService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignPersonnelEntity.class).select(new SFunction[]{BaseIdEntity::getId, SfaWorkSignPersonnelEntity::getRuleCode}).in(SfaWorkSignPersonnelEntity::getWspCode, (Collection)strings)).eq(SfaWorkSignPersonnelEntity::getCodeType, (Object)WorkSignEnum.codeType.POS_LEVEL.getVal())).in(SfaWorkSignPersonnelEntity::getRuleCode, stringsRuleCodeNew)));
            }
            if (CollectionUtil.listNotEmpty((List)personnelEntities)) {
                throw new BusinessException("\u804c\u4f4d\u91cd\u590d\u6dfb\u52a0:\u89c4\u5219\u51b2\u7a81\u2014\u2014 \u89c4\u5219\u7f16\u7801\uff1a" + ((SfaWorkSignPersonnelEntity)((Object)personnelEntities.get(0))).getRuleCode());
            }
        } else {
            Set ruleCodeCollect = ruleEntities.stream().map(SfaWorkSignRuleEntity::getRuleCode).collect(Collectors.toSet());
            List personnelEntities = this.iSfaWorkSignPersonnelService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignPersonnelEntity.class).in(SfaWorkSignPersonnelEntity::getRuleCode, ruleCodeCollect)).eq(SfaWorkSignPersonnelEntity::getCodeType, (Object)WorkSignEnum.codeType.POS_LEVEL.getVal()));
            Set posLevelString = personnelEntities.stream().map(SfaWorkSignPersonnelEntity::getRuleCode).collect(Collectors.toSet());
            List collect = ruleCodeCollect.stream().filter(data -> !posLevelString.contains(data)).collect(Collectors.toList());
            if (CollectionUtil.listNotEmpty(collect)) {
                throw new BusinessException("\u7ec4\u7ec7\u51b2\u7a81\u7684\u89c4\u5219\u7f16\u7801\uff1a" + (String)collect.get(0) + "\u5df2\u7ecf\u5b58\u5728");
            }
        }
    }

    private void checkSpecialDate(List<SfaWorkSignSpecialReqVo> sfaWorkSignSpecialReqVos) {
        if (org.springframework.util.CollectionUtils.isEmpty(sfaWorkSignSpecialReqVos)) {
            return;
        }
        for (SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo : sfaWorkSignSpecialReqVos) {
            if (StringUtils.isBlank((CharSequence)sfaWorkSignSpecialReqVo.getWssDate())) {
                throw new BusinessException("\u8bf7\u9009\u62e9\u7279\u6b8a\u65e5\u671f");
            }
            try {
                LocalDate.parse(sfaWorkSignSpecialReqVo.getWssDate());
            }
            catch (Exception e) {
                throw new BusinessException("\u975e\u6cd5\u7684\u7279\u6b8a\u65e5\u671f\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Throwable)e);
            }
        }
    }

    public void checkDataExist(SfaWorkSignRuleReqVo reqVo) {
        SfaWorkSignRuleEntity entity;
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSignRuleEntity::getRuleName, (Object)reqVo.getRuleName());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        if (null != (entity = (SfaWorkSignRuleEntity)((Object)this.sfaWorkSignRuleMapper.selectOne((Wrapper)wrapper)))) {
            throw new BusinessException("\u5df2\u5b58\u5728\u8003\u52e4\u89c4\u5219[" + reqVo.getRuleName() + "]");
        }
    }

    @Override
    @Transactional
    public void executeWorkSignRule(SfaWorkSignExecuteReqVo reqVo) {
        LambdaQueryWrapper wrappers = Wrappers.lambdaQuery(SfaWorkSignRuleEntity.class);
        List rules = this.sfaWorkSignRuleMapper.selectList((Wrapper)(wrappers = (LambdaQueryWrapper)((LambdaQueryWrapper)wrappers.eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmEnableStatusEnum.ENABLE.getCode())));
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)rules)) {
            log.warn("\u6267\u884c\u8003\u52e4\u89c4\u5219:\u65e0\u53ef\u6267\u884c\u7684\u89c4\u5219");
            throw new BusinessException("\u65e0\u53ef\u6267\u884c\u7684\u89c4\u5219");
        }
        this.resolveSignRule(reqVo, rules);
    }

    protected void resolveSignRule(SfaWorkSignExecuteReqVo reqVoTemp, List<SfaWorkSignRuleEntity> rules) {
        ExecuteSignRuleContext contextOfBase = new ExecuteSignRuleContext(rules);
        LocalDate localDate = this.buildBaseContext(contextOfBase, reqVoTemp);
        ArrayList resolveThread = Lists.newArrayList();
        ArrayList contextOfThread = Lists.newArrayList();
        CountDownLatch countDownLatch = new CountDownLatch(7);
        for (int i = 0; i < 7; ++i) {
            localDate = localDate.plusDays(1L);
            String executeDate = localDate.format(CrmDateUtils.yyyyMMdd);
            SfaWorkSignExecuteReqVo reqVo = (SfaWorkSignExecuteReqVo)CrmBeanUtil.copy((Object)reqVoTemp, SfaWorkSignExecuteReqVo.class);
            reqVo.setExecuteDate(executeDate);
            ExecuteSignRuleContext context = contextOfBase.cloneContext();
            context.setSignDate(executeDate);
            contextOfThread.add(context);
            resolveThread.add(new Thread(() -> {
                try {
                    log.warn("###############################" + Thread.currentThread().getName() + "\uff1a\u5f00\u59cb\u89e3\u6790\u89c4\u5219 ###############################");
                    UserUtils.setToken((String)reqVo.getToken());
                    this.resolveInfoAndRecord(context);
                    log.warn("###############################" + Thread.currentThread().getName() + "\uff1a\u7ed3\u675f\u89e3\u6790\u89c4\u5219 ###############################");
                }
                catch (Exception e) {
                    context.setStatus(false);
                    log.error(Thread.currentThread().getName() + "\uff1a\u89e3\u6790\u5931\u8d25\uff01", (Throwable)e);
                    throw e;
                }
                finally {
                    countDownLatch.countDown();
                }
            }, "\u89e3\u6790[" + executeDate + "]"));
        }
        resolveThread.forEach(thread -> thread.start());
        this.saveSignRuleInfo(contextOfBase, contextOfThread, countDownLatch);
    }

    protected LocalDate buildBaseContext(ExecuteSignRuleContext contextOfBase, SfaWorkSignExecuteReqVo reqVoTemp) {
        String token = UserUtils.getToken();
        if (StringUtils.isBlank((CharSequence)token)) {
            UserUtils.doTokenForNull();
            token = UserUtils.getToken();
        }
        reqVoTemp.setToken(token);
        String executeDateTemp = reqVoTemp.getExecuteDate();
        if (StringUtils.isBlank((CharSequence)executeDateTemp)) {
            executeDateTemp = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        }
        CrmDateUtils.checkTimeFormatThrows((String)executeDateTemp, (DateTimeFormatter)CrmDateUtils.yyyyMMdd, (String)"\u521b\u5efa\u8003\u52e4\u660e\u7ec6\u89e3\u6790\u7ebf\u7a0b\u5931\u8d25\uff0c\u975e\u6cd5\u7684\u65e5\u671f\u683c\u5f0f\uff01");
        LocalDate localDate = LocalDate.parse(executeDateTemp, CrmDateUtils.yyyyMMdd);
        localDate = localDate.plusDays(-1L);
        contextOfBase.setSignDate(executeDateTemp);
        this.loadContextData(contextOfBase);
        return localDate;
    }

    protected void saveSignRuleInfo(ExecuteSignRuleContext contextOfBase, List<ExecuteSignRuleContext> contextOfThread, CountDownLatch countDownLatch) {
        try {
            countDownLatch.await();
            ArrayList ruleInfoEntities = Lists.newArrayList();
            ArrayList recordEntities = Lists.newArrayList();
            contextOfThread.forEach(v -> {
                if (v.getStatus().booleanValue()) {
                    ruleInfoEntities.addAll(v.getRuleInfoEntities());
                    recordEntities.addAll(v.getRecordEntities());
                }
            });
            contextOfBase.setRuleInfoEntities(ruleInfoEntities);
            contextOfBase.setRecordEntities(recordEntities);
            this.signRuleResolveHelper.saveSignRuleInfo(contextOfBase.getSignDate(), contextOfBase);
        }
        catch (InterruptedException e) {
            log.error("\u4fdd\u5b58\u5931\u8d25\uff01", (Throwable)e);
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25!", (Throwable)e);
        }
    }

    @Override
    @Transactional
    public void executeWorkSignRule(ExecuteWorkSignRuleVo executeWorkSignRuleVo) {
        List<SfaWorkSignRuleEntity> sfaWorkSignRuleEntities = this.sfaWorkSignRuleUtil.getAllRule();
        if (CollectionUtil.listEmpty(sfaWorkSignRuleEntities)) {
            return;
        }
        for (String userName : executeWorkSignRuleVo.getUserNames()) {
            this.executeWorkSignRule(sfaWorkSignRuleEntities, userName, executeWorkSignRuleVo.getExecuteDate());
        }
    }

    @Transactional
    public void executeWorkSignRule(List<SfaWorkSignRuleEntity> sfaWorkSignRuleEntities, String userName, String executeDate) {
        SfaWorkSignRuleInfoEntity oldEntity = this.sfaWorkSignRuleInfoUtil.getObj(userName, executeDate);
        if (oldEntity != null) {
            return;
        }
        List mdmPositionRespVos = PositionUtil.getAllPositionByUsername((String)userName);
        for (SfaWorkSignRuleEntity rule : sfaWorkSignRuleEntities) {
            boolean executeFlag = this.sfaWorkSignRuleUtil.checkPositionLevel(rule);
            executeFlag = executeFlag ? this.sfaWorkSignRuleUtil.checkPositionLevel(rule, mdmPositionRespVos) : true;
            executeFlag = executeFlag ? this.sfaWorkSignRuleUtil.checkPositionOrg(rule, mdmPositionRespVos) : false;
            boolean bl = executeFlag = executeFlag ? this.sfaWorkSignRuleUtil.checkMust(rule, executeDate) : false;
            if (!executeFlag) continue;
            SfaWorkSignRuleInfoEntity infoEntity = this.buildAndSaveSignRuleInfo(rule, userName, executeDate);
            this.sfaWorkSignRuleInfoUtil.setObj(infoEntity, this.sfaWorkSignRuleInfoUtil.getKey(userName, executeDate));
        }
    }

    @Override
    public SfaWorkSignRuleRespVo getSignRuleByOrgCode(String orgCode) {
        List tempRules = this.sfaWorkSignRuleMapper.selectList((Wrapper)Wrappers.lambdaQuery(SfaWorkSignRuleEntity.class).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        if (tempRules == null || tempRules.size() == 0) {
            throw new BusinessException("\u5f53\u524d\u65e0\u53ef\u6267\u884c\u7684\u8003\u52e4\u89c4\u5219");
        }
        Map<String, List<SfaWorkSignPersonnelEntity>> personnelEntityMap = this.iSfaWorkSignPersonnelService.selectMappingByRuleCodes(tempRules.stream().map(SfaWorkSignRuleEntity::getRuleCode).collect(Collectors.toSet()));
        Map<String, ExecuteSignRuleContext.OrgToRule> orgToRuleMap = this.getOrgToRuleMap(personnelEntityMap);
        ExecuteSignRuleContext.OrgToRule orgToRule = orgToRuleMap.get(orgCode);
        if (orgToRule == null) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u7ec4\u7ec7\u672a\u914d\u7f6e\u8003\u52e4\u89c4\u5219");
        }
        SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo = new SfaWorkSignRuleReqVo();
        sfaWorkSignRuleReqVo.setRuleCode(orgToRule.getRuleCode());
        SfaWorkSignRuleRespVo ruleRespVo = this.query(sfaWorkSignRuleReqVo);
        if (ruleRespVo == null) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u7ec4\u7ec7\u672a\u914d\u7f6e\u8003\u52e4\u89c4\u5219");
        }
        return ruleRespVo;
    }

    @Override
    @Transactional
    public SfaWorkSignRuleInfoEntity buildAndSaveSignRuleInfo(SfaWorkSignRuleEntity rule, String userName, String executeDate) {
        if (rule == null || StringUtils.isBlank((CharSequence)rule.getRuleCode()) || StringUtils.isBlank((CharSequence)userName)) {
            return null;
        }
        HashSet ruleCodes = Sets.newHashSet((Object[])new String[]{rule.getRuleCode()});
        SfaWorkSignRuleInfoEntity oldEntity = this.sfaWorkSignRuleInfoUtil.getObj(userName, executeDate);
        if (oldEntity != null) {
            return oldEntity;
        }
        SfaWorkSignRuleInfoEntity entity = new SfaWorkSignRuleInfoEntity();
        entity.setUserName(userName);
        entity.setRuleCode(rule.getRuleCode());
        entity.setRuleName(rule.getRuleName());
        entity.setRuleType(rule.getRuleType());
        entity.setRuleDate(executeDate);
        ValidateUtils.isTrue((boolean)Pattern.compile("^\\d{4}\\-\\d{2}\\-\\d{2}$").matcher(executeDate).matches(), (String)"\u8003\u52e4\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e", (Object[])new Object[0]);
        entity.setRuleYear(executeDate.substring(0, 4));
        entity.setRuleMonth(executeDate.substring(5, 7));
        entity.setRuleYearMonth(executeDate.substring(0, 7));
        entity.setNonWorkingDaySignAstrict(rule.getNonWorkingDaySignAstrict());
        entity.setElectronFence(rule.getElectronFence());
        entity.setWsrPhotograph(rule.getWsrPhotograph());
        boolean holiday = this.dateService.isHoliday(executeDate);
        entity.setSignMust(holiday ? CommonConstant.GLOBAL.YesOrNo.N.getItemCode() : CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)rule.getWorkingDay()) && rule.getWorkingDay().contains(DateUtil.getWeek((String)executeDate))) {
            entity.setSignOrNonType(WorkSignEnum.signOrNonType.WORKDAY_SIGN.getValue());
        } else {
            entity.setSignOrNonType(WorkSignEnum.signOrNonType.SPECIAL_DAY_SIGN.getValue());
        }
        this.iSfaWorkSignRuleInfoService.save((Object)entity);
        List<SfaWorkSignRecordEntity> recordEntities = this.packageRecords(entity, rule);
        this.iSfaWorkSignRecordService.saveBatch(recordEntities);
        entity.setSfaWorkSignRecords(recordEntities);
        return entity;
    }

    private List<SfaWorkSignRecordEntity> packageRecords(SfaWorkSignRuleInfoEntity entity, SfaWorkSignRuleEntity rule) {
        if (entity == null) {
            return Lists.newArrayList();
        }
        List<SfaWorkSignTimeEntity> signTimeEntities = this.iSfaWorkSignTimeService.findByRuleCode(entity.getRuleCode());
        ArrayList recordEntities = Lists.newArrayList();
        for (SfaWorkSignTimeEntity time : signTimeEntities) {
            SfaWorkSignRecordEntity start = new SfaWorkSignRecordEntity();
            start.setWsRuleInfoId(entity.getId());
            start.setWorkSignType(SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal());
            start.setWorkSignDesc(SfaWorkSignEnum.WorkSignType.CLOCK_IN.getDesc());
            start.setSfaSignTimeId(time.getId());
            start.setSfaSignTimeBegin(time.getGotoStartTime());
            start.setSfaSignTimeEnd(time.getGotoEndTime());
            start.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.NONE.getVal());
            start.setWsUserName(entity.getUserName());
            recordEntities.add(start);
            SfaWorkSignRecordEntity end = new SfaWorkSignRecordEntity();
            end.setWsRuleInfoId(entity.getId());
            end.setWorkSignType(SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getVal());
            end.setWorkSignDesc(SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getDesc());
            end.setSfaSignTimeId(time.getId());
            end.setSfaSignTimeBegin(time.getGooffStartTime());
            end.setSfaSignTimeEnd(time.getGooffEndTime());
            end.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.NONE.getVal());
            end.setWsUserName(entity.getUserName());
            recordEntities.add(end);
        }
        return recordEntities;
    }

    protected void buildRuleInfoAndRecord(ExecuteSignRuleContext context, SfaWorkSignRuleEntity entity, MdmOrgWithPositionRespVo mdmOrgWithPositionRespVo, boolean holiday, Map<String, List<SfaWorkSignPersonnelEntity>> posLevelListMap) {
        if (null == mdmOrgWithPositionRespVo) {
            return;
        }
        List positionRespVos = mdmOrgWithPositionRespVo.getPositionList();
        if (CollectionUtil.listEmpty((List)positionRespVos)) {
            return;
        }
        String orgCode = mdmOrgWithPositionRespVo.getOrgCode();
        context.setOrgCodeNow(orgCode);
        context.setOrgNameNow(mdmOrgWithPositionRespVo.getOrgName());
        MdmOrgRespVo parentOrg = OrgUtil.getOrgByCode((String)orgCode);
        if (null != parentOrg) {
            context.setParentOrgCodeNow(parentOrg.getParentCode());
            context.setParentOrgNameNow(parentOrg.getParentName());
        }
        for (MdmPositionUserOrgRespVo positionRespVo : positionRespVos) {
            ExecuteSignRuleContext.OrgToRule rule;
            if (!context.addUser(positionRespVo.getUserName())) {
                log.warn("\u8003\u52e4\u89c4\u5219\u4efb\u52a1\u8ba1\u7b97\uff1a\u5ffd\u7565\u5df2\u88ab\u5176\u4ed6\u89c4\u5219\u8ba1\u7b97\u8fc7\u6216\u65e0\u6cd5\u8bc6\u522b\u7684\u7528\u6237 user={}", (Object)positionRespVo.getUserName());
                continue;
            }
            Map<String, ExecuteSignRuleContext.OrgToRule> levelToRuleMap = context.getOrgAndPosLevelToRuleMap();
            if (CollectionUtil.mapNotEmpty(levelToRuleMap) && (rule = levelToRuleMap.get(positionRespVo.getOrgCode() + positionRespVo.getPositionLevelCode())) != null) {
                String ruleCode2 = rule.getRuleCode();
                entity = context.getRuleEntityMap().get(ruleCode2);
            }
            List<SfaWorkSignTimeEntity> sfaWorkSignTimeEntities = context.getTimeMapping().get(entity.getRuleCode());
            List<SfaWorkSignPersonnelEntity> workSignPersonnelEntities = posLevelListMap.get(entity.getRuleCode());
            List stringsPos = null;
            if (CollectionUtil.listNotEmpty(workSignPersonnelEntities)) {
                stringsPos = workSignPersonnelEntities.stream().map(SfaWorkSignPersonnelEntity::getWspCode).collect(Collectors.toList());
            }
            if (stringsPos != null && !stringsPos.contains(positionRespVo.getPositionLevelCode())) continue;
            SfaWorkSignRuleInfoEntity infoEntity = SfaWorkSignRuleInfoEntity.buildRuleInfoEntity(context, entity, positionRespVo);
            this.setSignMust(infoEntity, context.getSignDate(), context.getSpecialMapping().get(entity.getRuleCode()), holiday, entity.getWorkingDay());
            context.addRuleInfo(infoEntity);
            for (SfaWorkSignTimeEntity sfaWorkSignTimeEntity : sfaWorkSignTimeEntities) {
                context.addRecord(SfaWorkSignRecordEntity.buildClockInOut(infoEntity, sfaWorkSignTimeEntity));
            }
        }
    }

    private void setSignMust(SfaWorkSignRuleInfoEntity infoEntity, String signDate, List<SfaWorkSignSpecialEntity> specialEntityList, boolean holiday, String workingDay) {
        int weekNo;
        if (holiday) {
            infoEntity.setSignMust(YesNoEnum.yesNoEnum.NO.getValue());
            infoEntity.setSignOrNonType(WorkSignEnum.signOrNonType.HOLIDAY_NO_SIGN.getValue());
            return;
        }
        if (specialEntityList != null && specialEntityList.size() > 0) {
            for (SfaWorkSignSpecialEntity specialEntity : specialEntityList) {
                if (!signDate.equals(specialEntity.getWssDate())) continue;
                if (YesNoEnum.yesNoEnum.ONE.getValue().equals(specialEntity.getWssType())) {
                    infoEntity.setSignMust(YesNoEnum.yesNoEnum.YES.getValue());
                    infoEntity.setSignOrNonType(WorkSignEnum.signOrNonType.SPECIAL_DAY_SIGN.getValue());
                    return;
                }
                infoEntity.setSignOrNonType(WorkSignEnum.signOrNonType.SPECIAL_DAY_NO_SIGN.getValue());
                break;
            }
        }
        if (workingDay.indexOf((weekNo = LocalDate.now().getDayOfWeek().getValue()) + "") > -1) {
            infoEntity.setSignMust(YesNoEnum.yesNoEnum.YES.getValue());
            if (StringUtils.isEmpty((CharSequence)infoEntity.getSignOrNonType())) {
                infoEntity.setSignOrNonType(WorkSignEnum.signOrNonType.WORKDAY_SIGN.getValue());
            }
        } else {
            infoEntity.setSignMust(YesNoEnum.yesNoEnum.NO.getValue());
            if (StringUtils.isEmpty((CharSequence)infoEntity.getSignOrNonType())) {
                infoEntity.setSignOrNonType(WorkSignEnum.signOrNonType.WORK_DAY_NO_SIGN.getValue());
            }
        }
    }

    private void loadContextData(ExecuteSignRuleContext context) {
        Set<String> ruleCodes = context.getRuleCodes();
        log.info("\u89c4\u5219\u8003\u52e4\u5730\u70b9\u914d\u7f6e");
        context.setPlaceMapping(this.iSfaWorkSignPlaceService.selectMappingByRuleCodes(ruleCodes));
        log.info("\u89c4\u5219\u8003\u52e4\u65f6\u95f4\u914d\u7f6e");
        context.setTimeMapping(this.iSfaWorkSignTimeService.selectMappingByRuleCodes(ruleCodes));
        log.info("\u89c4\u5219\u8003\u52e4\u7279\u6b8a\u65f6\u95f4\u914d\u7f6e");
        context.setSpecialMapping(this.iSfaWorkSignSpecialService.selectMappingByRuleCodes(ruleCodes));
        log.info("\u89c4\u5219\u8003\u52e4\u7ec4\u7ec7\u914d\u7f6e");
        context.setPersonnelMapping(this.iSfaWorkSignPersonnelService.selectMappingByRuleCodes(ruleCodes));
        log.info("\u6839\u636e\u7ec4\u7ec7\u6811\uff0c\u8bbe\u7f6e\u89c4\u5219\u5bf9\u5e94\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u5bf9\u5e94\u7684\u89c4\u5219\u4fe1\u606f");
        Map<String, ExecuteSignRuleContext.OrgToRule> orgToRuleMap = this.getOrgToRuleMap(context.getPersonnelMapping());
        context.setOrgToRuleMap(orgToRuleMap);
        log.info("\u89c4\u5219\u8003\u52e4\u804c\u4f4d\u7ea7\u522b");
        Map<String, List<SfaWorkSignPersonnelEntity>> posLevelListMap = this.iSfaWorkSignPersonnelService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignPersonnelEntity.class).in(SfaWorkSignPersonnelEntity::getRuleCode, ruleCodes)).eq(SfaWorkSignPersonnelEntity::getCodeType, (Object)WorkSignEnum.codeType.POS_LEVEL.getVal())).stream().collect(Collectors.groupingBy(SfaWorkSignPersonnelEntity::getRuleCode));
        context.setPosLevelListMap(posLevelListMap);
        log.info("\u8bbe\u7f6e\u89c4\u5219\u5bf9\u5e94\u7ec4\u7ec7\u548c\u804c\u4f4d\u7ea7\u522b\u7684\u89c4\u5219\u4fe1\u606f");
        if (CollectionUtil.mapNotEmpty(posLevelListMap)) {
            HashMap<String, ExecuteSignRuleContext.OrgToRule> orgAndPosLevelToRuleMap = new HashMap();
            orgAndPosLevelToRuleMap = this.getOrgAndPosLevelToRuleMap(context.getPersonnelMapping(), posLevelListMap);
            context.setOrgAndPosLevelToRuleMap(orgAndPosLevelToRuleMap);
        }
        HashMap<String, MdmOrgWithPositionRespVo> orgPositionMappingCurrentY = new HashMap<String, MdmOrgWithPositionRespVo>();
        ArrayList<String> map = new ArrayList<String>(context.getOrgToRuleMap().keySet());
        List orgCodes = CollectionUtil.groupListByQuantity(map, (int)10);
        for (List codes : orgCodes) {
            log.info("\u5faa\u73af\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u7684\u804c\u4f4d\u548c\u7528\u6237\u4fe1\u606f-\u5f53\u524d\u7ec4\u7ec7==>" + codes);
            List mdmOrgWithPositionRespVos = (List)ApiResultUtil.objResult((Result)this.mdmOrgFeign.findOrgWithSinglePositionList(codes), (boolean)true);
            Map<String, MdmOrgWithPositionRespVo> tempMap = mdmOrgWithPositionRespVos.stream().collect(Collectors.toMap(MdmOrgWithPositionRespVo::getOrgCode, v -> {
                v.setPositionList(this.filterPrimary(v.getPositionList()));
                return v;
            }, (v1, v2) -> v1));
            orgPositionMappingCurrentY.putAll(tempMap);
        }
        context.setOrgPositionMappingCurrentY(orgPositionMappingCurrentY);
    }

    protected void resolveInfoAndRecord(ExecuteSignRuleContext context) {
        log.info("\u5224\u65ad\u662f\u5426\u6cd5\u5b9a\u8282\u5047\u65e5");
        boolean holiday = this.dateService.isHoliday(context.getSignDate());
        log.info("\u904d\u5386\u7ec4\u7ec7\u5bf9\u5e94\u89c4\u5219\u4fe1\u606f\uff0c\u751f\u6210\u8003\u52e4\u8bb0\u5f55\u548c\u8be6\u60c5");
        for (String orgCode : context.getOrgToRuleMap().keySet()) {
            ExecuteSignRuleContext.OrgToRule orgToRule = context.getOrgToRuleMap().get(orgCode);
            MdmOrgWithPositionRespVo positionRespVos = context.getOrgPositionMappingCurrentY().get(orgCode);
            this.buildRuleInfoAndRecord(context, context.getRuleEntityMap().get(orgToRule.getRuleCode()), positionRespVos, holiday, context.getPosLevelListMap());
        }
    }

    public Map<String, ExecuteSignRuleContext.OrgToRule> getOrgToRuleMap(Map<String, List<SfaWorkSignPersonnelEntity>> personnelMapping) {
        List treeList = (List)ApiResultUtil.objResult((Result)this.mdmOrgFeign.getOrgTree(), (boolean)true);
        HashMap<String, ExecuteSignRuleContext.OrgToRule> orgToRuleMap = new HashMap<String, ExecuteSignRuleContext.OrgToRule>();
        personnelMapping.forEach((k, v) -> v.forEach(vo -> this.findOrg(treeList, (SfaWorkSignPersonnelEntity)((Object)((Object)vo)), (String)k, (Map<String, ExecuteSignRuleContext.OrgToRule>)orgToRuleMap)));
        return orgToRuleMap;
    }

    public Map<String, ExecuteSignRuleContext.OrgToRule> getOrgAndPosLevelToRuleMap(Map<String, List<SfaWorkSignPersonnelEntity>> personnelMapping, Map<String, List<SfaWorkSignPersonnelEntity>> posLevelListMap) {
        HashMap<String, ExecuteSignRuleContext.OrgToRule> orgAndPosLevelToRuleMap = new HashMap<String, ExecuteSignRuleContext.OrgToRule>();
        personnelMapping.forEach((k, v) -> v.forEach(data -> {
            List sfaWorkSignPersonnelEntities = (List)posLevelListMap.get(k);
            if (CollectionUtil.listNotEmpty((List)sfaWorkSignPersonnelEntities)) {
                sfaWorkSignPersonnelEntities.forEach(item -> orgAndPosLevelToRuleMap.put(data.getWspCode() + item.getWspCode(), new ExecuteSignRuleContext.OrgToRule(0, item.getRuleCode())));
            }
        }));
        return orgAndPosLevelToRuleMap;
    }

    private void findOrg(List<MdmOrgTreeRespVo> treeList, SfaWorkSignPersonnelEntity personnelEntity, String ruleCode2, Map<String, ExecuteSignRuleContext.OrgToRule> orgToRuleMap) {
        for (MdmOrgTreeRespVo vo : treeList) {
            if (vo.getOrgCode().equals(personnelEntity.getWspCode())) {
                orgToRuleMap.put(personnelEntity.getWspCode(), new ExecuteSignRuleContext.OrgToRule(0, ruleCode2));
                if (!CollectionUtils.isNotEmpty((Collection)vo.getChildren())) break;
                this.setOrgToRuleMap(vo.getChildren(), 1, ruleCode2, orgToRuleMap);
                break;
            }
            if (!CollectionUtils.isNotEmpty((Collection)vo.getChildren())) continue;
            this.findOrg(vo.getChildren(), personnelEntity, ruleCode2, orgToRuleMap);
        }
    }

    private void setOrgToRuleMap(List<MdmOrgTreeRespVo> treeList, Integer leave, String ruleCode2, Map<String, ExecuteSignRuleContext.OrgToRule> orgToRuleMap) {
        for (MdmOrgTreeRespVo vo : treeList) {
            ExecuteSignRuleContext.OrgToRule orgToRule = orgToRuleMap.get(vo.getOrgCode());
            if (orgToRule != null && orgToRule.getLeave() < leave) continue;
            orgToRuleMap.put(vo.getOrgCode(), new ExecuteSignRuleContext.OrgToRule(leave, ruleCode2));
            if (!CollectionUtils.isNotEmpty((Collection)vo.getChildren())) continue;
            this.setOrgToRuleMap(vo.getChildren(), leave + 1, ruleCode2, orgToRuleMap);
        }
    }

    private List<MdmPositionUserOrgRespVo> filterPrimary(List<MdmPositionUserOrgRespVo> positionRespVos) {
        if (null == positionRespVos) {
            return Lists.newArrayList();
        }
        return positionRespVos.stream().filter(v -> YesNoEnum.yesNoEnum.ONE.getValue().equals(v.getPrimaryFlag())).collect(Collectors.toList());
    }
}

