package com.biz.crm.eunm.sfa;

/**
 * @author ren.gang
 * @ClassName WorkSignEnum.java
 * @Description 考勤规则枚举
 * @createTime 2020年11月30日 17:07:00
 */
public class WorkSignEnum {

    /**
     * 打卡或不打卡类型
     */
    public enum signOrNonType{
        WORKDAY_SIGN("10", "工作日打卡"),
        SPECIAL_DAY_SIGN("11", "特殊日期打卡"),
        WORK_DAY_NO_SIGN("20", "非工作日不打卡"),
        SPECIAL_DAY_NO_SIGN("21","特殊日期不打卡"),
        HOLIDAY_NO_SIGN("22", "节假日不打卡");

        private String value;
        private String des;
        signOrNonType(String value, String des) {
            this.value = value;
            this.des = des;
        }

        public String getValue() {
            return value;
        }

        public String getDes() {
            return des;
        }
    }

    /**
     * 考勤相关申请类型
     */
    public enum signApplyType {
        LEAVE("leave", "请假")
        ,EXCEPTION("exception", "异常报备")
        ;
        private String value;
        private String des;
        signApplyType(String value, String des) {
            this.value = value;
            this.des = des;
        }

        public String getValue() {
            return value;
        }

        public String getDes() {
            return des;
        }
    }
}
