package com.biz.crm.eunm.mdm;

/**
 * 登录类型
 */
public enum LoginFromTypeEnum {

    CONSOLE("console", "后台"),
    APPLET_SFA("applet_sfa", "sfa小程序"),
    APPLET_DMS("applet_dms", "dms小程序"),
    APP_DMS("app_dms", "dmsAPP"),
    APP_SFA("app_sfa", "sfaAPP"),
    WEB_DMS("web_dms", "dms商城"),
    CRONTAB("crontab", "定时任务"),
    UNKNOWN("unknown", "未知来源"),
    ;

    private String value;
    private String desc;

    public static LoginFromTypeEnum getEnum(String value) {
        if (value != null && !"".equals(value)) {
            for (LoginFromTypeEnum item :
                    LoginFromTypeEnum.values()) {
                if (value.equals(item.getValue())) {
                    return item;
                }
            }
        }
        return null;
    }

    public static String getDesc(String value) {
        LoginFromTypeEnum anEnum = getEnum(value);
        if (anEnum != null) {
            return anEnum.getDesc();
        }
        return null;
    }

    LoginFromTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
