package com.biz.crm.eunm.sfa;

/**
 * 积分管理相关枚举
 * @author YuanZiJian
 * @date 2021/1/11 15:10
 * @version: V1.0
 */
public class IntegralEnum {

    /**
     * 积分规则——计算规则枚举类型
     */
    public enum taskType{
        SAVE_TERMINAL("save_terminal", "新增终端"),
        CLAIM_TERMINAL("claim_terminal", "认领终端"),
        INVENTORY_STOCK("inventory_stock", "库存盘点"),
        DAY_VISIT_PLAN("day_visit_plan","日拜访计划完成"),
        FINISH_VISIT_PLAN("finish_visit_plan", "拜访计划完成"),
        MONTH_SIGN("month_sign", "月考勤打卡完成"),
        YEAR_SIGN("year_sign", "年考勤打卡完成"),
        FINISH_ACTIVITY("finish_activity", "活动执行完成"),
        COLLECT_ORDER("collect_order", "订单采集"),
        COLLECT_PRODUCT("collect_product", "竞品采集"),
        PLANING_VISIT_PLAN("planing_visit_plan", "拜访计划制定"),
        PLANING_HELP_DEFENSE("planing_help_defense", "协访计划制定"),
        FINISH_DISPLAY("finish_display", "陈列任务完成");

        private String value;
        private String des;
        taskType(String value, String des) {
            this.value = value;
            this.des = des;
        }
        public String getValue() {
            return value;
        }

        public String getDes() {
            return des;
        }

    }

    public enum ruleType{
        POS_LEVEL("pos", "职位等级类型"),
        ORG("org", "组织类型");

        private String value;
        private String des;

        ruleType(String value, String des) {
            this.value = value;
            this.des = des;
        }
        public String getValue() {
            return value;
        }

        public String getDes() {
            return des;
        }
    }

    public enum ruleCode{
        INTEGRAL_RULE_CODE("integral_rule_code", "积分规则编码");

        private String value;
        private String des;

        ruleCode(String value, String des) {
            this.value = value;
            this.des = des;
        }
        public String getValue() {
            return value;
        }

        public String getDes() {
            return des;
        }
    }


    public enum orgSearchRange{
        NOW_ORG("now_org", "本部门"),
        ALL_ORG("all_org", "本公司"),
        AFTER_ORG("now_org_type", "当前组织及下级组织");

        private String value;
        private String des;

        orgSearchRange(String value, String des) {
            this.value = value;
            this.des = des;
        }
        public String getValue() {
            return value;
        }

        public String getDes() {
            return des;
        }
    }

}
