/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.service;

import com.biz.crm.service.UploadFileEventService;
import com.biz.crm.util.UploadConf;
import com.biz.crm.vo.DownLoadVo;
import com.biz.crm.vo.UploadVo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class UploadFileEventContext {
    private final Map<String, UploadFileEventService> map = new ConcurrentHashMap<String, UploadFileEventService>();
    @Resource
    private UploadConf uploadConf;

    @Autowired
    private UploadFileEventContext(List<UploadFileEventService> uploadFileEventServices) {
        uploadFileEventServices.forEach(x -> this.map.put(x.getType(), (UploadFileEventService)x));
    }

    public List<UploadVo> upload(MultipartFile[] fileList) {
        return this.map.get(this.uploadConf.getType()).upload(fileList);
    }

    public DownLoadVo download(String objectName) {
        return this.map.get(this.uploadConf.getType()).download(objectName);
    }
}

