/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.service.impl;

import com.biz.crm.entity.UploadFileEntity;
import com.biz.crm.service.UploadFileEventService;
import com.biz.crm.service.UploadFileService;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.MkdirUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UploadConf;
import com.biz.crm.vo.DownLoadVo;
import com.biz.crm.vo.UploadVo;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LocalUploadServiceImpl
implements UploadFileEventService {
    private static final Logger log = LoggerFactory.getLogger(LocalUploadServiceImpl.class);
    @Resource
    private UploadFileService uploadFileService;
    @Resource
    private UploadConf uploadConf;

    @Override
    public List<UploadVo> upload(MultipartFile[] fileList) {
        ArrayList<UploadVo> uploadVos = new ArrayList<UploadVo>();
        String localPath = this.uploadConf.getLocalPath();
        for (MultipartFile file : fileList) {
            String filePath = localPath;
            String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
            localPath = StringUtils.isEmpty((String)suffix) ? localPath + "default" + File.separator : localPath + suffix + File.separator;
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            String objectName = uuid + "." + suffix.toLowerCase();
            String dateFile = DateUtil.date2Str((SimpleDateFormat)new SimpleDateFormat("yyyyMMdd"));
            localPath = localPath + dateFile + File.separator;
            MkdirUtil.mkdir(localPath);
            String path = localPath + objectName;
            File dest = new File(path);
            String dirPath = path.substring(0, path.lastIndexOf("/") + 1);
            MkdirUtil.mkdir(dirPath);
            try {
                file.transferTo(dest);
                log.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u7edd\u5bf9\u8def\u5f84" + path);
                UploadVo uploadVo = new UploadVo();
                uploadVo.setUrl(path);
                uploadVo.setObjectName(objectName);
                uploadVo.setUrlPath(path);
                uploadVo.setFileName(file.getOriginalFilename());
                uploadVos.add(uploadVo);
            }
            catch (Exception e) {
                log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        return uploadVos;
    }

    @Override
    public DownLoadVo download(String objectName) {
        UploadFileEntity uploadFileEntity = this.uploadFileService.findByObjectName(objectName);
        Assert.notNull((Object)((Object)uploadFileEntity), (String)("\u6587\u4ef6[" + objectName + "]\u4e0d\u5b58\u5728"));
        return new DownLoadVo(uploadFileEntity.getFileName(), new FileSystemResource(uploadFileEntity.getFilePath()).getInputStream());
    }

    @Override
    public String getType() {
        return "local";
    }
}

