/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.entity.UploadFileEntity;
import com.biz.crm.mapper.UploadFileMapper;
import com.biz.crm.service.UploadFileEventContext;
import com.biz.crm.service.UploadFileService;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UploadConf;
import com.biz.crm.vo.DownLoadVo;
import com.biz.crm.vo.UploadVo;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(rollbackFor={Exception.class})
public class UploadFileServiceImpl
extends ServiceImpl<UploadFileMapper, UploadFileEntity>
implements UploadFileService {
    @Resource
    private UploadFileEventContext uploadFileEventContext;

    @Override
    public List<UploadVo> upload(MultipartFile[] fileList, UploadConf uploadConf) {
        this.valid(fileList);
        List<UploadVo> uploadVos = this.uploadFileEventContext.upload(fileList);
        this.uploadFileStore(uploadVos);
        return uploadVos;
    }

    private void valid(MultipartFile[] fileList) {
        if (fileList == null || fileList.length < 1) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u6587\u4ef6");
        }
        for (MultipartFile file : fileList) {
            if (file == null) {
                throw new BusinessException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String fileName = file.getName();
            if (StringUtils.isEmpty((String)fileName)) {
                throw new BusinessException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
            if (!suffix.equalsIgnoreCase("sh") && !suffix.equalsIgnoreCase("jsp") && !suffix.equalsIgnoreCase("html")) continue;
            throw new BusinessException("\u975e\u6cd5\u6587\u4ef6\u4e0a\u4f20");
        }
    }

    @Override
    public UploadFileEntity findByObjectName(String objectName) {
        Assert.hasText((String)objectName, (String)"\u5bf9\u8c61\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        UploadFileEntity one = (UploadFileEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UploadFileEntity::getObjectName, (Object)objectName)).one());
        Assert.notNull((Object)((Object)one), (String)("\u6587\u4ef6[" + objectName + "]\u4e0d\u5b58\u5728"));
        Assert.hasText((String)one.getFilePath(), (String)("\u6587\u4ef6[" + objectName + "]\u8def\u5f84\u4e0d\u5b58\u5728"));
        return one;
    }

    @Override
    public DownLoadVo download(String objectName) {
        return this.uploadFileEventContext.download(objectName);
    }

    private void uploadFileStore(List<UploadVo> uploadVos) {
        if (!CollectionUtils.isEmpty(uploadVos)) {
            List collect = uploadVos.stream().map(x -> new UploadFileEntity().setObjectName(x.getObjectName()).setFilePath(x.getUrl()).setFileName(x.getFileName())).collect(Collectors.toList());
            this.saveBatch(collect);
        }
    }
}

