/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.controller;

import com.biz.crm.service.UploadFileService;
import com.biz.crm.util.FileHttpDownload;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.vo.DownLoadVo;
import io.swagger.annotations.Api;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/downloadController"})
@Api(tags={"\u6587\u4ef6\u4e0b\u8f7d\u8def\u5f84 "})
public class DownLoadController {
    @Resource
    private UploadFileService uploadFileService;
    @Value(value="${server.tomcat.basedir}")
    private String PATH;

    @GetMapping(value={"/download"})
    public ResponseEntity<InputStreamResource> downloadFile(@RequestParam(value="objectName") String objectName) {
        DownLoadVo downLoadVo = this.uploadFileService.download(objectName);
        String fileName = downLoadVo.getFileName();
        if (!StringUtils.isEmpty((String)fileName)) {
            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentDispositionFormData("attachment", fileName);
        httpHeaders.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        return new ResponseEntity((Object)new InputStreamResource(downLoadVo.getInputStream()), (MultiValueMap)httpHeaders, HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/downloadExcelFile"})
    public void downloadExcelFile(@RequestParam(value="objectName") String objectName) {
        File file;
        String fileName;
        InputStream ins;
        block9: {
            OutputStream ous = null;
            ins = null;
            fileName = null;
            try {
                HttpServletResponse response = HttpServletRequestUtil.getResponse();
                DownLoadVo downLoadVo = this.uploadFileService.download(objectName);
                fileName = UUID.randomUUID().toString().replace("-", "") + downLoadVo.getFileName();
                FileHttpDownload.backDownLoadFileUrl(downLoadVo.getFilePath(), this.PATH, fileName);
                File file2 = new File(this.PATH + File.separator + fileName);
                ins = new BufferedInputStream(new FileInputStream(file2));
                byte[] buffer = new byte[ins.available()];
                ins.read(buffer);
                ins.close();
                response.reset();
                response.setHeader("Content-disposition", "attachment; filename=" + new String(downLoadVo.getFileName().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
                response.addHeader("Content-Length", String.valueOf(file2.length()));
                response.setContentType("application/octet-stream");
                ous = new BufferedOutputStream((OutputStream)response.getOutputStream());
                ous.write(buffer);
                ous.flush();
                ous.close();
                if (ous == null) break block9;
            }
            catch (Throwable throwable) {
                File file3;
                if (ous != null) {
                    ous.close();
                }
                if (ins != null) {
                    ins.close();
                }
                if ((file3 = new File(this.PATH + File.separator + fileName)).exists()) {
                    file3.delete();
                }
                throw throwable;
            }
            ous.close();
        }
        if (ins != null) {
            ins.close();
        }
        if ((file = new File(this.PATH + File.separator + fileName)).exists()) {
            file.delete();
        }
    }
}

