/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.entity.ExcelExportEntity;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.upload.UploadEnum;
import com.biz.crm.mapper.ExcelExportMapper;
import com.biz.crm.nebular.upload.excel.req.ExcelExportReqVo;
import com.biz.crm.nebular.upload.excel.resp.ExcelExportRespVo;
import com.biz.crm.service.IExcelExportService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"ExcelExportServiceExpandImpl"})
@Transactional
public class ExcelExportServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<ExcelExportMapper, ExcelExportEntity>
implements IExcelExportService {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportServiceImpl.class);
    @Resource
    private ExcelExportMapper excelExportMapper;

    @Override
    public PageResult<ExcelExportRespVo> findList(ExcelExportReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        UserRedis userRedis = UserUtils.getUser();
        if (!userRedis.getUsername().equals(UploadEnum.userName.ADMIN.getVal())) {
            reqVo.setOrgCode(userRedis.getOrgcode());
        }
        List<ExcelExportRespVo> list = this.excelExportMapper.findList((Page<ExcelExportRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public ExcelExportRespVo query(ExcelExportReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(ExcelExportReqVo reqVo) {
        UserRedis userRedis = UserUtils.getUser();
        if (StringUtils.isNotEmpty((String)reqVo.getUserName())) {
            reqVo.setUserName(userRedis.getUsername());
            reqVo.setRealName(userRedis.getRealname());
            reqVo.setPosCode(userRedis.getPoscode());
            reqVo.setPosName(userRedis.getPosname());
            reqVo.setOrgCode(userRedis.getOrgcode());
            reqVo.setOrgName(userRedis.getOrgname());
        }
        ExcelExportEntity entity = (ExcelExportEntity)((Object)CrmBeanUtil.copy((Object)reqVo, ExcelExportEntity.class));
        entity.setFileCode(CodeUtil.generateCode((String)CodeRuleEnum.UPLOAD_FILE_CODE.getCode()));
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)entity);
    }

    @Override
    public String saveExcelFileBackId(ExcelExportReqVo reqVo) {
        this.saveBackIdCheck(reqVo);
        UserRedis userRedis = UserUtils.getUser();
        if (!StringUtils.isNotEmpty((String)reqVo.getUserName())) {
            reqVo.setUserName(userRedis.getUsername());
            reqVo.setRealName(userRedis.getRealname());
            reqVo.setPosCode(userRedis.getPoscode());
            reqVo.setPosName(userRedis.getPosname());
            reqVo.setOrgCode(userRedis.getOrgcode());
            reqVo.setOrgName(userRedis.getOrgname());
        }
        ExcelExportEntity entity = (ExcelExportEntity)((Object)CrmBeanUtil.copy((Object)reqVo, ExcelExportEntity.class));
        entity.setFileCode(CodeUtil.generateCode((String)CodeRuleEnum.UPLOAD_FILE_CODE.getCode()));
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)entity);
        return entity.getId();
    }

    @Override
    public void updateExcelFileById(ExcelExportReqVo reqVo) {
        ExcelExportEntity entity = (ExcelExportEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (reqVo.getFileStatus().equals(UploadEnum.fileStatus.EXPORT_FAIL.getVal())) {
            entity.setFileStatus(reqVo.getFileStatus());
        } else {
            entity.setObjectName(reqVo.getObjectName());
            entity.setFileName(reqVo.getFileName());
            entity.setFilePath(reqVo.getFilePath());
            entity.setFileStatus(reqVo.getFileStatus());
            entity.setTimeSpent(reqVo.getTimeSpent());
        }
        this.saveOrUpdate((Object)entity);
    }

    private void saveBackIdCheck(ExcelExportReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getExcelFileName(), (String)"\u5bfc\u51fa\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getFileSource(), (String)"\u6587\u4ef6\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getFileParam(), (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getFileStatus(), (String)"\u6587\u4ef6\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getFileType(), (String)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(ExcelExportReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        ExcelExportEntity entity = (ExcelExportEntity)((Object)CrmBeanUtil.copy((Object)reqVo, ExcelExportEntity.class));
        this.excelExportMapper.updateById((Object)entity);
    }

    private void checkUpdate(ExcelExportReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getFileName(), (String)"\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getObjectName(), (String)"\u5bf9\u8c61\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getFilePath(), (String)"\u6587\u4ef6\u7edd\u5bf9\u8def\u7ecf\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getFileStatus(), (String)"\u6587\u4ef6\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(ExcelExportReqVo reqVo) {
        List excelExportEntities = this.excelExportMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)excelExportEntities)) {
            excelExportEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(excelExportEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(ExcelExportReqVo reqVo) {
        List excelExportEntities = this.excelExportMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)excelExportEntities)) {
            excelExportEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(excelExportEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(ExcelExportReqVo reqVo) {
        List excelExportEntities = this.excelExportMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)excelExportEntities)) {
            excelExportEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(excelExportEntities);
    }
}

