/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.upload.excel.req.ExcelExportReqVo;
import com.biz.crm.nebular.upload.excel.resp.ExcelExportRespVo;
import com.biz.crm.service.IExcelExportService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/excelExportController"})
@Api(tags={"\u5bfc\u51fa\u6587\u4ef6"})
public class ExcelExportController {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportController.class);
    @Autowired
    private IExcelExportService excelExportService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<ExcelExportRespVo>> list(@RequestBody ExcelExportReqVo excelExportReqVo) {
        PageResult<ExcelExportRespVo> result = this.excelExportService.findList(excelExportReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<ExcelExportRespVo> query(@RequestBody ExcelExportReqVo excelExportReqVo) {
        ExcelExportRespVo respVo = this.excelExportService.query(excelExportReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody ExcelExportReqVo excelExportReqVo) {
        this.excelExportService.save(excelExportReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u65b0\u589e\u5e76\u8fd4\u56deid")
    @PostMapping(value={"/saveExcelFileBackId"})
    @CrmLog
    public Result<ExcelExportReqVo> saveExcelFileBackId(@RequestBody ExcelExportReqVo reqVo) {
        this.excelExportService.saveExcelFileBackId(reqVo);
        Result result = new Result();
        result.setResult((Object)reqVo);
        return result;
    }

    @ApiOperation(value="\u66f4\u65b0excel\u6587\u4ef6\u901a\u8fc7id")
    @PostMapping(value={"/updateExcelFileById"})
    @CrmLog
    public Result updateExcelFileById(@RequestBody ExcelExportReqVo reqVo) {
        this.excelExportService.updateExcelFileById(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody ExcelExportReqVo excelExportReqVo) {
        this.excelExportService.update(excelExportReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody ExcelExportReqVo excelExportReqVo) {
        this.excelExportService.deleteBatch(excelExportReqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody ExcelExportReqVo excelExportReqVo) {
        this.excelExportService.enableBatch(excelExportReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody ExcelExportReqVo excelExportReqVo) {
        this.excelExportService.disableBatch(excelExportReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }
}

