/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.biz.crm.util.UploadConf;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class OssUploadUtil {
    private static final Logger log = LoggerFactory.getLogger(OssUploadUtil.class);

    public static String uploadOssByPath(String path, UploadConf oss) {
        String ossPath = null;
        try {
            File file = new File(path);
            FileInputStream inputStream = new FileInputStream(file);
            return OssUploadUtil.uploadOss(oss, UUID.randomUUID().toString().replaceAll("-", ""), inputStream);
        }
        catch (Exception e) {
            log.error("\u4e0a\u5e8aOSS\u5931\u8d25", (Throwable)e);
            return ossPath;
        }
    }

    public static String uploadOss(UploadConf oss, String objectName, InputStream inputStream) {
        return OssUploadUtil.doOss(oss, objectName, null, inputStream);
    }

    public static String uploadOss(UploadConf oss, String objectName, MultipartFile mf) {
        return OssUploadUtil.doOss(oss, objectName, mf, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doOss(UploadConf oss, String objectName, MultipartFile mf, InputStream inputStream) {
        String url = "";
        OSSClient ossClient = null;
        try {
            ossClient = new OSSClient(oss.getEndpoint(), oss.getAccessKeyId(), oss.getAccessKeySecret());
            if (mf != null) {
                inputStream = mf.getInputStream();
            }
            log.info("\u4e0a\u4f20\u6587\u4ef6\uff1a" + objectName);
            ossClient.putObject(oss.getBucketName(), objectName, inputStream);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff1a" + objectName);
            ossClient.shutdown();
            url = oss.getReq_url().concat("/").concat(objectName);
        }
        catch (ClientException | IOException e) {
            log.error(e.getMessage(), e);
        }
        catch (OSSException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doOss(UploadConf oss, String objectName, InputStream inputStream) {
        String url = "";
        OSSClient ossClient = null;
        try {
            ossClient = new OSSClient(oss.getEndpoint(), oss.getAccessKeyId(), oss.getAccessKeySecret());
            log.info("\u4e0a\u4f20\u6587\u4ef6\uff1a" + objectName);
            PutObjectRequest putObjectRequest = new PutObjectRequest(oss.getBucketName(), objectName, inputStream);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentType("image/jpg");
            log.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff1a" + objectName);
            putObjectRequest.setMetadata(metadata);
            ossClient.putObject(putObjectRequest);
            ossClient.shutdown();
            url = oss.getReq_url().concat("/").concat(objectName);
        }
        catch (ClientException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (OSSException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doOssType(UploadConf oss, String objectName, InputStream inputStream, String suffix) {
        String url = "";
        OSSClient ossClient = null;
        try {
            ossClient = new OSSClient(oss.getEndpoint(), oss.getAccessKeyId(), oss.getAccessKeySecret());
            PutObjectRequest putObjectRequest = new PutObjectRequest(oss.getBucketName(), objectName, inputStream);
            String contentType = OssUploadUtil.getContentType(suffix);
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentType(contentType);
                putObjectRequest.setMetadata(metadata);
            }
            log.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff1a" + objectName);
            ossClient.putObject(putObjectRequest);
            ossClient.shutdown();
            url = oss.getReq_url().concat("/").concat(objectName);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u540e\u8fd4\u56de\u5730\u5740:" + url);
        }
        catch (ClientException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:", (Object)objectName);
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (OSSException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:", (Object)objectName);
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doOss(UploadConf oss, String objectName, InputStream inputStream, String suffix) {
        String url = "";
        OSSClient ossClient = null;
        try {
            ossClient = new OSSClient(oss.getEndpoint(), oss.getAccessKeyId(), oss.getAccessKeySecret());
            log.info("\u4e0a\u4f20\u6587\u4ef6\uff1a" + objectName);
            PutObjectRequest putObjectRequest = new PutObjectRequest(oss.getBucketName(), objectName, inputStream);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff1a" + objectName);
            ossClient.putObject(putObjectRequest);
            ossClient.shutdown();
            url = oss.getReq_url().concat("/").concat(objectName);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u540e\u8fd4\u56de\u5730\u5740:" + url);
        }
        catch (ClientException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (OSSException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleOssObj(UploadConf oss, String objectName) {
        OSSClient ossClient = null;
        try {
            ossClient = new OSSClient(oss.getEndpoint(), oss.getAccessKeyId(), oss.getAccessKeySecret());
            ossClient.deleteObject(oss.getBucketName(), objectName);
        }
        catch (OSSException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ClientException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleOssObjBatch(UploadConf oss, List<String> keys) {
        OSSClient ossClient = null;
        try {
            ossClient = new OSSClient(oss.getEndpoint(), oss.getAccessKeyId(), oss.getAccessKeySecret());
            DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(new DeleteObjectsRequest(oss.getBucketName()).withKeys(keys));
            List list = deleteObjectsResult.getDeletedObjects();
        }
        catch (OSSException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ClientException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesObjectExist(UploadConf oss, String objectName) {
        boolean found = false;
        OSSClient ossClient = null;
        try {
            ossClient = new OSSClient(oss.getEndpoint(), oss.getAccessKeyId(), oss.getAccessKeySecret());
            found = ossClient.doesObjectExist(objectName, objectName);
        }
        catch (OSSException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ClientException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return found;
    }

    public static String getContentType(String fileType) {
        fileType = fileType.toLowerCase();
        String contentType = "";
        switch (fileType) {
            case "bmp": {
                contentType = "image/bmp";
                break;
            }
            case "gif": {
                contentType = "image/gif";
                break;
            }
            case "png": {
                contentType = "image/png";
                break;
            }
            case "jpeg": {
                contentType = "image/jpeg";
                break;
            }
            case "jpg": {
                contentType = "image/jpg";
                break;
            }
            case "html": {
                contentType = "text/html";
                break;
            }
            case "txt": {
                contentType = "text/plain";
                break;
            }
            case "vsd": {
                contentType = "application/vnd.visio";
                break;
            }
            case "ppt": 
            case "pptx": {
                contentType = "application/vnd.ms-powerpoint";
                break;
            }
            case "doc": {
                contentType = "application/msword";
                break;
            }
            case "docx": {
                contentType = "application/msword";
                break;
            }
            case "xml": {
                contentType = "text/xml";
                break;
            }
            case "mp4": {
                contentType = "video/mp4";
                break;
            }
            default: {
                contentType = "application/octet-stream";
            }
        }
        return contentType;
    }

    public static InputStream downLoad(String objectName, UploadConf oss) {
        OSSClient ossClient = new OSSClient(oss.getEndpoint(), oss.getAccessKeyId(), oss.getAccessKeySecret());
        return ossClient.getObject(oss.getBucketName(), objectName).getObjectContent();
    }
}

