/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.entity.UploadFileEntity;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.service.OssUploadService;
import com.biz.crm.service.UploadFileService;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.OssUploadUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UploadConf;
import com.biz.crm.vo.DownLoadVo;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@ConditionalOnMissingBean(name={"ossUploadServiceExpandImpl"})
public class OssUploadServiceImpl
implements OssUploadService {
    private static final Logger log = LoggerFactory.getLogger(OssUploadServiceImpl.class);
    @Resource
    private UploadFileService uploadFileService;
    @Resource
    private UploadConf uploadConf;

    @Override
    public List<UploadVo> upload(MultipartFile[] fileList) {
        ArrayList<UploadVo> uploadVos = new ArrayList<UploadVo>();
        for (MultipartFile file : fileList) {
            String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            try {
                String objectName = uuid + "." + suffix.toLowerCase();
                objectName = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)suffix) ? suffix + "/" + DateUtil.date2Str((SimpleDateFormat)new SimpleDateFormat("yyyyMMdd")) + "/" + objectName : "default/" + DateUtil.date2Str((SimpleDateFormat)new SimpleDateFormat("yyyyMMdd")) + "/" + objectName;
                String url = OssUploadUtil.doOssType(this.uploadConf, objectName, file.getInputStream(), suffix);
                if (StringUtils.isEmpty((String)url)) {
                    throw new BusinessException("\u4e0a\u6b21\u5931\u8d25");
                }
                UploadVo temp = new UploadVo();
                temp.setUrl(url);
                temp.setFileName(file.getOriginalFilename());
                temp.setUrlPathPrefix(this.uploadConf.getReq_url().concat("/"));
                temp.setUrlPath(objectName);
                temp.setObjectName(objectName);
                uploadVos.add(temp);
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
                throw new BusinessException("\u4e0a\u6b21\u5931\u8d25");
            }
        }
        return uploadVos;
    }

    @Override
    public DownLoadVo download(String objectName) {
        UploadFileEntity uploadFileEntity = this.uploadFileService.findByObjectName(objectName);
        InputStream inputStream = OssUploadUtil.downLoad(objectName, this.uploadConf);
        return new DownLoadVo(Optional.ofNullable(uploadFileEntity.getFileName()).orElse(""), inputStream, uploadFileEntity.getFilePath());
    }

    @Override
    public String getType() {
        return "alibaba";
    }
}

