/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.entity.UploadFileEntity;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.service.ObsUploadService;
import com.biz.crm.service.UploadFileService;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UploadConf;
import com.biz.crm.vo.DownLoadVo;
import com.obs.services.ObsClient;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.PutObjectResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.multipart.MultipartFile;

@ConditionalOnMissingBean(name={"obsUploadServiceExpandImpl"})
public class ObsUploadServiceImpl
implements ObsUploadService {
    private static final Logger log = LoggerFactory.getLogger(ObsUploadServiceImpl.class);
    @Resource
    private UploadFileService uploadFileService;
    @Resource
    private UploadConf uploadConf;
    @Autowired
    private ObsClient obsClient;
    private static final String FILE_NAME = "%s%s%s%s";

    @Override
    public String getType() {
        return "huawei";
    }

    @Override
    public List<UploadVo> upload(MultipartFile[] fileList) {
        ArrayList<UploadVo> uploadVos = new ArrayList<UploadVo>();
        for (MultipartFile file : fileList) {
            String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            try {
                String objectName = uuid + "." + suffix.toLowerCase();
                objectName = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)suffix) ? suffix + "/" + DateUtil.date2Str((SimpleDateFormat)new SimpleDateFormat("yyyyMMdd")) + "/" + objectName : "default/" + DateUtil.date2Str((SimpleDateFormat)new SimpleDateFormat("yyyyMMdd")) + "/" + objectName;
                PutObjectRequest putObjectRequest = new PutObjectRequest(this.uploadConf.getBucketName(), objectName, (InputStream)new ByteArrayInputStream(file.getBytes()));
                PutObjectResult result = this.obsClient.putObject(putObjectRequest);
                log.info("====>objectName:" + objectName);
                if (result == null || !StringUtils.isNotEmpty((String)result.getObjectUrl())) {
                    throw new BusinessException("\u4e0a\u4f20\u5931\u8d25");
                }
                log.info("====>url:" + result.getObjectUrl());
                String url = this.uploadConf.getReq_url().concat("/").concat(objectName);
                UploadVo temp = new UploadVo();
                temp.setUrl(url);
                temp.setSuffix(suffix);
                temp.setFileName(file.getOriginalFilename());
                temp.setUrlPathPrefix(this.uploadConf.getReq_url().concat("/"));
                temp.setUrlPath(objectName);
                temp.setObjectName(objectName);
                uploadVos.add(temp);
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
                throw new BusinessException("\u4e0a\u4f20\u5931\u8d25");
            }
        }
        return uploadVos;
    }

    @Override
    public DownLoadVo download(String objectName) {
        UploadFileEntity entity = this.uploadFileService.findByObjectName(objectName);
        InputStream inputStream = null;
        try {
            ObsObject obsObject = this.obsClient.getObject(this.uploadConf.getBucketName(), objectName);
            return new DownLoadVo(entity.getFileName(), obsObject.getObjectContent(), entity.getFilePath(), "0");
        }
        catch (Exception e) {
            try {
                inputStream.close();
            }
            catch (Exception e1) {
                log.error("\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e1);
            }
            throw new BusinessException("\u4e0b\u8f7d\u5f02\u5e38");
        }
    }

    private String getTs() {
        return String.valueOf(System.currentTimeMillis());
    }
}

