/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.controller;

import com.biz.crm.service.UploadFileService;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.vo.DownLoadVo;
import io.swagger.annotations.Api;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/downloadController"})
@Api(tags={"\u6587\u4ef6\u4e0b\u8f7d\u8def\u5f84 "})
public class DownLoadController {
    @Resource
    private UploadFileService uploadFileService;
    @Value(value="${server.tomcat.basedir}")
    private String PATH;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/download"})
    public void downloadFile(@RequestParam(value="objectName") String objectName) {
        OutputStream ous = null;
        InputStream ins = null;
        try {
            HttpServletResponse response = HttpServletRequestUtil.getResponse();
            DownLoadVo downLoadVo = this.uploadFileService.download(objectName);
            ins = downLoadVo.getInputStream();
            byte[] buffer = new byte[ins.available()];
            ins.read(buffer);
            ins.close();
            response.reset();
            response.setHeader("Content-disposition", "attachment; filename=" + new String(downLoadVo.getFileName().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            if ("0".equals(downLoadVo.getLength())) {
                response.addHeader("Content-Length", String.valueOf(buffer.length));
            } else {
                response.addHeader("Content-Length", String.valueOf(downLoadVo.getLength()));
            }
            response.setContentType("application/octet-stream");
            ous = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ous.write(buffer);
            ous.flush();
            ous.close();
        }
        finally {
            if (ous != null) {
                ous.close();
            }
            if (ins != null) {
                ins.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/downloadExcelFile"})
    public void downloadExcelFile(@RequestParam(value="objectName") String objectName) {
        OutputStream ous = null;
        InputStream ins = null;
        try {
            HttpServletResponse response = HttpServletRequestUtil.getResponse();
            DownLoadVo downLoadVo = this.uploadFileService.download(objectName);
            ins = downLoadVo.getInputStream();
            byte[] buffer = new byte[ins.available()];
            ins.read(buffer);
            ins.close();
            response.reset();
            response.setHeader("Content-disposition", "attachment; filename=" + new String(downLoadVo.getFileName().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            if ("0".equals(downLoadVo.getLength())) {
                response.addHeader("Content-Length", String.valueOf(buffer.length));
            } else {
                response.addHeader("Content-Length", String.valueOf(downLoadVo.getLength()));
            }
            response.setContentType("application/octet-stream");
            ous = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ous.write(buffer);
            ous.flush();
            ous.close();
        }
        finally {
            if (ous != null) {
                ous.close();
            }
            if (ins != null) {
                ins.close();
            }
        }
    }
}

