/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.biz.crm.config.condition.LoaclCondition;
import com.biz.crm.config.condition.ObsCondition;
import com.biz.crm.config.condition.OssCondition;
import com.biz.crm.service.FileCommomService;
import com.biz.crm.service.impl.LocalUploadServiceImpl;
import com.biz.crm.service.impl.ObsUploadServiceImpl;
import com.biz.crm.service.impl.OssUploadServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class UploadConfig {
    private static final Logger log = LoggerFactory.getLogger(UploadConfig.class);

    @Conditional(value={OssCondition.class})
    @ConditionalOnMissingBean(name={"ossUploadServiceExpandImpl"})
    @Bean
    public FileCommomService initOss() {
        log.info("=====\u542f\u52a8\u963f\u91cc\u4e91\u5b58\u50a8=====");
        return new OssUploadServiceImpl();
    }

    @Conditional(value={LoaclCondition.class})
    @Bean
    @ConditionalOnMissingBean(name={"localUploadServiceExpandImpl"})
    public FileCommomService initLoacl() {
        log.info("=====\u542f\u52a8\u672c\u5730\u78c1\u76d8\u5b58\u50a8=====");
        return new LocalUploadServiceImpl();
    }

    @Conditional(value={ObsCondition.class})
    @ConditionalOnMissingBean(name={"obsUploadServiceExpandImpl"})
    @Bean
    public FileCommomService initObs() {
        log.info("=====\u542f\u52a8\u534e\u4e3a\u78c1\u76d8\u5b58\u50a8=====");
        return new ObsUploadServiceImpl();
    }
}

