/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.app.controller;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.sfa.app.entity.AppVersionEntity;
import com.biz.crm.sfa.app.service.AppVersionService;
import com.biz.crm.sfa.app.vo.AppVersionRedis;
import com.biz.crm.sfa.app.vo.AppVersionVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/version"})
@Api(tags={"APP\u7248\u672c\u7ba1\u7406 "})
public class AppVersionController {
    @Autowired
    private AppVersionService appVersionService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    public Result<PageResult<AppVersionVo>> pageList(@RequestBody AppVersionVo vo) {
        PageResult<AppVersionVo> result = this.appVersionService.findList(vo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    public Result<AppVersionEntity> detail(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new BusinessException("\u8bf7\u4f20\u5165id");
        }
        return Result.ok((Object)this.appVersionService.getById((Serializable)((Object)id)));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @PostMapping(value={"/saveOrUpdateEntity"})
    public Result saveOrUpdateEntity(@RequestBody AppVersionEntity entity) {
        this.appVersionService.saveOrUpdateEntity(entity);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        this.appVersionService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        this.appVersionService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        this.appVersionService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7248\u672c\u53f7", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appType", value="APP\u7c7b\u578b", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/getVersion"})
    public Result<AppVersionRedis> getVersion(@RequestParam(value="appType", required=false) String appType) {
        if (StringUtils.isEmpty((String)appType)) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u7c7b\u578bAPP\u7c7b\u578b");
        }
        return Result.ok((Object)this.appVersionService.getVersion(appType));
    }
}

