/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.entity.UploadFileEntity;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.service.LocalUploadService;
import com.biz.crm.service.UploadFileService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UploadConf;
import com.biz.crm.vo.DownLoadVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.multipart.MultipartFile;

public class LocalUploadServiceImpl
implements LocalUploadService {
    private static final Logger log = LoggerFactory.getLogger(LocalUploadServiceImpl.class);
    @Resource
    private UploadFileService uploadFileService;
    @Resource
    private UploadConf uploadConf;
    private static String localUrl = null;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;

    @Override
    public String getType() {
        return "local";
    }

    @Override
    public List<UploadVo> upload(MultipartFile[] fileList) {
        ArrayList<UploadVo> uploadVos = new ArrayList<UploadVo>();
        String filePath = this.uploadConf.getLocalPath();
        for (MultipartFile file : fileList) {
            String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
            String uuid = CodeUtil.getCodeDefault();
            try {
                String objectName = uuid + "." + suffix.toLowerCase();
                objectName = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)suffix) ? suffix + "/" + DateUtil.date2Str((SimpleDateFormat)new SimpleDateFormat("yyyyMMdd")) + "/" + objectName : "default/" + DateUtil.date2Str((SimpleDateFormat)new SimpleDateFormat("yyyyMMdd")) + "/" + objectName;
                String url = this.getUrl() + objectName;
                String realPath = filePath + objectName;
                File dest = new File(realPath);
                if (!dest.getParentFile().exists()) {
                    dest.getParentFile().mkdirs();
                }
                file.transferTo(dest);
                if (StringUtils.isEmpty((String)url)) {
                    throw new BusinessException("\u4e0a\u4f20\u5931\u8d25");
                }
                UploadVo temp = new UploadVo();
                temp.setUrl(url);
                temp.setSuffix(suffix);
                temp.setFileName(file.getOriginalFilename());
                temp.setUrlPathPrefix(this.uploadConf.getReq_url().concat("/"));
                temp.setUrlPath(realPath);
                temp.setObjectName(objectName);
                uploadVos.add(temp);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw new BusinessException("\u4e0a\u4f20\u5931\u8d25");
            }
        }
        return uploadVos;
    }

    private String getUrl() {
        if (localUrl == null) {
            return this.uploadConf.getReq_url() + this.contextPath + this.uploadConf.getEndpoint();
        }
        return localUrl;
    }

    @Override
    public DownLoadVo download(String objectName) {
        UploadFileEntity uploadFileEntity = this.uploadFileService.findByObjectName(objectName);
        if (uploadFileEntity == null) {
            throw new BusinessException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        InputStream inputStream = null;
        try {
            File file = new File(uploadFileEntity.getFilePath());
            inputStream = new FileInputStream(uploadFileEntity.getFilePath());
            return new DownLoadVo(Optional.ofNullable(uploadFileEntity.getFileName()).orElse(""), inputStream, uploadFileEntity.getFilePath(), String.valueOf(file.length()));
        }
        catch (Exception e) {
            try {
                inputStream.close();
            }
            catch (Exception e1) {
                log.error("\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e1);
            }
            throw new BusinessException("\u4e0b\u8f7d\u5f02\u5e38");
        }
    }
}

