/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.entity.UploadFileEntity;
import com.biz.crm.mapper.UploadFileMapper;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.service.FileCommomService;
import com.biz.crm.service.UploadFileService;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.ImageUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UploadConf;
import com.biz.crm.vo.DownLoadVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(rollbackFor={Exception.class})
public class UploadFileServiceImpl
extends ServiceImpl<UploadFileMapper, UploadFileEntity>
implements UploadFileService {
    @Autowired
    private FileCommomService fileCommomService;
    @Value(value="${server.tomcat.basedir}")
    private String BASEDIR;

    @Override
    public List<UploadVo> upload(MultipartFile[] fileList, UploadConf uploadConf) {
        this.valid(fileList);
        List<UploadVo> uploadVos = this.fileCommomService.upload(fileList);
        this.uploadFileStore(uploadVos);
        return uploadVos;
    }

    @Override
    public List<UploadVo> uploadOssWatermark(MultipartFile[] fileList, UploadConf uploadConf, String name, String address) {
        this.validPhoto(fileList);
        MultipartFile[] files = this.getWaterPress(fileList, name, address);
        List<UploadVo> uploadVos = this.fileCommomService.upload(files);
        this.uploadFileStore(uploadVos);
        return uploadVos;
    }

    private void validPhoto(MultipartFile[] fileList) {
        if (fileList == null || fileList.length < 1) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u6587\u4ef6");
        }
        for (MultipartFile file : fileList) {
            if (file == null) {
                throw new BusinessException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String fileName = file.getName();
            if (StringUtils.isEmpty((String)fileName)) {
                throw new BusinessException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
            if (suffix.equalsIgnoreCase("jpg") || suffix.equalsIgnoreCase("bmp") || suffix.equalsIgnoreCase("png") || suffix.equalsIgnoreCase("jpeg")) continue;
            throw new BusinessException("\u4e0d\u662f\u56fe\u7247\u683c\u5f0f\u6587\u4ef6");
        }
    }

    private void valid(MultipartFile[] fileList) {
        if (fileList == null || fileList.length < 1) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u6587\u4ef6");
        }
        for (MultipartFile file : fileList) {
            if (file == null) {
                throw new BusinessException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String fileName = file.getName();
            if (StringUtils.isEmpty((String)fileName)) {
                throw new BusinessException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
            if (!suffix.equalsIgnoreCase("sh") && !suffix.equalsIgnoreCase("jsp") && !suffix.equalsIgnoreCase("html")) continue;
            throw new BusinessException("\u975e\u6cd5\u6587\u4ef6\u4e0a\u4f20");
        }
    }

    @Override
    public UploadFileEntity findByObjectName(String objectName) {
        Assert.hasText((String)objectName, (String)"\u5bf9\u8c61\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        UploadFileEntity one = (UploadFileEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UploadFileEntity::getObjectName, (Object)objectName)).one());
        Assert.notNull((Object)((Object)one), (String)("\u6587\u4ef6[" + objectName + "]\u4e0d\u5b58\u5728"));
        Assert.hasText((String)one.getFilePath(), (String)("\u6587\u4ef6[" + objectName + "]\u8def\u5f84\u4e0d\u5b58\u5728"));
        return one;
    }

    @Override
    public DownLoadVo download(String objectName) {
        return this.fileCommomService.download(objectName);
    }

    private void uploadFileStore(List<UploadVo> uploadVos) {
        if (!CollectionUtils.isEmpty(uploadVos)) {
            List collect = uploadVos.stream().map(x -> new UploadFileEntity().setObjectName(x.getObjectName()).setFilePath(x.getUrlPath()).setFileName(x.getFileName()).setUrl(x.getUrl()).setSuffix(x.getSuffix())).collect(Collectors.toList());
            this.saveBatch(collect);
        }
    }

    private MultipartFile[] getWaterPress(MultipartFile[] files, String name, String address) {
        int i;
        MultipartFile[] fileList = new MultipartFile[files.length];
        StringBuilder filePaths = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u540d\u79f0\uff1a" + name + ",").append(",");
        if (address.length() > 10) {
            address = this.splitStr(address);
        }
        stringBuilder.append("\u6253\u5361\u65f6\u95f4\uff1a" + LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss)).append(",").append(",");
        stringBuilder.append("\u6253\u5361\u5730\u70b9\uff1a" + address + ",").append(",");
        for (int i2 = 0; i2 < files.length; ++i2) {
            MultipartFile file = files[i2];
            String fileName = file.getOriginalFilename();
            String filePath = this.BASEDIR + File.separator + fileName;
            File dest = new File(filePath);
            if (!dest.getParentFile().exists()) {
                dest.getParentFile().mkdirs();
            }
            file.transferTo(dest);
            if (filePaths.length() > 0) {
                filePaths.append(",");
            }
            filePaths.append(filePath);
        }
        String pathList = ImageUtils.waterPress(filePaths.toString(), stringBuilder.toString());
        String[] path = pathList.split(",");
        for (i = 0; i < path.length; ++i) {
            File photo = new File(path[i]);
            FileInputStream fileInputStream = new FileInputStream(photo);
            MockMultipartFile multipartFile = new MockMultipartFile(photo.getName(), photo.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            fileList[i] = multipartFile;
        }
        for (i = 0; i < path.length; ++i) {
            File file = new File(path[i]);
            if (!file.exists()) continue;
            file.delete();
        }
        return fileList;
    }

    private String splitStr(String address) {
        Integer num = address.length() / 10;
        if (address.length() % 10 > 5) {
            Integer n = num;
            Integer n2 = num = Integer.valueOf(num + 1);
        }
        String str = "";
        Integer in = 0;
        for (int i = 1; i < num + 1; ++i) {
            if (StringUtils.isNotEmpty((String)str)) {
                str = str + ", ,";
            }
            str = i != num ? str + address.substring(in, i * 10) : str + address.substring(in);
            in = in + 10;
        }
        return str;
    }
}

