/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHttpDownload {
    private static final Logger log = LoggerFactory.getLogger(FileHttpDownload.class);

    public static String backDownLoadFileUrl(String url, String fileUrl, String fileName) {
        String photoUrl = null;
        try {
            byte[] fileBt = FileHttpDownload.getFileFromNetByUrl(url);
            if (null != fileBt && fileBt.length > 0) {
                log.info("\u8bfb\u53d6\u5230:{}" + fileBt.length + "\u5b57\u8282");
                photoUrl = FileHttpDownload.writeFileToDisk(fileBt, fileName, fileUrl);
            } else {
                log.info("\u6ca1\u6709\u4ece\u8be5\u8fde\u63a5\u83b7\u5f97\u5185\u5bb9");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return photoUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFileToDisk(byte[] bytes, String fileName, String fileUrl) throws IOException {
        File file = null;
        FileOutputStream fops = null;
        try {
            log.info("\u9700\u8981\u653e\u5165\u7f51\u7edc\u6587\u4ef6\u7684\u672c\u5730\u5740\u5730\u5740\u662f:{}", (Object)fileUrl);
            file = new File(fileUrl + File.separator + fileName);
            if (!new File(fileUrl).exists()) {
                file.mkdirs();
            }
            fops = new FileOutputStream(file);
            fops.write(bytes);
            fops.flush();
            fops.close();
            file.getPath();
            log.info("\u6587\u4ef6\u5df2\u7ecf\u5199\u5165\u5230\u5df2\u7ecf\u5199\u5165\u5230:{}" + file.getPath());
        }
        finally {
            if (fops != null) {
                fops.close();
            }
            fops = null;
        }
        return file.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getFileFromNetByUrl(String strUrl) throws Exception {
        InputStream inStream = null;
        byte[] btImg = null;
        try {
            URL url = new URL(strUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            inStream = conn.getInputStream();
            btImg = FileHttpDownload.readInputStream(inStream);
            inStream.close();
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            inStream = null;
        }
        return btImg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
                outStream.flush();
            }
            inStream.close();
            outStream.close();
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            inStream = null;
            if (outStream != null) {
                outStream.close();
            }
        }
        return outStream.toByteArray();
    }
}

