/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.controller;

import com.biz.crm.nebular.upload.vo.UploadOffLineVo;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.service.UploadFileService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UploadConf;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/uploadController"})
@Api(tags={"\u6587\u4ef6\u8def\u5f84 "})
public class UploadController {
    private static final Logger log = LoggerFactory.getLogger(UploadController.class);
    @Autowired
    private UploadConf uploadConf;
    @Autowired
    private UploadFileService uploadFileService;

    @PostMapping(value={"/uploadOss"})
    @ApiOperation(value="\u5355\u4e2a\u4e0a\u4f20\u6587\u4ef6", notes="\u5355\u4e2aOSS\u4e0a\u4f20\u6587\u4ef6")
    public Result<List<UploadVo>> uploadOss(@RequestPart(value="file", required=false) MultipartFile file) {
        log.info("\u5355\u4e2a\u4e0a\u4f20\u6587\u4ef6");
        Assert.notNull((Object)file, (String)"\u8bf7\u5148\u9009\u62e9\u6587\u4ef6");
        Result result = new Result();
        MultipartFile[] fileList = new MultipartFile[]{file};
        List<UploadVo> uploadVos = this.uploadFileService.upload(fileList, this.uploadConf);
        result.setResult(uploadVos);
        return result;
    }

    @PostMapping(value={"/uploadOssList"}, headers={"content-type=multipart/form-data"})
    @ApiOperation(value="\u6279\u91cf\u4e0a\u4f20\u6587\u4ef6", notes="OSS\u6279\u91cf\u4e0a\u4f20\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u591a\u4e2a\u6587\u4ef6\uff0c", paramType="formData", allowMultiple=true, required=true, dataType="file")})
    public Result<List<UploadVo>> uploadOssList(@RequestParam(value="file", required=false) MultipartFile[] file) {
        log.info("\u6279\u91cf\u4e0a\u4f20\u6587\u4ef6");
        Assert.notEmpty((Object[])file, (String)"\u8bf7\u5148\u9009\u62e9\u6587\u4ef6");
        Result result = new Result();
        List<UploadVo> uploadVos = this.uploadFileService.upload(file, this.uploadConf);
        result.setResult(uploadVos);
        return result;
    }

    @PostMapping(value={"/uploadOssWatermark"})
    @ApiOperation(value="\u5355\u4e2a\u4e0a\u4f20\u56fe\u7247\u5e76\u6253\u6c34\u5370", notes="\u5355\u4e2aOSS\u4e0a\u4f20\u6587\u4ef6")
    public Result<List<UploadVo>> uploadOssWatermark(@RequestPart(value="file") MultipartFile file, @RequestParam(value="name", required=false) String name, @RequestParam(value="address") String address) {
        log.info("\u5355\u4e2a\u4e0a\u4f20\u56fe\u7247\u5e76\u6253\u6c34\u5370");
        if (StringUtils.isEmpty((CharSequence)name)) {
            UserRedis user = UserUtils.getUser();
            name = user.getRealname();
        }
        Result result = new Result();
        MultipartFile[] fileList = new MultipartFile[]{file};
        List<UploadVo> uploadVos = this.uploadFileService.uploadOssWatermark(fileList, this.uploadConf, name, address);
        result.setResult(uploadVos);
        return result;
    }

    @ApiOperation(value="\u5355\u4e2a\u4e0a\u4f20\u79bb\u7ebf\u6587\u4ef6", notes="\u5355\u4e2aOSS\u4e0a\u4f20\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u5355\u4e2a\u6587\u4ef6", paramType="formData", allowMultiple=true, required=true, dataType="file"), @ApiImplicitParam(name="keyFields", value="\u5173\u952e\u5b57\u6bb5/\u6807\u8bc6", paramType="formData", required=true, dataType="String")})
    @PostMapping(value={"uploadOssOffLine"})
    public Result<List<UploadOffLineVo>> uploadOssOffLine(@RequestPart(value="file") MultipartFile[] file, @RequestParam(value="keyFields") String keyFields) {
        log.info("\u5355\u4e2a\u4e0a\u4f20\u79bb\u7ebf\u6587\u4ef6\u6587\u4ef6");
        Assert.notNull((Object)file, (String)"\u8bf7\u5148\u9009\u62e9\u6587\u4ef6");
        Assert.notNull((Object)keyFields, (String)"\u5173\u952e\u5b57\u6bb5/\u6807\u8bc6\u4e0d\u53ef\u4e3a\u7a7a");
        Result result = new Result();
        List<UploadVo> uploadVos = this.uploadFileService.upload(file, this.uploadConf);
        List uploadOffLineVos = uploadVos.stream().map(data -> {
            UploadOffLineVo offLineVo = (UploadOffLineVo)CrmBeanUtil.copy((Object)data, UploadOffLineVo.class);
            offLineVo.setKeyFields(keyFields);
            return offLineVo;
        }).collect(Collectors.toList());
        result.setResult(uploadOffLineVos);
        return result;
    }
}

