/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static final Logger log = LoggerFactory.getLogger(ImageUtils.class);

    public static String waterPress(String srcImgPaths, String waterMarkContent) {
        String[] filePaths = srcImgPaths.split(",");
        String[] waterMarkContents = waterMarkContent.split(",");
        for (int k = 0; k < filePaths.length; ++k) {
            String srcImgPath = filePaths[k];
            try {
                File srcImgFile = new File(srcImgPath);
                BufferedImage srcImg = ImageIO.read(srcImgFile);
                int srcImgWidth = ((Image)srcImg).getWidth(null);
                int srcImgHeight = ((Image)srcImg).getHeight(null);
                BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
                Graphics2D g = bufImg.createGraphics();
                g.drawImage(srcImg, 0, 0, srcImgWidth, srcImgHeight, null);
                Font font = new Font("\u5b8b\u4f53", 2, 60);
                g.setColor(Color.red);
                g.setFont(font);
                int contentLength = waterMarkContents.length;
                int maxLength = 0;
                for (int i = 0; i < contentLength; ++i) {
                    int fontlen = ImageUtils.getWatermarkLength(waterMarkContents[i], g);
                    if (maxLength >= fontlen) continue;
                    maxLength = fontlen;
                }
                for (int j = 0; j < contentLength; ++j) {
                    waterMarkContent = waterMarkContents[j];
                    int tempX = 10;
                    int tempY = 30;
                    int tempCharLen = 0;
                    int tempLineLen = 0;
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < waterMarkContent.length(); ++i) {
                        char tempChar = waterMarkContent.charAt(i);
                        tempCharLen = ImageUtils.getCharLen(tempChar, g);
                        if ((tempLineLen += tempCharLen) >= srcImgWidth) {
                            g.drawString(sb.toString(), tempX, tempY);
                            sb.delete(0, sb.length());
                            tempLineLen = 0;
                        }
                        sb.append(tempChar);
                    }
                    g.drawString(sb.toString(), srcImgWidth - maxLength, srcImgHeight - (contentLength - j - 1) * tempY);
                }
                g.dispose();
                FileOutputStream outImgStream = new FileOutputStream(srcImgPath);
                ImageIO.write((RenderedImage)bufImg, "jpg", outImgStream);
                outImgStream.flush();
                outImgStream.close();
                continue;
            }
            catch (Exception e) {
                log.warn("\u56fe\u7247\u52a0\u6c34\u5370\u5931\u8d25....");
            }
        }
        return srcImgPaths;
    }

    private static int getCharLen(char c, Graphics2D g) {
        return g.getFontMetrics(g.getFont()).charWidth(c);
    }

    private static int getWatermarkLength(String waterMarkContent, Graphics2D g) {
        return g.getFontMetrics(g.getFont()).charsWidth(waterMarkContent.toCharArray(), 0, waterMarkContent.length());
    }
}

