/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AmazonS3Config {
    @Value(value="${oss.accessKeyId}")
    private String accessKeyId;
    @Value(value="${oss.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${oss.endpoint}")
    public String endpoint;
    @Value(value="${oss.bucketName}")
    public String bucketName;

    @Bean
    public AmazonS3 s3client() {
        ClientConfiguration config = new ClientConfiguration();
        config.setProtocol(Protocol.HTTP);
        config.disableSocketProxy();
        AmazonS3 s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(config)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessKeyId, this.accessKeySecret)))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpoint, Regions.CN_NORTH_1.getName()))).enablePathStyleAccess()).build();
        return s3Client;
    }
}

