/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.util.FreeMarkUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class WordUtil {
    private static final Logger log = LoggerFactory.getLogger(WordUtil.class);
    private static String BASE_DIR;
    private static String STORAGE_TYPE;

    @Value(value="${server.tomcat.basedir}")
    public void setBaseDir(String baseDir) {
        BASE_DIR = baseDir;
    }

    @Value(value="${oss.type:local}")
    public void setStorageType(String storageType) {
        STORAGE_TYPE = storageType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createDocx(Map dataMap, String wordName, String templateName, String zipTemplateName) {
        ZipOutputStream zipout = null;
        String wordPath = "";
        FileOutputStream outputStream = null;
        InputStream resourceAsStream = null;
        ByteArrayInputStream documentInput = null;
        try {
            documentInput = FreeMarkUtils.getFreemarkerContentInputStream(dataMap, templateName);
            String path = BASE_DIR + File.separator + wordName;
            File zipFolderPath = new File(path);
            if (!zipFolderPath.exists()) {
                zipFolderPath.mkdirs();
            }
            ClassPathResource classPathResource = new ClassPathResource("templates" + File.separator + zipTemplateName);
            resourceAsStream = classPathResource.getInputStream();
            File zipFilePath = new File(path + File.separator + resourceAsStream);
            FileUtils.copyInputStreamToFile((InputStream)resourceAsStream, (File)zipFilePath);
            wordPath = path + File.separator + wordName + ".docx";
            outputStream = new FileOutputStream(wordPath);
            ZipFile zipFile = new ZipFile(zipFilePath);
            Enumeration<? extends ZipEntry> zipEntrys = zipFile.entries();
            zipout = new ZipOutputStream(outputStream);
            int len = -1;
            byte[] buffer = new byte[1024];
            while (zipEntrys.hasMoreElements()) {
                ZipEntry next = zipEntrys.nextElement();
                InputStream is = zipFile.getInputStream(next);
                if (next.toString().indexOf("media") >= 0) continue;
                zipout.putNextEntry(new ZipEntry(next.getName()));
                if ("word/document.xml".equals(next.getName())) {
                    if (documentInput == null) continue;
                    while ((len = documentInput.read(buffer)) != -1) {
                        zipout.write(buffer, 0, len);
                    }
                    documentInput.close();
                    continue;
                }
                while ((len = is.read(buffer)) != -1) {
                    zipout.write(buffer, 0, len);
                }
                is.close();
            }
            WordUtil.safeClose(zipout);
        }
        catch (Exception e) {
            log.warn("\u751f\u6210\u5931\u8d25{}", (Object)e.getMessage());
            String string = null;
            return string;
        }
        finally {
            WordUtil.safeClose(zipout);
            WordUtil.safeClose(outputStream);
            WordUtil.safeClose(resourceAsStream);
            WordUtil.safeClose(documentInput);
        }
        WordUtil.safeClose(outputStream);
        WordUtil.safeClose(resourceAsStream);
        WordUtil.safeClose(documentInput);
        return wordPath;
    }

    /*
     * Exception decompiling
     */
    public static String sealInWord(String srcPath, String wordName, String sealPath, String tabText, int width, int height, int leftOffset, int topOffset, boolean behind) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static CTAnchor getAnchorWithGraphic(CTGraphicalObject ctGraphicalObject, String deskFileName, int width, int height, int leftOffset, int topOffset, boolean behind) {
        System.out.println(">>width>>" + width + "; >>height>>>>" + height);
        String anchorXML = "<wp:anchor xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" simplePos=\"0\" relativeHeight=\"0\" behindDoc=\"" + (behind ? 1 : 0) + "\" locked=\"0\" layoutInCell=\"1\" allowOverlap=\"1\"><wp:simplePos x=\"0\" y=\"0\"/><wp:positionH relativeFrom=\"column\"><wp:posOffset>" + leftOffset + "</wp:posOffset></wp:positionH><wp:positionV relativeFrom=\"paragraph\"><wp:posOffset>" + topOffset + "</wp:posOffset></wp:positionV><wp:extent cx=\"" + width + "\" cy=\"" + height + "\"/><wp:effectExtent l=\"0\" t=\"0\" r=\"0\" b=\"0\"/><wp:wrapNone/><wp:docPr id=\"1\" name=\"Drawing 0\" descr=\"" + deskFileName + "\"/><wp:cNvGraphicFramePr/></wp:anchor>";
        CTDrawing drawing = null;
        try {
            drawing = CTDrawing.Factory.parse((String)anchorXML);
        }
        catch (XmlException e) {
            log.error("\u6dfb\u52a0\u7b7e\u540d\u5f02\u5e38XmlException\uff1a{}", (Object)e.getMessage());
        }
        CTAnchor anchor = drawing.getAnchorArray(0);
        anchor.setGraphic(ctGraphicalObject);
        return anchor;
    }

    public static void deleteTemporaryFile(String wordName) {
        File directory = new File(BASE_DIR + File.separator + wordName);
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            log.info("\u8f6c\u6362\u4e34\u65f6\u6587\u4ef6\u5220\u9664\u5931\u8d25!");
        }
    }

    public static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void safeClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

