/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.service.RedisService;
import com.biz.crm.sfa.app.entity.AppVersionEntity;
import com.biz.crm.sfa.app.mapper.AppVersionMapper;
import com.biz.crm.sfa.app.service.AppVersionService;
import com.biz.crm.sfa.app.vo.AppVersionRedis;
import com.biz.crm.sfa.app.vo.AppVersionVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AppVersionServiceImpl
extends ServiceImpl<AppVersionMapper, AppVersionEntity>
implements AppVersionService {
    @Resource
    private AppVersionMapper appVersionMapper;
    @Autowired
    private RedisService redisService;

    @Override
    public PageResult<AppVersionVo> findList(AppVersionVo vo) {
        Page page = PageUtil.buildPage((Integer)vo.getPageNum(), (Integer)vo.getPageSize());
        List<AppVersionVo> list = this.appVersionMapper.findList((Page<AppVersionVo>)page, vo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void saveOrUpdateEntity(AppVersionEntity entity) {
        AssertUtils.isNotEmpty((String)entity.getAppVersion(), (String)"\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)entity.getRemarks(), (String)"\u8bf7\u8f93\u5165\u5907\u6ce8\u4fe1\u606f");
        AssertUtils.isNotEmpty((String)entity.getAppType(), (String)"\u7c7b\u578bapp\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)entity.getForceUpdate(), (String)"\u662f\u5426\u5f3a\u5236\u66f4\u65b0");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"app_type", (Object)entity.getAppType());
        if (StringUtils.isEmpty((String)entity.getId())) {
            queryWrapper.eq((Object)"app_version", (Object)entity.getAppVersion());
            List list = this.list((Wrapper)queryWrapper);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                throw new BusinessException(entity.getAppVersion() + "\u5df2\u5b58\u5728");
            }
            this.save((Object)entity);
        } else {
            AppVersionEntity oldEntity = (AppVersionEntity)((Object)this.getById((Serializable)((Object)entity.getId())));
            if (!oldEntity.getAppVersion().equals(entity.getAppVersion())) {
                throw new BusinessException("\u4e0d\u80fd\u4fee\u6539\u7248\u672c\u53f7\uff01");
            }
            if (!oldEntity.getAppType().equals(entity.getAppType())) {
                throw new BusinessException("\u4e0d\u80fd\u4fee\u6539\u7c7b\u578bapp\u7c7b\u578b\uff01");
            }
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)oldEntity));
            this.updateById((Object)oldEntity);
            this.deleteRedis(oldEntity.getAppType());
        }
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5220\u9664\u6570\u636e");
        }
        for (String id : ids) {
            AppVersionEntity entity = (AppVersionEntity)((Object)this.getById((Serializable)((Object)id)));
            entity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            this.updateById((Object)entity);
            this.deleteRedis(entity.getAppType());
        }
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u6570\u636e");
        }
        for (String id : ids) {
            AppVersionEntity entity = (AppVersionEntity)((Object)this.getById((Serializable)((Object)id)));
            entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            this.updateById((Object)entity);
            this.deleteRedis(entity.getAppType());
        }
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u6570\u636e");
        }
        for (String id : ids) {
            AppVersionEntity entity = (AppVersionEntity)((Object)this.getById((Serializable)((Object)id)));
            entity.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            this.updateById((Object)entity);
            this.deleteRedis(entity.getAppType());
        }
    }

    @Override
    public AppVersionRedis getVersion(String appType) {
        AppVersionRedis appVersionRedis = null;
        appVersionRedis = this.getRedis(appType);
        if (appVersionRedis != null) {
            return appVersionRedis;
        }
        appVersionRedis = this.appVersionMapper.getMax(appType);
        if (appVersionRedis == null) {
            throw new BusinessException("\u672a\u914d\u7f6e\u7248\u672c\u6570\u636e");
        }
        this.setRedis(appVersionRedis);
        return appVersionRedis;
    }

    private AppVersionRedis getRedis(String appType) {
        AppVersionRedis redis = null;
        Object o = this.redisService.get(this.getRedisKey(appType));
        if (o != null && StringUtils.isEmpty((String)(redis = (AppVersionRedis)o).getAppVersion())) {
            redis = null;
        }
        return redis;
    }

    private void setRedis(AppVersionRedis appVersionRedis) {
        this.redisService.set(this.getRedisKey(appVersionRedis.getAppType()), (Object)appVersionRedis);
    }

    private String getRedisKey(String appType) {
        String key = "APP_VERSION:" + appType;
        return key;
    }

    private void deleteRedis(String appType) {
        this.redisService.del(new String[]{this.getRedisKey(appType)});
    }
}

